/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.commands;

import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import net.dries007.tfc.common.TFCTags;
import net.dries007.tfc.common.items.PropickItem;
import net.dries007.tfc.common.items.ProspectResult;
import net.dries007.tfc.util.Helpers;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;

public class PropickCommand {
    public static LiteralArgumentBuilder<CommandSourceStack> create() {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"propick").requires(source -> source.hasPermission(2))).then(Commands.literal((String)"scan").executes(cmd -> PropickCommand.scan((CommandSourceStack)cmd.getSource())))).then(Commands.literal((String)"clearworld").executes(cmd -> PropickCommand.clearWorld((CommandSourceStack)cmd.getSource())));
    }

    public static int scan(CommandSourceStack source) {
        Object2IntMap<Block> found = PropickItem.scanAreaFor((Level)source.getLevel(), BlockPos.containing((Position)source.getPosition()), 12, TFCTags.Blocks.PROSPECTABLE);
        if (found.isEmpty()) {
            source.sendSuccess(() -> ProspectResult.NOTHING.getText(Blocks.AIR), true);
        } else {
            for (Object2IntMap.Entry entry : found.object2IntEntrySet()) {
                source.sendSuccess(() -> Component.translatable((String)"tfc.commands.propick.found_blocks", (Object[])new Object[]{entry.getIntValue(), ((Block)entry.getKey()).getName()}), true);
            }
        }
        return 1;
    }

    public static int clearWorld(CommandSourceStack source) {
        ServerLevel level = source.getLevel();
        BlockPos center = BlockPos.containing((Position)source.getPosition());
        int radius = 12;
        BlockState air = Blocks.AIR.defaultBlockState();
        int found = 0;
        int cleared = 0;
        for (BlockPos cursor : BlockPos.betweenClosed((int)(center.getX() - 12), (int)(center.getY() - 12), (int)(center.getZ() - 12), (int)(center.getX() + 12), (int)(center.getY() + 12), (int)(center.getZ() + 12))) {
            BlockState state = level.getBlockState(cursor);
            if (!Helpers.isBlock(state, TFCTags.Blocks.PROSPECTABLE)) {
                level.setBlock(cursor, air, 18);
                ++cleared;
                continue;
            }
            ++found;
        }
        int finalFound = found;
        int finalCleared = cleared;
        source.sendSuccess(() -> Component.translatable((String)"tfc.commands.propick.cleared", (Object[])new Object[]{finalFound, finalCleared}), true);
        return 1;
    }
}

