/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.commands;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import net.dries007.tfc.util.calendar.Calendars;
import net.dries007.tfc.util.calendar.ICalendar;
import net.dries007.tfc.util.climate.Climate;
import net.dries007.tfc.util.climate.ClimateModel;
import net.dries007.tfc.util.tracker.WeatherHelpers;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;

public final class TimeCommand {
    public static LiteralArgumentBuilder<CommandSourceStack> create() {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"time").requires(source -> source.hasPermission(2))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"set").then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"dayLength").then(Commands.literal((String)"vanilla").executes(c -> TimeCommand.setDayLength((CommandContext<CommandSourceStack>)c, 20)))).then(Commands.literal((String)"default").executes(c -> TimeCommand.setDayLength((CommandContext<CommandSourceStack>)c, 24)))).then(Commands.literal((String)"disabled").executes(c -> TimeCommand.setDayLength((CommandContext<CommandSourceStack>)c, -1)))).then(Commands.literal((String)"realtime").executes(c -> TimeCommand.setDayLength((CommandContext<CommandSourceStack>)c, 1440)))).then(Commands.argument((String)"minutes", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(c -> TimeCommand.setDayLength((CommandContext<CommandSourceStack>)c, IntegerArgumentType.getInteger((CommandContext)c, (String)"minutes")))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"monthLength").then(Commands.literal((String)"default").executes(c -> TimeCommand.setMonthLength((CommandContext<CommandSourceStack>)c, 8)))).then(Commands.literal((String)"realtime").executes(c -> TimeCommand.setMonthLength((CommandContext<CommandSourceStack>)c, 30)))).then(Commands.argument((String)"days", (ArgumentType)IntegerArgumentType.integer((int)1, (int)1000)).executes(c -> TimeCommand.setMonthLength((CommandContext<CommandSourceStack>)c, IntegerArgumentType.getInteger((CommandContext)c, (String)"days")))))).then(Commands.literal((String)"day").executes(c -> TimeCommand.setTimeFromDayTime((CommandContext<CommandSourceStack>)c, 0.3f)))).then(Commands.literal((String)"noon").executes(c -> TimeCommand.setTimeFromDayTime((CommandContext<CommandSourceStack>)c, 0.5f)))).then(Commands.literal((String)"night").executes(c -> TimeCommand.setTimeFromDayTime((CommandContext<CommandSourceStack>)c, 0.8f)))).then(Commands.literal((String)"midnight").executes(c -> TimeCommand.setTimeFromDayTime((CommandContext<CommandSourceStack>)c, 0.0f)))).then(Commands.literal((String)"hour").then(Commands.argument((String)"hour", (ArgumentType)IntegerArgumentType.integer((int)0, (int)24)).executes(c -> TimeCommand.setTimeFromDayTime((CommandContext<CommandSourceStack>)c, IntegerArgumentType.getInteger((CommandContext)c, (String)"hour") == 24 ? 0.0f : (float)IntegerArgumentType.getInteger((CommandContext)c, (String)"hour") * 0.041666f))))).then(Commands.literal((String)"rain").executes(c -> TimeCommand.setTimeFromWeather((CommandContext<CommandSourceStack>)c, true)))).then(Commands.literal((String)"clear").executes(c -> TimeCommand.setTimeFromWeather((CommandContext<CommandSourceStack>)c, false))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"add").then(Commands.literal((String)"years").then(Commands.argument((String)"years", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(context -> TimeCommand.addTime((CommandContext<CommandSourceStack>)context, (long)IntegerArgumentType.getInteger((CommandContext)context, (String)"years") * Calendars.SERVER.getCalendarTicksInYear()))))).then(Commands.literal((String)"months").then(Commands.argument((String)"months", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(context -> TimeCommand.addTime((CommandContext<CommandSourceStack>)context, (long)IntegerArgumentType.getInteger((CommandContext)context, (String)"months") * Calendars.SERVER.getCalendarTicksInMonth()))))).then(Commands.literal((String)"days").then(Commands.argument((String)"days", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(context -> TimeCommand.addTime((CommandContext<CommandSourceStack>)context, (long)IntegerArgumentType.getInteger((CommandContext)context, (String)"days") * 24000L))))).then(Commands.literal((String)"hours").then(Commands.argument((String)"hours", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(context -> TimeCommand.addTime((CommandContext<CommandSourceStack>)context, (long)IntegerArgumentType.getInteger((CommandContext)context, (String)"hours") * 1000L))))).then(Commands.argument((String)"ticks", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(context -> TimeCommand.addTime((CommandContext<CommandSourceStack>)context, IntegerArgumentType.getInteger((CommandContext)context, (String)"ticks")))));
    }

    private static int setDayLength(CommandContext<CommandSourceStack> context, int dayLengthInMinutes) {
        Calendars.SERVER.setCalendarTickRate(dayLengthInMinutes == -1 ? 0.0f : 20.0f / (float)dayLengthInMinutes);
        ((CommandSourceStack)context.getSource()).sendSuccess(() -> dayLengthInMinutes != -1 ? Component.translatable((String)"tfc.commands.time.set_day_length", (Object[])new Object[]{dayLengthInMinutes}) : Component.translatable((String)"tfc.commands.time.set_day_length_disabled"), true);
        return 1;
    }

    private static int setMonthLength(CommandContext<CommandSourceStack> context, int monthLengthInDays) {
        Calendars.SERVER.setMonthLength(monthLengthInDays);
        ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.translatable((String)"tfc.commands.time.set_month_length", (Object[])new Object[]{monthLengthInDays}), true);
        return 1;
    }

    private static int setTimeFromDayTime(CommandContext<CommandSourceStack> context, float fractionOfDay) {
        float currentFractionOfDay = Calendars.SERVER.getCalendarFractionOfDay();
        float targetFraction = fractionOfDay > currentFractionOfDay ? fractionOfDay : 1.0f + fractionOfDay;
        return TimeCommand.addTime(context, (long)((targetFraction - currentFractionOfDay) * 24000.0f));
    }

    private static int setTimeFromWeather(CommandContext<CommandSourceStack> context, boolean rain) {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        ClimateModel model = Climate.get((Level)source.getLevel());
        long calendarTick = Calendars.SERVER.getCalendarTicks();
        float rainfall = model.getRainfall((LevelReader)source.getLevel(), BlockPos.containing((Position)source.getPosition()));
        for (int tick = 0; tick < 400000; tick += 1000) {
            if (WeatherHelpers.isPrecipitating(model.getRain(calendarTick + (long)tick), rainfall) != rain) continue;
            return TimeCommand.addTime(context, tick);
        }
        return 1;
    }

    private static int addTime(CommandContext<CommandSourceStack> context, long ticksToAdd) {
        Calendars.SERVER.skipForwardBy(ticksToAdd);
        ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.translatable((String)"tfc.commands.time.add_time", (Object[])new Object[]{ICalendar.getTimeDelta(ticksToAdd, Calendars.SERVER.getCalendarDaysInMonth()), ticksToAdd}), true);
        return 1;
    }
}

