/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.component.block;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import net.dries007.tfc.common.component.item.ItemComponent;
import net.dries007.tfc.util.Helpers;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.fluids.FluidStack;

public record BarrelComponent(List<ItemStack> itemContent, FluidStack fluidContent, long sealedTick, long recipeTick) {
    public static final Codec<BarrelComponent> CODEC = RecordCodecBuilder.create(i -> i.group((App)ItemStack.OPTIONAL_CODEC.listOf().fieldOf("items").forGetter(c -> c.itemContent), (App)FluidStack.OPTIONAL_CODEC.fieldOf("fluid").forGetter(c -> c.fluidContent), (App)Codec.LONG.optionalFieldOf("sealedTick", (Object)-1L).forGetter(c -> c.sealedTick), (App)Codec.LONG.optionalFieldOf("recipeTick", (Object)-1L).forGetter(c -> c.recipeTick)).apply((Applicative)i, BarrelComponent::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, BarrelComponent> STREAM_CODEC = StreamCodec.composite((StreamCodec)ItemStack.OPTIONAL_STREAM_CODEC.apply(ByteBufCodecs.list()), c -> c.itemContent, (StreamCodec)FluidStack.OPTIONAL_STREAM_CODEC, c -> c.fluidContent, (StreamCodec)ByteBufCodecs.VAR_LONG, c -> c.sealedTick, (StreamCodec)ByteBufCodecs.VAR_LONG, c -> c.recipeTick, BarrelComponent::new);
    public static final BarrelComponent EMPTY = new BarrelComponent(Collections.nCopies(3, ItemStack.EMPTY), FluidStack.EMPTY, -1L, -1L);

    public boolean isEmpty() {
        return this.fluidContent.isEmpty() && Helpers.isEmpty(this.itemContent);
    }

    public boolean hasActiveRecipe() {
        return this.recipeTick != -1L;
    }

    BarrelComponent with(FluidStack content) {
        return new BarrelComponent(this.itemContent, content, this.sealedTick, this.recipeTick);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object obj) {
        if (this == obj) return true;
        if (!(obj instanceof BarrelComponent)) return false;
        BarrelComponent that = (BarrelComponent)obj;
        if (!ItemComponent.equals(this.itemContent, that.itemContent)) return false;
        if (!FluidStack.matches((FluidStack)this.fluidContent, (FluidStack)that.fluidContent)) return false;
        if (this.sealedTick != that.sealedTick) return false;
        if (this.recipeTick != that.recipeTick) return false;
        return true;
    }

    @Override
    public int hashCode() {
        return Objects.hash(ItemComponent.hashCode(this.itemContent), FluidStack.hashFluidAndComponents((FluidStack)this.fluidContent), this.sealedTick, this.recipeTick);
    }
}

