/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.component.food;

import java.util.Collection;
import java.util.function.Consumer;
import net.dries007.tfc.TerraFirmaCraft;
import net.dries007.tfc.common.component.TFCComponents;
import net.dries007.tfc.common.component.food.FoodComponent;
import net.dries007.tfc.common.component.food.FoodData;
import net.dries007.tfc.common.component.food.FoodDefinition;
import net.dries007.tfc.common.component.food.FoodTrait;
import net.dries007.tfc.common.component.food.IFood;
import net.dries007.tfc.common.recipes.RecipeHelpers;
import net.dries007.tfc.config.TFCConfig;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.calendar.Calendars;
import net.dries007.tfc.util.collections.IndirectHashCollection;
import net.dries007.tfc.util.data.DataManager;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeManager;
import org.jetbrains.annotations.Nullable;

public final class FoodCapability {
    public static final DataManager<FoodDefinition> MANAGER = new DataManager<FoodDefinition>(Helpers.identifier("food"), FoodDefinition.CODEC, FoodDefinition.STREAM_CODEC);
    public static final IndirectHashCollection<Item, FoodDefinition> CACHE = IndirectHashCollection.create(r -> RecipeHelpers.itemKeys(r.ingredient()), MANAGER::getValues);
    private static final int DEFAULT_DECAY_TICKS = 528000;

    @Nullable
    public static IFood get(ItemStack stack) {
        return (IFood)stack.get(TFCComponents.FOOD);
    }

    public static boolean has(ItemStack stack) {
        return stack.has(TFCComponents.FOOD);
    }

    @Nullable
    public static FoodDefinition getDefinition(ItemStack stack) {
        return RecipeHelpers.getRecipe(CACHE, stack, stack.getItem());
    }

    public static void setFoodForDynamicItemOnCreate(ItemStack stack, FoodData data) {
        @Nullable FoodComponent food = (FoodComponent)stack.get(TFCComponents.FOOD);
        if (food != null) {
            stack.set(TFCComponents.FOOD, (Object)food.with(data, FoodCapability.getRoundedCreationDate()));
        }
    }

    public static ItemStack applyTrait(ItemStack stack, Holder<FoodTrait> trait) {
        @Nullable FoodComponent food = (FoodComponent)stack.get(TFCComponents.FOOD);
        if (food != null && !food.hasTrait(trait) && !food.isRotten()) {
            stack.set(TFCComponents.FOOD, (Object)food.withTraitApplied(trait, FoodCapability.calculateNewCreationDate(food.getCreationDate(), 1.0f / ((FoodTrait)trait.value()).getDecayModifier())));
        }
        return stack;
    }

    public static ItemStack removeTrait(ItemStack stack, Holder<FoodTrait> trait) {
        @Nullable FoodComponent food = (FoodComponent)stack.get(TFCComponents.FOOD);
        if (food != null && food.hasTrait(trait)) {
            stack.set(TFCComponents.FOOD, (Object)food.withTraitRemoved(trait, FoodCapability.calculateNewCreationDate(food.getCreationDate(), ((FoodTrait)trait.value()).getDecayModifier())));
        }
        return stack;
    }

    public static boolean hasTrait(ItemStack stack, Holder<FoodTrait> trait) {
        @Nullable FoodComponent food = (FoodComponent)stack.get(TFCComponents.FOOD);
        return food != null && food.hasTrait(trait);
    }

    public static boolean isRotten(ItemStack stack) {
        @Nullable FoodComponent food = (FoodComponent)stack.get(TFCComponents.FOOD);
        return food != null && food.isRotten();
    }

    public static void addTooltipInfo(ItemStack stack, Consumer<Component> tooltip) {
        @Nullable FoodComponent food = (FoodComponent)stack.get(TFCComponents.FOOD);
        if (food != null) {
            food.addTooltipInfo(stack, tooltip);
        }
    }

    public static ItemStack setCreationDate(ItemStack stack, long date) {
        if (!TFCComponents.FOOD.holder().isBound()) {
            return stack;
        }
        @Nullable FoodComponent food = (FoodComponent)stack.get(TFCComponents.FOOD);
        if (food != null) {
            stack.set(TFCComponents.FOOD, (Object)food.with(date));
        }
        return stack;
    }

    public static ItemStack setCreatedNow(ItemStack stack) {
        return FoodCapability.setCreationDate(stack, FoodCapability.getRoundedCreationDate());
    }

    public static ItemStack setTransientNonDecaying(ItemStack stack) {
        return FoodCapability.setCreationDate(stack, -1L);
    }

    public static ItemStack setInvisibleNonDecaying(ItemStack stack) {
        return FoodCapability.setCreationDate(stack, -2L);
    }

    public static ItemStack setNonDecaying(ItemStack stack) {
        return FoodCapability.setCreationDate(stack, -3L);
    }

    public static ItemStack setRotten(ItemStack stack) {
        return FoodCapability.setCreationDate(stack, -4L);
    }

    public static ItemStack updateFoodFromPrevious(ItemStack oldStack, ItemStack newStack) {
        @Nullable FoodComponent oldFood = (FoodComponent)oldStack.get(TFCComponents.FOOD);
        @Nullable FoodComponent newFood = (FoodComponent)newStack.get(TFCComponents.FOOD);
        if (oldFood != null && newFood != null) {
            FoodComponent tempFood = newFood.withTraitsApplied(oldFood.getTraits());
            float decayDelta = tempFood.getDecayDateModifier() / oldFood.getDecayDateModifier();
            newStack.set(TFCComponents.FOOD, (Object)tempFood.with(FoodCapability.calculateNewRoundedCreationDate(oldFood.getCreationDate(), decayDelta)));
        }
        return newStack;
    }

    public static ItemStack updateFoodFromAllPrevious(Collection<ItemStack> oldStacks, ItemStack newStack) {
        @Nullable FoodComponent newFood = (FoodComponent)newStack.get(TFCComponents.FOOD);
        if (newFood != null) {
            if (oldStacks.isEmpty()) {
                return newStack;
            }
            float decayDateModifier = 0.0f;
            long oldCreationDate = Long.MAX_VALUE;
            int oldFoodCount = 0;
            for (ItemStack oldStack : oldStacks) {
                @Nullable FoodComponent oldFood = (FoodComponent)oldStack.get(TFCComponents.FOOD);
                if (oldFood == null) continue;
                decayDateModifier += oldFood.getDecayDateModifier();
                oldCreationDate = Math.min(oldCreationDate, oldFood.getCreationDate());
                ++oldFoodCount;
            }
            if (oldFoodCount > 0) {
                float decayDelta = (float)oldFoodCount * newFood.getDecayDateModifier() / decayDateModifier;
                newStack.set(TFCComponents.FOOD, (Object)newFood.with(FoodCapability.calculateNewCreationDate(oldCreationDate, decayDelta)));
            }
        }
        return newStack;
    }

    public static void markRecipeOutputsAsNonDecaying(RegistryAccess registryAccess, RecipeManager manager) {
        for (RecipeHolder recipe : manager.getRecipes()) {
            @Nullable ItemStack stack = recipe.value().getResultItem((HolderLookup.Provider)registryAccess);
            if (stack != null) {
                FoodCapability.setTransientNonDecaying(stack);
                continue;
            }
            TerraFirmaCraft.LOGGER.warn("Other mod issue: recipe with a null getResultItem(), in recipe {} of class {}", (Object)recipe.id(), (Object)recipe.getClass().getName());
        }
    }

    public static ItemStack mergeItemStacks(ItemStack stackToMergeInto, ItemStack stackToMerge) {
        if (stackToMerge.isEmpty()) {
            return stackToMergeInto;
        }
        if (stackToMergeInto.isEmpty()) {
            ItemStack merged = stackToMerge.copy();
            stackToMerge.setCount(0);
            return merged;
        }
        if (FoodCapability.areStacksStackableExceptCreationDate(stackToMergeInto, stackToMerge)) {
            @Nullable FoodComponent mergeIntoFood = (FoodComponent)stackToMergeInto.get(TFCComponents.FOOD);
            @Nullable FoodComponent mergeFood = (FoodComponent)stackToMerge.get(TFCComponents.FOOD);
            if (mergeIntoFood != null && mergeFood != null) {
                stackToMergeInto.set(TFCComponents.FOOD, (Object)mergeIntoFood.with(Math.min(mergeIntoFood.getCreationDate(), mergeFood.getCreationDate())));
            }
            int mergeAmount = Math.min(stackToMerge.getCount(), stackToMergeInto.getMaxStackSize() - stackToMergeInto.getCount());
            stackToMerge.shrink(mergeAmount);
            stackToMergeInto.grow(mergeAmount);
        }
        return stackToMergeInto;
    }

    public static boolean areStacksStackableExceptCreationDate(ItemStack stack1, ItemStack stack2) {
        ItemStack stack1Copy = stack1.copy();
        ItemStack stack2Copy = stack2.copy();
        long date = Calendars.get().getTicks();
        FoodCapability.setCreationDate(stack1Copy, date);
        FoodCapability.setCreationDate(stack2Copy, date);
        return ItemStack.isSameItemSameComponents((ItemStack)stack1Copy, (ItemStack)stack2Copy);
    }

    public static long getRoundedCreationDate() {
        return FoodCapability.getRoundedCreationDate(Calendars.get().getTicks());
    }

    public static long getRoundedCreationDate(long tick) {
        long window = TFCConfig.SERVER.foodDecayStackTicks.get().intValue();
        return ((tick - 1L) / window + 1L) * window;
    }

    public static boolean isRotten(long creationDate, float decayDateModifier) {
        if (creationDate == -1L || creationDate == -3L || creationDate == -2L) {
            return false;
        }
        if (decayDateModifier == 0.0f || creationDate == -4L) {
            return true;
        }
        if (decayDateModifier == Float.POSITIVE_INFINITY) {
            return false;
        }
        long rottenDate = creationDate + FoodCapability.getLifeTime(decayDateModifier);
        return rottenDate <= Calendars.get().getTicks();
    }

    public static long getLifeTime(float decayDateModifier) {
        return (long)(decayDateModifier * 528000.0f);
    }

    private static long calculateNewRoundedCreationDate(long ci, float p) {
        return FoodCapability.getRoundedCreationDate(FoodCapability.calculateNewCreationDate(ci, p));
    }

    private static long calculateNewCreationDate(long ci, float p) {
        if (ci == -4L) {
            return ci;
        }
        if (ci == -2L || ci == -3L) {
            ci = FoodCapability.getRoundedCreationDate();
        }
        return (long)((1.0f - p) * (float)Calendars.get().getTicks() + p * (float)ci);
    }
}

