/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.component.food;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.dries007.tfc.client.ClientHelpers;
import net.dries007.tfc.common.component.food.FoodCapability;
import net.dries007.tfc.common.component.food.FoodData;
import net.dries007.tfc.common.component.food.FoodTrait;
import net.dries007.tfc.common.component.food.Nutrient;
import net.dries007.tfc.config.TFCConfig;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.calendar.Calendars;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.ItemStack;

public interface IFood {
    public static final long TRANSIENT_NEVER_DECAY_FLAG = -1L;
    public static final long INVISIBLE_NEVER_DECAY_FLAG = -2L;
    public static final long NEVER_DECAY_FLAG = -3L;
    public static final long ROTTEN_FLAG = -4L;

    public long getCreationDate();

    default public long getRottenDate() {
        return this.getCreationDate() + FoodCapability.getLifeTime(this.getDecayDateModifier());
    }

    public boolean isRotten();

    public FoodData getData();

    default public float getDecayDateModifier() {
        float mod = this.getData().decayModifier() * TFCConfig.SERVER.foodDecayModifier.get().floatValue();
        for (FoodTrait trait : this.getTraits()) {
            mod *= trait.getDecayModifier();
        }
        return mod == 0.0f ? Float.POSITIVE_INFINITY : 1.0f / mod;
    }

    public List<FoodTrait> getTraits();

    default public boolean hasTrait(FoodTrait trait) {
        return this.getTraits().contains(trait);
    }

    default public boolean hasTrait(Holder<FoodTrait> trait) {
        return this.hasTrait((FoodTrait)trait.value());
    }

    default public void addTooltipInfo(ItemStack stack, Consumer<Component> tooltip) {
        long creationDate = this.getCreationDate();
        if (creationDate == -4L) {
            tooltip.accept((Component)Component.translatable((String)"tfc.tooltip.food_rotten").withStyle(ChatFormatting.RED));
            if (((long)stack.hashCode() * 1928634918231L & 0xFFL) == 0L) {
                tooltip.accept((Component)Component.translatable((String)"tfc.tooltip.food_rotten_special").withStyle(ChatFormatting.RED));
            }
        } else if (creationDate == -3L || creationDate != -1L && this.getDecayDateModifier() == Float.POSITIVE_INFINITY) {
            tooltip.accept((Component)Component.translatable((String)"tfc.tooltip.food_infinite_expiry").withStyle(ChatFormatting.GOLD));
        } else if (creationDate != -1L && creationDate != -2L) {
            MutableComponent foodExpiry;
            long rottenDate = this.getRottenDate();
            switch (TFCConfig.CLIENT.foodExpiryTooltipStyle.get()) {
                case EXPIRY: {
                    MutableComponent mutableComponent = Component.translatable((String)"tfc.tooltip.food_expiry_date", (Object[])new Object[]{Calendars.CLIENT.getExactTimeAndDate(rottenDate)});
                    break;
                }
                case TIME_LEFT: {
                    MutableComponent mutableComponent = Component.translatable((String)"tfc.tooltip.food_expiry_left", (Object[])new Object[]{Calendars.CLIENT.getTimeDelta(rottenDate - Calendars.CLIENT.getTicks())});
                    break;
                }
                case BOTH: {
                    MutableComponent mutableComponent = Component.translatable((String)"tfc.tooltip.food_expiry_date_and_left", (Object[])new Object[]{Calendars.CLIENT.getExactTimeAndDate(rottenDate), Calendars.CLIENT.getTimeDelta(rottenDate - Calendars.CLIENT.getTicks())});
                    break;
                }
                default: {
                    MutableComponent mutableComponent = foodExpiry = null;
                }
            }
            if (foodExpiry != null) {
                tooltip.accept((Component)foodExpiry.withStyle(ChatFormatting.DARK_GREEN));
            }
        }
        if (creationDate != -4L) {
            int water;
            ArrayList<MutableComponent> nutritionText = new ArrayList<MutableComponent>();
            FoodData data = this.getData();
            float saturation = data.saturation();
            if (saturation > 0.0f) {
                nutritionText.add(Component.translatable((String)"tfc.tooltip.nutrition_saturation", (Object[])new Object[]{String.format("%d", (int)(saturation * 5.0f))}).withStyle(ChatFormatting.GRAY));
            }
            if ((water = (int)data.water()) > 0) {
                nutritionText.add(Component.translatable((String)"tfc.tooltip.nutrition_water", (Object[])new Object[]{String.format("%d", water)}).withStyle(ChatFormatting.GRAY));
            }
            for (Nutrient nutrient : Nutrient.VALUES) {
                float value = data.nutrient(nutrient);
                if (!(value > 0.0f)) continue;
                nutritionText.add(Component.literal((String)" - ").append((Component)Helpers.translateEnum(nutrient)).append(": " + String.format("%.1f", Float.valueOf(value))).withStyle(nutrient.getColor()));
            }
            if (!nutritionText.isEmpty()) {
                if (ClientHelpers.hasShiftDown()) {
                    tooltip.accept((Component)Component.translatable((String)"tfc.tooltip.nutrition").withStyle(ChatFormatting.GRAY));
                    nutritionText.forEach(tooltip);
                } else {
                    tooltip.accept((Component)Component.translatable((String)"tfc.tooltip.hold_shift_for_nutrition_info").withStyle(new ChatFormatting[]{ChatFormatting.ITALIC, ChatFormatting.GRAY}));
                }
            }
        }
        for (FoodTrait trait : this.getTraits()) {
            trait.addTooltipInfo(tooltip);
        }
    }
}

