/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.component.food;

import com.mojang.serialization.DynamicOps;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.function.ToDoubleFunction;
import net.dries007.tfc.common.component.food.FoodData;
import net.dries007.tfc.common.component.food.INutritionData;
import net.dries007.tfc.common.component.food.Nutrient;
import net.dries007.tfc.config.TFCConfig;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import org.jetbrains.annotations.Nullable;

public class NutritionData
implements INutritionData {
    private final LinkedList<FoodData> records = new LinkedList();
    private final float defaultNutritionValue;
    private final float defaultDairyNutritionValue;
    private final float[] nutrients;
    private float averageNutrients;
    private int hungerWindow;
    private int hunger;

    public NutritionData(float defaultNutritionValue, float defaultDairyNutritionValue) {
        this.defaultNutritionValue = defaultNutritionValue;
        this.defaultDairyNutritionValue = defaultDairyNutritionValue;
        this.nutrients = new float[5];
        this.hungerWindow = 0;
        this.hunger = 20;
        this.calculateNutrition();
    }

    @Override
    public float getAverageNutrition() {
        return this.averageNutrients;
    }

    @Override
    public float getNutrient(Nutrient nutrient) {
        return this.nutrients[nutrient.ordinal()];
    }

    @Override
    public float[] getNutrients() {
        return this.nutrients;
    }

    @Override
    public void setHungerAndUpdate(int hunger) {
        this.setHunger(hunger);
        this.calculateNutrition();
    }

    @Override
    public void setHunger(int hunger) {
        this.hunger = hunger;
    }

    @Override
    public void onClientUpdate(float[] nutrients) {
        System.arraycopy(nutrients, 0, this.nutrients, 0, this.nutrients.length);
        this.updateAverageNutrients();
    }

    public void addNutrients(FoodData data) {
        if (data.hunger() > 0 || this.records.isEmpty() || this.records.getFirst().hunger() > 0) {
            this.records.addFirst(data);
            this.calculateNutrition();
        }
    }

    @Override
    public void addNutrients(FoodData data, int currentHunger) {
        this.addNutrients(data);
    }

    @Override
    public Tag writeToNbt() {
        return (Tag)FoodData.LIST_CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, this.records).getOrThrow();
    }

    @Override
    public void readFromNbt(@Nullable Tag nbt) {
        this.records.clear();
        FoodData.LIST_CODEC.decode((DynamicOps)NbtOps.INSTANCE, (Object)nbt).ifSuccess(e -> this.records.addAll((Collection)e.getFirst()));
        this.calculateNutrition();
    }

    private void calculateNutrition() {
        Arrays.fill(this.nutrients, 0.0f);
        int runningHungerTotal = Math.max(20 - this.hunger, 0);
        this.hungerWindow = TFCConfig.SERVER.nutritionRotationHungerWindow.get();
        for (int i = 0; i < this.records.size(); ++i) {
            FoodData record = this.records.get(i);
            int nextHunger = record.hunger() + runningHungerTotal;
            if (nextHunger <= this.hungerWindow) {
                this.updateAllNutrients(this.nutrients, j -> this.nutrients[j.ordinal()] + record.nutrient((Nutrient)((Object)j)) * (float)Math.max(record.hunger(), 4));
                runningHungerTotal = nextHunger;
                continue;
            }
            float actualHunger = this.hungerWindow - runningHungerTotal;
            this.updateAllNutrients(this.nutrients, j -> this.nutrients[j.ordinal()] + record.nutrient((Nutrient)((Object)j)) * actualHunger);
            while (this.records.size() > i + 1) {
                this.records.remove(i + 1);
            }
        }
        this.updateAllNutrients(this.nutrients, j -> this.nutrients[j.ordinal()] / (float)this.hungerWindow);
        if (runningHungerTotal < this.hungerWindow) {
            float defaultModifier = 1.0f - (float)runningHungerTotal / (float)this.hungerWindow;
            for (Nutrient nutrient : Nutrient.VALUES) {
                if (nutrient == Nutrient.DAIRY) {
                    int n = nutrient.ordinal();
                    this.nutrients[n] = this.nutrients[n] + this.defaultDairyNutritionValue * defaultModifier;
                    continue;
                }
                int n = nutrient.ordinal();
                this.nutrients[n] = this.nutrients[n] + this.defaultNutritionValue * defaultModifier;
            }
        }
        this.updateAllNutrients(this.nutrients, j -> Math.min(1.0f, this.nutrients[j.ordinal()]));
        this.updateAverageNutrients();
    }

    private void updateAverageNutrients() {
        this.averageNutrients = 0.0f;
        for (float nutrient : this.nutrients) {
            this.averageNutrients += nutrient;
        }
        this.averageNutrients /= (float)Nutrient.TOTAL;
    }

    private void updateAllNutrients(float[] array, ToDoubleFunction<Nutrient> operator) {
        for (Nutrient nutrient : Nutrient.VALUES) {
            array[nutrient.ordinal()] = (float)operator.applyAsDouble(nutrient);
        }
    }
}

