/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.component.forge;

import java.util.List;
import net.dries007.tfc.common.component.ComponentView;
import net.dries007.tfc.common.component.TFCComponents;
import net.dries007.tfc.common.component.forge.ForgeRule;
import net.dries007.tfc.common.component.forge.ForgeStep;
import net.dries007.tfc.common.component.forge.ForgingComponent;
import net.dries007.tfc.common.recipes.AnvilRecipe;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import org.jetbrains.annotations.Nullable;

public final class Forging
extends ComponentView<ForgingComponent> {
    Forging(ItemStack stack) {
        super(stack, TFCComponents.FORGING, ForgingComponent.EMPTY);
    }

    public void setRecipe(@Nullable RecipeHolder<AnvilRecipe> recipe, AnvilRecipe.Inventory inventory) {
        this.setRecipe(recipe, recipe == null ? -1 : ((AnvilRecipe)recipe.value()).computeTarget(inventory));
    }

    @Nullable
    public AnvilRecipe getRecipe() {
        return ((ForgingComponent)this.component).getRecipe();
    }

    public void setRecipe(@Nullable RecipeHolder<AnvilRecipe> recipe, int target) {
        this.apply(((ForgingComponent)this.component).withRecipe(recipe, target));
    }

    public void addStep(ForgeStep step) {
        this.addStep(step, step.step());
    }

    public void addStep(ForgeStep step, int amount) {
        this.apply(((ForgingComponent)this.component).withStep(step, amount));
    }

    public List<ForgeStep> lastSteps() {
        return ((ForgingComponent)this.component).steps.steps();
    }

    public boolean matches(List<ForgeRule> rules) {
        for (ForgeRule rule : rules) {
            if (this.matches(rule)) continue;
            return false;
        }
        return true;
    }

    public boolean matches(ForgeRule rule) {
        List<ForgeStep> steps = ((ForgingComponent)this.component).steps.steps();
        return rule.matches(steps.isEmpty() ? null : steps.get(steps.size() - 1), steps.size() <= 1 ? null : steps.get(steps.size() - 2), steps.size() <= 2 ? null : steps.get(steps.size() - 3));
    }

    public boolean isWorked() {
        return ((ForgingComponent)this.component).steps.isWorked();
    }

    public int totalWorked() {
        return ((ForgingComponent)this.component).steps.total();
    }

    public int work() {
        return ((ForgingComponent)this.component).work;
    }

    public int target() {
        return ((ForgingComponent)this.component).target;
    }

    public void restoreRecipeAndWork() {
        this.apply((ForgingComponent)this.component);
    }
}

