/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.component.forge;

import com.mojang.serialization.Codec;
import io.netty.buffer.ByteBuf;
import java.util.Locale;
import java.util.function.DoubleSupplier;
import net.dries007.tfc.config.TFCConfig;
import net.dries007.tfc.network.StreamCodecs;
import net.dries007.tfc.util.Helpers;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.StringRepresentable;

public enum ForgingBonus implements StringRepresentable
{
    NONE(() -> Double.POSITIVE_INFINITY),
    MODEST(TFCConfig.SERVER.anvilModestlyForgedThreshold::get),
    WELL(TFCConfig.SERVER.anvilWellForgedThreshold::get),
    EXPERT(TFCConfig.SERVER.anvilExpertForgedThreshold::get),
    PERFECT(TFCConfig.SERVER.anvilPerfectlyForgedThreshold::get);

    public static final Codec<ForgingBonus> CODEC;
    public static final StreamCodec<ByteBuf, ForgingBonus> STREAM_CODEC;
    private static final ForgingBonus[] VALUES;
    private final String serializedName = this.name().toLowerCase(Locale.ROOT);
    private final DoubleSupplier minRatio;

    public static ForgingBonus byRatio(float ratio) {
        for (int i = VALUES.length - 1; i > 0; --i) {
            if (!(ForgingBonus.VALUES[i].minRatio.getAsDouble() > (double)ratio)) continue;
            return VALUES[i];
        }
        return NONE;
    }

    private ForgingBonus(DoubleSupplier minRatio) {
        this.minRatio = minRatio;
    }

    public MutableComponent getDisplayName() {
        return Helpers.translateEnum(this);
    }

    public String getSerializedName() {
        return this.serializedName;
    }

    public float efficiency() {
        return Helpers.lerp((float)this.ordinal() * 0.25f, 1.0f, TFCConfig.SERVER.anvilMaxEfficiencyMultiplier.get().floatValue());
    }

    public float durability() {
        return Helpers.lerp((float)this.ordinal() * 0.25f, 0.0f, TFCConfig.SERVER.anvilMaxDurabilityMultiplier.get().floatValue());
    }

    public float damage() {
        return Helpers.lerp((float)this.ordinal() * 0.25f, 1.0f, TFCConfig.SERVER.anvilMaxDamageMultiplier.get().floatValue());
    }

    static {
        CODEC = StringRepresentable.fromValues(ForgingBonus::values);
        STREAM_CODEC = StreamCodecs.forEnum(ForgingBonus::values);
        VALUES = ForgingBonus.values();
    }
}

