/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.component.glass;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Objects;
import net.dries007.tfc.common.component.glass.GlassOperation;
import net.dries007.tfc.util.Helpers;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;

public record GlassOperations(List<GlassOperation> steps, ItemStack batch) {
    public static final int LIMIT = 24;
    public static final GlassOperations DEFAULT = new GlassOperations(List.of(), ItemStack.EMPTY);
    public static final Codec<GlassOperations> CODEC = RecordCodecBuilder.create(i -> i.group((App)GlassOperation.REGISTRY.byNameCodec().listOf(0, 24).fieldOf("steps").forGetter(c -> c.steps), (App)ItemStack.CODEC.optionalFieldOf("stack", (Object)ItemStack.EMPTY).forGetter(c -> c.batch)).apply((Applicative)i, GlassOperations::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, GlassOperations> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.registry(GlassOperation.KEY).apply(ByteBufCodecs.list()), c -> c.steps, (StreamCodec)ItemStack.OPTIONAL_STREAM_CODEC, c -> c.batch, GlassOperations::new);

    public boolean isEmpty() {
        return this.batch.isEmpty();
    }

    GlassOperations with(GlassOperation operation) {
        return this.steps.size() >= 24 || this.batch.isEmpty() ? this : new GlassOperations(Helpers.immutableAdd(this.steps, operation), this.batch.copy());
    }

    GlassOperations with(ItemStack batch) {
        return new GlassOperations(this.steps, batch.copy());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof GlassOperations)) return false;
        GlassOperations ops = (GlassOperations)obj;
        if (!this.steps.equals(ops.steps)) return false;
        if (!ItemStack.matches((ItemStack)this.batch, (ItemStack)ops.batch)) return false;
        return true;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.steps, ItemStack.hashItemAndComponents((ItemStack)this.batch));
    }
}

