/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.component.heat;

import java.util.Iterator;
import java.util.Objects;
import net.dries007.tfc.common.capabilities.BlockCapabilities;
import net.dries007.tfc.common.capabilities.ItemCapabilities;
import net.dries007.tfc.common.component.TFCComponents;
import net.dries007.tfc.common.component.heat.HeatComponent;
import net.dries007.tfc.common.component.heat.HeatDefinition;
import net.dries007.tfc.common.component.heat.HeatView;
import net.dries007.tfc.common.component.heat.IHeat;
import net.dries007.tfc.common.component.heat.IHeatConsumer;
import net.dries007.tfc.common.component.heat.IHeatView;
import net.dries007.tfc.common.recipes.RecipeHelpers;
import net.dries007.tfc.config.TFCConfig;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.collections.IndirectHashCollection;
import net.dries007.tfc.util.data.DataManager;
import net.dries007.tfc.util.data.Fuel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.IItemHandlerModifiable;
import org.jetbrains.annotations.Nullable;

public final class HeatCapability {
    public static final DataManager<HeatDefinition> MANAGER = new DataManager<HeatDefinition>(Helpers.identifier("item_heat"), HeatDefinition.CODEC, HeatDefinition.STREAM_CODEC);
    public static final IndirectHashCollection<Item, HeatDefinition> CACHE = IndirectHashCollection.create(r -> RecipeHelpers.itemKeys(r.ingredient()), MANAGER::getValues);
    public static final float POTTERY_HEAT_CAPACITY = 1.2f;

    @Nullable
    public static IHeat get(ItemStack stack) {
        @Nullable IHeat capability = (IHeat)stack.getCapability(ItemCapabilities.HEAT);
        if (capability != null) {
            return capability;
        }
        @Nullable HeatComponent value = (HeatComponent)stack.get(TFCComponents.HEAT);
        return value != null ? new HeatView(stack, value) : null;
    }

    @Nullable
    public static IHeatView view(ItemStack stack) {
        @Nullable IHeat capability = (IHeat)stack.getCapability(ItemCapabilities.HEAT);
        return capability != null ? capability : (IHeatView)stack.get(TFCComponents.HEAT);
    }

    public static IHeat mutableView(ItemStack stack) {
        return new HeatView(stack, Objects.requireNonNull((HeatComponent)stack.get(TFCComponents.HEAT), () -> "Expected a heat component to be present on" + String.valueOf(stack)));
    }

    public static boolean has(ItemStack stack) {
        return stack.has(TFCComponents.HEAT);
    }

    public static float getTemperature(ItemStack stack) {
        @Nullable IHeatView heat = HeatCapability.view(stack);
        return heat != null ? heat.getTemperature() : 0.0f;
    }

    public static void setTemperature(ItemStack stack, float temperature) {
        @Nullable IHeat heat = HeatCapability.get(stack);
        if (heat != null) {
            heat.setTemperature(temperature);
        }
    }

    public static void setStaticTemperature(ItemStack stack, float temperature) {
        @Nullable IHeat heat = HeatCapability.get(stack);
        if (heat != null) {
            heat.setStaticTemperature(temperature);
        }
    }

    public static boolean isHot(ItemStack stack) {
        return HeatCapability.getTemperature(stack) > 0.0f;
    }

    @Nullable
    public static HeatDefinition getDefinition(ItemStack stack) {
        return RecipeHelpers.getRecipe(CACHE, stack, stack.getItem());
    }

    public static float adjustTempTowards(float temp, float target) {
        return HeatCapability.adjustTempTowards(temp, target, 1.0f, 1.0f);
    }

    public static float adjustTempTowards(float temp, float target, float delta) {
        return HeatCapability.adjustTempTowards(temp, target, delta, delta);
    }

    public static float adjustTempTowards(float temp, float target, float deltaPositive, float deltaNegative) {
        float delta = TFCConfig.SERVER.deviceHeatingModifier.get().floatValue();
        if (temp < target) {
            return Math.min(temp + delta * deltaPositive, target);
        }
        if (temp > target) {
            return Math.max(temp - delta * deltaNegative, target);
        }
        return target;
    }

    public static float adjustDeviceTemp(float temp, float baseTarget, int airTicks, boolean isRaining) {
        float target = HeatCapability.targetDeviceTemp(baseTarget, airTicks, isRaining);
        if (temp != target) {
            float deltaPositive = 1.0f;
            float deltaNegative = 1.0f;
            if (airTicks > 0) {
                deltaPositive = 2.0f;
                deltaNegative = 0.5f;
            }
            return HeatCapability.adjustTempTowards(temp, target, deltaPositive, deltaNegative);
        }
        return target;
    }

    public static float targetDeviceTemp(float target, int airTicks, boolean isRaining) {
        if (airTicks > 0) {
            float airInfluence = 4.0f * (float)airTicks;
            if (airInfluence > 600.0f) {
                airInfluence = 600.0f;
            }
            target += Math.min(airInfluence, target * 0.5f);
        }
        if (isRaining && (target -= 300.0f) < 0.0f) {
            target = 0.0f;
        }
        return target;
    }

    public static float adjustTemp(float temperature, float heatCapacity, long ticksSinceUpdate) {
        if (ticksSinceUpdate <= 0L) {
            return temperature;
        }
        float newTemperature = temperature - (float)((double)ticksSinceUpdate * TFCConfig.SERVER.itemCoolingModifier.get()) / heatCapacity;
        return newTemperature < 0.0f ? 0.0f : newTemperature;
    }

    public static void addTemp(IHeat instance, float target) {
        HeatCapability.addTemp(instance, target, 3.0f);
    }

    public static void addTemp(IHeat instance, float targetTemperature, float modifier) {
        modifier = TFCConfig.SERVER.itemCoolingModifier.get().floatValue() - 1.0f + modifier * TFCConfig.SERVER.itemHeatingModifier.get().floatValue();
        float initialTemperature = instance.getTemperature();
        float newTemperature = initialTemperature + modifier / instance.getHeatCapacity();
        if (newTemperature > targetTemperature) {
            newTemperature = targetTemperature;
        }
        if (newTemperature > initialTemperature) {
            instance.setTemperature(newTemperature);
        }
    }

    public static Remainder consumeFuelForTicks(long ticks, IItemHandlerModifiable inventory, int burnTicks, float burnTemperature, int slotStart, int slotEnd) {
        return HeatCapability.consumeFuelForTicks(ticks, burnTicks, burnTemperature, Helpers.iterate((IItemHandler)inventory, slotStart, 1 + slotEnd));
    }

    public static Remainder consumeFuelForTicks(long ticks, int burnTicks, float burnTemperature, Iterable<ItemStack> fuelStacks) {
        if ((long)burnTicks > ticks) {
            burnTicks = (int)((long)burnTicks - ticks);
            return new Remainder(burnTicks, burnTemperature, 0L);
        }
        ticks -= (long)burnTicks;
        burnTicks = 0;
        Iterator<ItemStack> iterator = fuelStacks.iterator();
        while (iterator.hasNext()) {
            ItemStack fuelStack = iterator.next();
            Fuel fuel = Fuel.get(fuelStack);
            if (fuel == null) continue;
            iterator.remove();
            if ((long)fuel.duration() > ticks) {
                burnTicks = (int)((long)fuel.duration() - ticks);
                burnTemperature = fuel.temperature();
                return new Remainder(burnTicks, burnTemperature, 0L);
            }
            ticks -= (long)fuel.duration();
        }
        return new Remainder(burnTicks, burnTemperature, ticks);
    }

    public static void provideHeatTo(Level level, BlockPos pos, Direction to, float temperature) {
        @Nullable IHeatConsumer heat = (IHeatConsumer)level.getCapability(BlockCapabilities.HEAT, pos, (Object)to);
        if (heat != null) {
            heat.setTemperature(temperature);
        }
    }

    public record Remainder(int burnTicks, float burnTemperature, long ticks) {
    }
}

