/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.component.heat;

import java.util.function.Consumer;
import net.dries007.tfc.common.recipes.HeatingRecipe;
import net.dries007.tfc.config.TFCConfig;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.ItemStack;

public interface IHeatView {
    public static final float FLAG_STATIC_TEMPERATURE = -1.0f;
    public static final long FLAG_NOW = -1L;

    public float getTemperature();

    public float getHeatCapacity();

    public float getWorkingTemperature();

    public float getWeldingTemperature();

    default public boolean canWork() {
        return this.getTemperature() >= this.getWorkingTemperature();
    }

    default public boolean canWeld() {
        return this.getTemperature() >= this.getWeldingTemperature();
    }

    default public void addTooltipInfo(ItemStack stack, Consumer<Component> text) {
        float temperature = this.getTemperature();
        MutableComponent tooltip = TFCConfig.CLIENT.heatTooltipStyle.get().formatColored(temperature);
        if (tooltip != null) {
            float weldingTemperature = this.getWeldingTemperature();
            float forgingTemperature = this.getWorkingTemperature();
            if (weldingTemperature > 0.0f && weldingTemperature <= temperature) {
                tooltip.append((Component)Component.translatable((String)"tfc.tooltip.welding"));
            } else if (forgingTemperature > 0.0f && forgingTemperature <= temperature) {
                tooltip.append((Component)Component.translatable((String)"tfc.tooltip.forging"));
            }
            HeatingRecipe recipe = HeatingRecipe.getRecipe(stack);
            if (recipe != null && (double)temperature > 0.9 * (double)recipe.getTemperature() && recipe.assembleItem(stack).isEmpty()) {
                tooltip.append((Component)Component.translatable((String)"tfc.tooltip.danger"));
            }
            text.accept((Component)tooltip);
        }
    }
}

