/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.container;

import net.dries007.tfc.common.blockentities.AnvilBlockEntity;
import net.dries007.tfc.common.component.forge.ForgeStep;
import net.dries007.tfc.common.component.forge.Forging;
import net.dries007.tfc.common.component.forge.ForgingCapability;
import net.dries007.tfc.common.container.BlockEntityContainer;
import net.dries007.tfc.common.container.ButtonHandlerContainer;
import net.dries007.tfc.common.container.Container;
import net.dries007.tfc.common.container.TFCContainerTypes;
import net.dries007.tfc.common.container.slot.CallbackSlot;
import net.dries007.tfc.common.recipes.AnvilRecipe;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class AnvilContainer
extends BlockEntityContainer<AnvilBlockEntity>
implements ButtonHandlerContainer {
    public static final int PLAN_ID = 8;

    public static AnvilContainer create(AnvilBlockEntity anvil, Inventory playerInv, int windowId) {
        return (AnvilContainer)new AnvilContainer(windowId, anvil).init(playerInv, 41);
    }

    protected AnvilContainer(int windowId, AnvilBlockEntity anvil) {
        super((MenuType)TFCContainerTypes.ANVIL.get(), windowId, anvil);
    }

    @Override
    public void onButtonPress(int buttonID, @Nullable CompoundTag extraNBT) {
        if (buttonID == 8) {
            Player player;
            ItemStack stack;
            Level level = ((AnvilBlockEntity)this.blockEntity).getLevel();
            if (level != null && AnvilRecipe.hasAny(level, stack = this.getSlot(0).getItem(), ((AnvilBlockEntity)this.blockEntity).getTier()) && (player = this.player) instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                MenuProvider provider = ((AnvilBlockEntity)this.blockEntity).planProvider();
                serverPlayer.openMenu(provider, ((AnvilBlockEntity)this.blockEntity).getBlockPos());
            }
        } else {
            ForgeStep step = ForgeStep.valueOf(buttonID);
            Player player = this.player;
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                if (step != null) {
                    ((AnvilBlockEntity)this.blockEntity).work(serverPlayer, step);
                }
            }
        }
    }

    @Override
    protected void addContainerSlots() {
        this.addSlot((Slot)new CallbackSlot(this.blockEntity, 0, 31, 68));
        this.addSlot((Slot)new CallbackSlot(this.blockEntity, 1, 13, 68));
        this.addSlot((Slot)new CallbackSlot(this.blockEntity, 2, 129, 68));
        this.addSlot((Slot)new CallbackSlot(this.blockEntity, 3, 147, 68));
    }

    @Override
    protected boolean moveStack(ItemStack stack, int slotIndex) {
        return switch (this.typeOf(slotIndex)) {
            default -> throw new MatchException(null, null);
            case Container.IndexType.MAIN_INVENTORY, Container.IndexType.HOTBAR -> {
                if (!this.moveItemStackTo(stack, 2, 4, false) && !this.moveItemStackTo(stack, 0, 2, false)) {
                    yield true;
                }
                yield false;
            }
            case Container.IndexType.CONTAINER -> {
                boolean result;
                Forging forge = ForgingCapability.get(stack);
                ForgingCapability.clearRecipeIfNotWorked(stack);
                boolean v1 = result = !this.moveItemStackTo(stack, this.containerSlots, this.slots.size(), false);
                if (!stack.isEmpty()) {
                    forge.restoreRecipeAndWork();
                }
                yield result;
            }
        };
    }
}

