/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.container;

import net.dries007.tfc.common.blockentities.AnvilBlockEntity;
import net.dries007.tfc.common.container.BlockEntityContainer;
import net.dries007.tfc.common.container.ButtonHandlerContainer;
import net.dries007.tfc.common.container.TFCContainerTypes;
import net.dries007.tfc.util.Helpers;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import org.jetbrains.annotations.Nullable;

public class AnvilPlanContainer
extends BlockEntityContainer<AnvilBlockEntity>
implements ButtonHandlerContainer {
    public static AnvilPlanContainer create(AnvilBlockEntity anvil, Inventory playerInventory, int windowId) {
        return (AnvilPlanContainer)new AnvilPlanContainer(windowId, anvil).init(playerInventory, 0);
    }

    protected AnvilPlanContainer(int windowId, AnvilBlockEntity anvil) {
        super((MenuType)TFCContainerTypes.ANVIL_PLAN.get(), windowId, anvil);
    }

    @Override
    public void onButtonPress(int buttonID, @Nullable CompoundTag extraNBT) {
        if (extraNBT != null && this.player != null) {
            ResourceLocation recipeId = Helpers.resourceLocation(extraNBT.getString("recipe"));
            ((AnvilBlockEntity)this.blockEntity).chooseRecipe(recipeId);
            Player player = this.player;
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                MenuProvider provider = ((AnvilBlockEntity)this.blockEntity).anvilProvider();
                serverPlayer.openMenu(provider, ((AnvilBlockEntity)this.blockEntity).getBlockPos());
            }
        }
    }
}

