/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.container;

import net.dries007.tfc.common.blockentities.CharcoalForgeBlockEntity;
import net.dries007.tfc.common.container.BlockEntityContainer;
import net.dries007.tfc.common.container.Container;
import net.dries007.tfc.common.container.TFCContainerTypes;
import net.dries007.tfc.common.container.slot.CallbackSlot;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

public class CharcoalForgeContainer
extends BlockEntityContainer<CharcoalForgeBlockEntity> {
    public static CharcoalForgeContainer create(CharcoalForgeBlockEntity forge, Inventory playerInventory, int windowId) {
        return (CharcoalForgeContainer)((Object)new CharcoalForgeContainer(forge, windowId).init(playerInventory, 20));
    }

    private CharcoalForgeContainer(CharcoalForgeBlockEntity forge, int windowId) {
        super((MenuType)TFCContainerTypes.CHARCOAL_FORGE.get(), windowId, forge);
        this.addDataSlots(forge.getSyncableData());
    }

    @Override
    protected boolean moveStack(ItemStack stack, int slotIndex) {
        return switch (this.typeOf(slotIndex)) {
            default -> throw new MatchException(null, null);
            case Container.IndexType.MAIN_INVENTORY, Container.IndexType.HOTBAR -> {
                if (!this.moveItemStackTo(stack, 10, 14, false) && !this.moveItemStackTo(stack, 0, 10, false)) {
                    yield true;
                }
                yield false;
            }
            case Container.IndexType.CONTAINER -> !this.moveItemStackTo(stack, this.containerSlots, this.slots.size(), false);
        };
    }

    @Override
    protected void addContainerSlots() {
        int index = 0;
        this.addSlot((Slot)new CallbackSlot(this.blockEntity, index++, 80, 70));
        this.addSlot((Slot)new CallbackSlot(this.blockEntity, index++, 98, 52));
        this.addSlot((Slot)new CallbackSlot(this.blockEntity, index++, 62, 52));
        this.addSlot((Slot)new CallbackSlot(this.blockEntity, index++, 116, 34));
        this.addSlot((Slot)new CallbackSlot(this.blockEntity, index, 44, 34));
        index = 5;
        this.addSlot((Slot)new CallbackSlot(this.blockEntity, index++, 80, 52));
        this.addSlot((Slot)new CallbackSlot(this.blockEntity, index++, 98, 34));
        this.addSlot((Slot)new CallbackSlot(this.blockEntity, index++, 62, 34));
        this.addSlot((Slot)new CallbackSlot(this.blockEntity, index++, 116, 16));
        this.addSlot((Slot)new CallbackSlot(this.blockEntity, index, 44, 16));
        for (int i = 10; i <= 13; ++i) {
            this.addSlot((Slot)new CallbackSlot(this.blockEntity, i, 152, 16 + 18 * (i - 10)));
        }
    }
}

