/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.container;

import net.dries007.tfc.common.container.ISlotCallback;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public class Container
extends AbstractContainerMenu {
    protected int containerSlots;
    @Nullable
    protected Player player;
    @Nullable
    protected ISlotCallback callback;

    public static Container create(MenuType<?> type, int windowId, Inventory playerInv) {
        return new Container(type, windowId).init(playerInv);
    }

    protected Container(@Nullable ISlotCallback callback, MenuType<?> type, int windowId) {
        super(type, windowId);
        this.callback = callback;
    }

    protected Container(MenuType<?> type, int windowId) {
        this(null, type, windowId);
    }

    public <C extends Container> C init(Inventory playerInventory, int yOffset) {
        this.addContainerSlots();
        this.containerSlots = this.slots.size();
        this.addPlayerInventorySlots(playerInventory, yOffset);
        this.player = playerInventory.player;
        return (C)((Object)this);
    }

    public <C extends Container> C init(Inventory playerInventory) {
        return this.init(playerInventory, 0);
    }

    public ItemStack quickMoveStack(Player player, int index) {
        Slot slot = (Slot)this.slots.get(index);
        if (slot.hasItem()) {
            ItemStack stack = slot.getItem();
            ItemStack original = stack.copy();
            if (this.moveStack(stack, index)) {
                return ItemStack.EMPTY;
            }
            if (stack.getCount() == original.getCount()) {
                return ItemStack.EMPTY;
            }
            if (stack.isEmpty()) {
                slot.set(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
            slot.onTake(player, stack);
            return original;
        }
        return ItemStack.EMPTY;
    }

    public void setCarried(ItemStack stack) {
        if (this.callback != null) {
            this.callback.onCarried(stack);
        }
        super.setCarried(stack);
    }

    public boolean stillValid(Player playerIn) {
        return true;
    }

    protected boolean moveStack(ItemStack stack, int slotIndex) {
        return switch (this.typeOf(slotIndex).ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> true;
            case 2 -> {
                if (!this.moveItemStackTo(stack, this.containerSlots, this.containerSlots + 27, false)) {
                    yield true;
                }
                yield false;
            }
            case 1 -> !this.moveItemStackTo(stack, this.containerSlots + 27, this.containerSlots + 36, false);
        };
    }

    protected void addContainerSlots() {
    }

    protected final void addPlayerInventorySlots(Inventory playerInv, int yOffset) {
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.addSlot(new Slot((net.minecraft.world.Container)playerInv, j + i * 9 + 9, 8 + j * 18, 84 + i * 18 + yOffset));
            }
        }
        for (int k = 0; k < 9; ++k) {
            this.addSlot(new Slot((net.minecraft.world.Container)playerInv, k, 8 + k * 18, 142 + yOffset));
        }
    }

    protected final void giveItemStackToPlayerOrDrop(Player player, ItemStack stack) {
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            if (player.isAlive() && !serverPlayer.hasDisconnected()) {
                player.getInventory().placeItemBackInInventory(stack);
            } else {
                player.drop(stack, false);
            }
        }
    }

    public final IndexType typeOf(int index) {
        if (index < this.containerSlots) {
            return IndexType.CONTAINER;
        }
        if (index < this.containerSlots + 27) {
            return IndexType.MAIN_INVENTORY;
        }
        return IndexType.HOTBAR;
    }

    public static enum IndexType {
        CONTAINER,
        MAIN_INVENTORY,
        HOTBAR;

    }
}

