/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.container;

import net.dries007.tfc.common.blockentities.FirepitBlockEntity;
import net.dries007.tfc.common.container.BlockEntityContainer;
import net.dries007.tfc.common.container.Container;
import net.dries007.tfc.common.container.TFCContainerTypes;
import net.dries007.tfc.common.container.slot.CallbackSlot;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

public class FirepitContainer
extends BlockEntityContainer<FirepitBlockEntity> {
    public static FirepitContainer create(FirepitBlockEntity tile, Inventory playerInv, int windowId) {
        return (FirepitContainer)((Object)new FirepitContainer(tile, windowId).init(playerInv, 20));
    }

    private FirepitContainer(FirepitBlockEntity tile, int windowId) {
        super((MenuType)TFCContainerTypes.FIREPIT.get(), windowId, tile);
        this.addDataSlots(tile.getSyncableData());
    }

    @Override
    protected boolean moveStack(ItemStack stack, int slotIndex) {
        return switch (this.typeOf(slotIndex)) {
            default -> throw new MatchException(null, null);
            case Container.IndexType.MAIN_INVENTORY, Container.IndexType.HOTBAR -> {
                if (!this.moveItemStackTo(stack, 3, 5, false)) {
                    yield true;
                }
                yield false;
            }
            case Container.IndexType.CONTAINER -> !this.moveItemStackTo(stack, this.containerSlots, this.slots.size(), false);
        };
    }

    @Override
    protected void addContainerSlots() {
        for (int i = 0; i < 4; ++i) {
            this.addSlot((Slot)new CallbackSlot(this.blockEntity, i, 8, 70 - 18 * i));
        }
        this.addSlot((Slot)new CallbackSlot(this.blockEntity, 4, 80, 29));
        this.addSlot((Slot)new CallbackSlot(this.blockEntity, 5, 71, 57));
        this.addSlot((Slot)new CallbackSlot(this.blockEntity, 6, 89, 57));
    }
}

