/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.container;

import net.dries007.tfc.common.capabilities.InventoryItemHandler;
import net.dries007.tfc.common.component.heat.HeatCapability;
import net.dries007.tfc.common.component.heat.IHeat;
import net.dries007.tfc.common.component.mold.IMold;
import net.dries007.tfc.common.container.Container;
import net.dries007.tfc.common.container.ISlotCallback;
import net.dries007.tfc.common.container.ItemStackContainer;
import net.dries007.tfc.common.container.TFCContainerTypes;
import net.dries007.tfc.common.container.slot.CallbackSlot;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.data.FluidHeat;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.IItemHandlerModifiable;
import org.jetbrains.annotations.Nullable;

public class MoldLikeAlloyContainer
extends ItemStackContainer
implements ISlotCallback {
    @Nullable
    private final IMold mold;
    private final IItemHandlerModifiable inventory;

    public static MoldLikeAlloyContainer create(ItemStack stack, InteractionHand hand, int slot, Inventory playerInv, int windowId) {
        return (MoldLikeAlloyContainer)new MoldLikeAlloyContainer(stack, hand, slot, playerInv, windowId).init(playerInv);
    }

    private MoldLikeAlloyContainer(ItemStack stack, InteractionHand hand, int slot, Inventory playerInv, int windowId) {
        super((MenuType)TFCContainerTypes.MOLD_LIKE_ALLOY.get(), windowId, playerInv, stack, hand, slot);
        this.mold = IMold.get(stack);
        this.inventory = new InventoryItemHandler(this, 1);
    }

    public void broadcastChanges() {
        int filled;
        FluidStack drained;
        ItemStack outputStack;
        IFluidHandler outputFluidCap;
        if (this.mold != null && this.mold.isMolten() && (outputFluidCap = (IFluidHandler)(outputStack = this.inventory.getStackInSlot(0)).getCapability(Capabilities.FluidHandler.ITEM)) != null && !(drained = this.mold.drain(1, IFluidHandler.FluidAction.SIMULATE)).isEmpty() && (filled = outputFluidCap.fill(drained, IFluidHandler.FluidAction.EXECUTE)) == 1) {
            FluidHeat fluidHeat = FluidHeat.getOrUnknown(drained);
            @Nullable IHeat outputHeat = HeatCapability.get(outputStack);
            float heatCapacityOf1mB = fluidHeat.heatCapacity(1.0f);
            this.mold.drain(1, IFluidHandler.FluidAction.EXECUTE);
            if (outputHeat != null) {
                outputHeat.addTemperatureFromSourceWithHeatCapacity(this.mold.getTemperature(), heatCapacityOf1mB);
            }
        }
        super.broadcastChanges();
    }

    public void removed(Player player) {
        ItemStack stack;
        if (!player.level().isClientSide() && !(stack = this.inventory.getStackInSlot(0)).isEmpty()) {
            this.giveItemStackToPlayerOrDrop(player, stack);
        }
        super.removed(player);
    }

    @Override
    public boolean stillValid(Player player) {
        return this.mold != null && (this.mold.isMolten() || this.mold.getFluidInTank(0).isEmpty()) && super.stillValid(player);
    }

    @Override
    protected boolean moveStack(ItemStack stack, int slotIndex) {
        return switch (this.typeOf(slotIndex)) {
            default -> throw new MatchException(null, null);
            case Container.IndexType.MAIN_INVENTORY, Container.IndexType.HOTBAR -> {
                if (!this.moveItemStackTo(stack, 0, 1, false)) {
                    yield true;
                }
                yield false;
            }
            case Container.IndexType.CONTAINER -> !this.moveItemStackTo(stack, this.containerSlots, this.slots.size(), false);
        };
    }

    @Override
    protected void addContainerSlots() {
        if (this.mold != null) {
            this.addSlot((Slot)new CallbackSlot(this, (IItemHandler)this.inventory, 0, 80, 34));
        }
    }

    @Override
    public int getSlotStackLimit(int slot) {
        return 1;
    }

    @Override
    public boolean isItemValid(int slot, ItemStack stack) {
        return Helpers.mightHaveCapability(stack, Capabilities.FluidHandler.ITEM);
    }

    public IItemHandler getInventory() {
        return this.inventory;
    }
}

