/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.container;

import net.dries007.tfc.common.TFCTags;
import net.dries007.tfc.common.blockentities.PotBlockEntity;
import net.dries007.tfc.common.container.BlockEntityContainer;
import net.dries007.tfc.common.container.Container;
import net.dries007.tfc.common.container.TFCContainerTypes;
import net.dries007.tfc.common.container.slot.CallbackSlot;
import net.dries007.tfc.util.Helpers;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

public class PotContainer
extends BlockEntityContainer<PotBlockEntity> {
    public static PotContainer create(PotBlockEntity pot, Inventory playerInv, int windowId) {
        return (PotContainer)((Object)new PotContainer(pot, windowId).init(playerInv, 20));
    }

    private PotContainer(PotBlockEntity pot, int windowId) {
        super((MenuType)TFCContainerTypes.POT.get(), windowId, pot);
        this.addDataSlots(pot.getSyncableData());
    }

    @Override
    protected boolean moveStack(ItemStack stack, int slotIndex) {
        return switch (this.typeOf(slotIndex)) {
            default -> throw new MatchException(null, null);
            case Container.IndexType.MAIN_INVENTORY, Container.IndexType.HOTBAR -> {
                if (Helpers.isItem(stack, TFCTags.Items.FIREPIT_FUEL)) {
                    if (!this.moveItemStackTo(stack, 0, 4, false)) {
                        yield true;
                    }
                    yield false;
                }
                if (((PotBlockEntity)this.blockEntity).hasRecipeStarted() || !this.moveItemStackTo(stack, 4, 9, false)) {
                    yield true;
                }
                yield false;
            }
            case Container.IndexType.CONTAINER -> !this.moveItemStackTo(stack, this.containerSlots, this.slots.size(), false);
        };
    }

    @Override
    protected void addContainerSlots() {
        for (int i = 0; i < 4; ++i) {
            this.addSlot((Slot)new CallbackSlot(this.blockEntity, i, 8, 70 - 18 * i));
        }
        this.addSlot((Slot)new CallbackSlot(this.blockEntity, 4, 65, 23));
        this.addSlot((Slot)new CallbackSlot(this.blockEntity, 5, 83, 23));
        this.addSlot((Slot)new CallbackSlot(this.blockEntity, 6, 56, 41));
        this.addSlot((Slot)new CallbackSlot(this.blockEntity, 7, 74, 41));
        this.addSlot((Slot)new CallbackSlot(this.blockEntity, 8, 92, 41));
    }
}

