/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.container.slot;

import net.dries007.tfc.common.blockentities.InventoryBlockEntity;
import net.dries007.tfc.common.container.ISlotCallback;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.SlotItemHandler;

public class CallbackSlot
extends SlotItemHandler {
    private final ISlotCallback callback;

    public CallbackSlot(InventoryBlockEntity<?> inventory, int index, int x, int y) {
        this(inventory, (IItemHandler)inventory.getInventory(), index, x, y);
    }

    public CallbackSlot(ISlotCallback callback, IItemHandler inventory, int index, int x, int y) {
        super(inventory, index, x, y);
        this.callback = callback;
    }

    public void onTake(Player player, ItemStack stack) {
        this.callback.onSlotTake(player, this.getSlotIndex(), stack);
        super.onTake(player, stack);
    }

    public void setChanged() {
        this.callback.setAndUpdateSlots(this.getSlotIndex());
        super.setChanged();
    }

    public boolean mayPlace(ItemStack stack) {
        return this.callback.isItemValid(this.getSlotIndex(), stack) && super.mayPlace(stack);
    }

    public int getMaxStackSize() {
        return Math.min(this.callback.getSlotStackLimit(this.getSlotIndex()), super.getMaxStackSize());
    }
}

