/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.entities;

import java.util.List;
import java.util.Optional;
import net.dries007.tfc.common.entities.ai.TFCAvoidEntityGoal;
import net.dries007.tfc.common.entities.livestock.TFCAnimalProperties;
import net.dries007.tfc.common.fluids.FluidHelpers;
import net.dries007.tfc.util.calendar.Calendars;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.Holder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.GoalSelector;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.Bucketable;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.MobBucketItem;
import net.minecraft.world.level.LevelReader;
import net.neoforged.neoforge.fluids.FluidStack;

public final class EntityHelpers {
    public static void replaceAvoidEntityGoal(PathfinderMob mob, GoalSelector selector, int priority) {
        selector.getAvailableGoals().removeIf(wrapped -> wrapped.getGoal() instanceof AvoidEntityGoal);
        selector.addGoal(priority, new TFCAvoidEntityGoal<Player>(mob, Player.class, 8.0f, 5.0, 5.4));
    }

    public static void removeGoalOfPriority(GoalSelector selector, int priority) {
        selector.getAvailableGoals().removeIf(wrapped -> wrapped.getPriority() == priority);
    }

    public static void removeGoalOfClass(GoalSelector selector, Class<?> clazz) {
        selector.getAvailableGoals().removeIf(wrapped -> wrapped.getGoal().getClass() == clazz);
    }

    public static <T extends LivingEntity> Optional<InteractionResult> bucketMobPickup(Player player, InteractionHand hand, T entity) {
        ItemStack held = player.getItemInHand(hand);
        ItemStack bucketItem = ((Bucketable)entity).getBucketItemStack();
        if (bucketItem.getItem() instanceof MobBucketItem && held.getItem() instanceof BucketItem && FluidStack.isSameFluidSameComponents((FluidStack)FluidHelpers.getContainedFluid(bucketItem), (FluidStack)FluidHelpers.getContainedFluid(held)) && entity.isAlive()) {
            entity.playSound(((Bucketable)entity).getPickupSound(), 1.0f, 1.0f);
            ((Bucketable)entity).saveToBucketTag(bucketItem);
            ItemStack filledStack = ItemUtils.createFilledResult((ItemStack)held, (Player)player, (ItemStack)bucketItem, (boolean)false);
            player.setItemInHand(hand, filledStack);
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                CriteriaTriggers.FILLED_BUCKET.trigger(serverPlayer, bucketItem);
            }
            entity.discard();
            return Optional.of(InteractionResult.sidedSuccess((boolean)entity.level().isClientSide));
        }
        return Optional.empty();
    }

    public static long getRandomGrowth(Entity entity, RandomSource random, int daysToAdult) {
        if (random.nextFloat() < 0.05f) {
            return Calendars.get((LevelReader)entity.level()).getTicks() + (long)random.nextInt(240000);
        }
        int lifeTimeDays = (daysToAdult + random.nextInt(daysToAdult)) * 24000;
        return Calendars.get((LevelReader)entity.level()).getTicks() - (long)lifeTimeDays;
    }

    public static void setNullableAttribute(LivingEntity entity, Holder<Attribute> attribute, double baseValue) {
        AttributeInstance instance = entity.getAttribute(attribute);
        if (instance != null) {
            instance.setBaseValue(baseValue);
        }
    }

    public static int getIntOrDefault(CompoundTag nbt, String key, int defaultInt) {
        return nbt.contains(key, 3) ? nbt.getInt(key) : defaultInt;
    }

    public static String getStringOrDefault(CompoundTag nbt, String key, String defaultString) {
        return nbt.contains(key, 8) ? nbt.getString(key) : defaultString;
    }

    public static float getFloatOrDefault(CompoundTag nbt, String key, float defaultFloat) {
        return nbt.contains(key, 5) ? nbt.getFloat(key) : defaultFloat;
    }

    public static long getLongOrDefault(CompoundTag nbt, String key, long defaultLong) {
        return nbt.contains(key, 4) ? nbt.getLong(key) : defaultLong;
    }

    public static <T extends Animal> void findFemaleMate(T maleAnimal) {
        List list = maleAnimal.level().getEntitiesOfClass(Animal.class, maleAnimal.getBoundingBox().inflate(8.0));
        for (Animal femaleAnimal : list) {
            TFCAnimalProperties femaleData;
            if (!(femaleAnimal instanceof TFCAnimalProperties) || !(femaleData = (TFCAnimalProperties)femaleAnimal).isFemale() || femaleAnimal.isInLove() || !femaleData.isReadyToMate() || !femaleData.checkExtraBreedConditions((TFCAnimalProperties)maleAnimal)) continue;
            femaleAnimal.setInLove(null);
            maleAnimal.setInLove(null);
            break;
        }
    }

    public static boolean isMovingOnLand(Entity entity) {
        return entity.onGround() && entity.getDeltaMovement().lengthSqr() > 1.0E-6 && !entity.isInWaterOrBubble();
    }

    public static boolean isMovingInWater(Entity entity) {
        return entity.isInWaterOrBubble();
    }

    public static boolean startOrStop(AnimationState state, boolean go, int tickCount) {
        if (go) {
            state.startIfStopped(tickCount);
        } else {
            state.stop();
        }
        return go;
    }

    public static double createOffspringAttribute(double value1, double value2, double min, double max, RandomSource random) {
        double gaussian;
        if (max <= min) {
            throw new IllegalArgumentException("Incorrect range for an attribute");
        }
        value1 = Mth.clamp((double)value1, (double)min, (double)max);
        value2 = Mth.clamp((double)value2, (double)min, (double)max);
        double wiggleRoom = 0.15 * (max - min);
        double average = (value1 + value2) / 2.0;
        double randomRange = Math.abs(value1 - value2) + wiggleRoom * 2.0;
        double newValue = average + randomRange * (gaussian = (random.nextDouble() + random.nextDouble() + random.nextDouble()) / 3.0 - 0.5);
        if (newValue > max) {
            double diff = newValue - max;
            return max - diff;
        }
        if (newValue < min) {
            double diff = min - newValue;
            return min + diff;
        }
        return newValue;
    }
}

