/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.entities;

import java.util.Map;
import java.util.function.Supplier;
import net.dries007.tfc.client.overworld.SolarCalculator;
import net.dries007.tfc.common.entities.Fauna;
import net.dries007.tfc.common.entities.TFCEntities;
import net.dries007.tfc.common.entities.ai.predator.PackPredator;
import net.dries007.tfc.common.entities.ai.prey.TFCOcelot;
import net.dries007.tfc.common.entities.aquatic.AquaticCritter;
import net.dries007.tfc.common.entities.aquatic.AquaticMob;
import net.dries007.tfc.common.entities.aquatic.Fish;
import net.dries007.tfc.common.entities.aquatic.FreshwaterFish;
import net.dries007.tfc.common.entities.aquatic.Jellyfish;
import net.dries007.tfc.common.entities.aquatic.LeopardSeal;
import net.dries007.tfc.common.entities.aquatic.Manatee;
import net.dries007.tfc.common.entities.aquatic.Octopoteuthis;
import net.dries007.tfc.common.entities.aquatic.Penguin;
import net.dries007.tfc.common.entities.aquatic.TFCCod;
import net.dries007.tfc.common.entities.aquatic.TFCDolphin;
import net.dries007.tfc.common.entities.aquatic.TFCPufferfish;
import net.dries007.tfc.common.entities.aquatic.TFCSquid;
import net.dries007.tfc.common.entities.aquatic.TFCTropicalFish;
import net.dries007.tfc.common.entities.aquatic.TFCTurtle;
import net.dries007.tfc.common.entities.livestock.DairyAnimal;
import net.dries007.tfc.common.entities.livestock.Mammal;
import net.dries007.tfc.common.entities.livestock.OviparousAnimal;
import net.dries007.tfc.common.entities.livestock.WoolyAnimal;
import net.dries007.tfc.common.entities.livestock.horse.TFCDonkey;
import net.dries007.tfc.common.entities.livestock.horse.TFCHorse;
import net.dries007.tfc.common.entities.livestock.horse.TFCMule;
import net.dries007.tfc.common.entities.predator.AmphibiousPredator;
import net.dries007.tfc.common.entities.predator.FelinePredator;
import net.dries007.tfc.common.entities.predator.Predator;
import net.dries007.tfc.common.entities.prey.Prey;
import net.dries007.tfc.common.entities.prey.RammingPrey;
import net.dries007.tfc.common.entities.prey.TFCFox;
import net.dries007.tfc.common.entities.prey.TFCFrog;
import net.dries007.tfc.common.entities.prey.TFCPanda;
import net.dries007.tfc.common.entities.prey.TFCRabbit;
import net.dries007.tfc.common.entities.prey.WingedPrey;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.calendar.Calendars;
import net.dries007.tfc.util.data.DataManager;
import net.dries007.tfc.util.registry.IdHolder;
import net.dries007.tfc.world.chunkdata.ChunkData;
import net.minecraft.core.BlockPos;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.SpawnPlacementType;
import net.minecraft.world.entity.SpawnPlacementTypes;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.Heightmap;
import net.neoforged.neoforge.event.entity.RegisterSpawnPlacementsEvent;

public class Faunas {
    public static final Id<TFCCod> COD = Faunas.registerFish(TFCEntities.COD);
    public static final Id<Jellyfish> JELLYFISH = Faunas.registerFish(TFCEntities.JELLYFISH);
    public static final Id<TFCTropicalFish> TROPICAL_FISH = Faunas.registerFish(TFCEntities.TROPICAL_FISH);
    public static final Id<TFCPufferfish> PUFFERFISH = Faunas.registerFish(TFCEntities.PUFFERFISH);
    public static final Map<Fish, Id<FreshwaterFish>> FISH = Helpers.mapOf(Fish.class, fish -> Faunas.registerFish((IdHolder)TFCEntities.FRESHWATER_FISH.get(fish)));
    public static final Id<AquaticCritter> LOBSTER = Faunas.registerFish(TFCEntities.LOBSTER);
    public static final Id<AquaticCritter> CRAYFISH = Faunas.registerFish(TFCEntities.CRAYFISH);
    public static final Id<AquaticCritter> ISOPOD = Faunas.registerFish(TFCEntities.ISOPOD);
    public static final Id<AquaticCritter> HORSESHOE_CRAB = Faunas.registerFish(TFCEntities.HORSESHOE_CRAB);
    public static final Id<TFCDolphin> DOLPHIN = Faunas.registerFish(TFCEntities.DOLPHIN);
    public static final Id<TFCDolphin> ORCA = Faunas.registerFish(TFCEntities.ORCA);
    public static final Id<Manatee> MANATEE = Faunas.registerFish(TFCEntities.MANATEE);
    public static final Id<TFCTurtle> TURTLE = Faunas.registerAnimal(TFCEntities.TURTLE);
    public static final Id<Penguin> PENGUIN = Faunas.registerAnimal(TFCEntities.PENGUIN);
    public static final Id<LeopardSeal> LEOPARD_SEAL = Faunas.registerAnimal(TFCEntities.LEOPARD_SEAL);
    public static final Id<TFCFrog> FROG = Faunas.registerAnimal(TFCEntities.FROG);
    public static final Id<Predator> POLAR_BEAR = Faunas.registerAnimal(TFCEntities.POLAR_BEAR);
    public static final Id<Predator> GRIZZLY_BEAR = Faunas.registerAnimal(TFCEntities.GRIZZLY_BEAR);
    public static final Id<Predator> BLACK_BEAR = Faunas.registerAnimal(TFCEntities.BLACK_BEAR);
    public static final Id<FelinePredator> COUGAR = Faunas.registerAnimal(TFCEntities.COUGAR);
    public static final Id<FelinePredator> PANTHER = Faunas.registerAnimal(TFCEntities.PANTHER);
    public static final Id<FelinePredator> LION = Faunas.registerAnimal(TFCEntities.LION);
    public static final Id<FelinePredator> SABERTOOTH = Faunas.registerAnimal(TFCEntities.SABERTOOTH);
    public static final Id<FelinePredator> TIGER = Faunas.registerAnimal(TFCEntities.TIGER);
    public static final Id<AmphibiousPredator> CROCODILE = Faunas.registerAmphibiousPredator(TFCEntities.CROCODILE);
    public static final Id<PackPredator> WOLF = Faunas.registerAnimal(TFCEntities.WOLF);
    public static final Id<PackPredator> HYENA = Faunas.registerAnimal(TFCEntities.HYENA);
    public static final Id<PackPredator> DIREWOLF = Faunas.registerAnimal(TFCEntities.DIREWOLF);
    public static final Id<TFCSquid> SQUID = Faunas.registerFish(TFCEntities.SQUID);
    public static final Id<Octopoteuthis> OCTOPOTEUTHIS = Faunas.registerFish(TFCEntities.OCTOPOTEUTHIS);
    public static final Id<Mammal> PIG = Faunas.registerAnimal(TFCEntities.PIG);
    public static final Id<DairyAnimal> COW = Faunas.registerAnimal(TFCEntities.COW);
    public static final Id<DairyAnimal> GOAT = Faunas.registerAnimal(TFCEntities.GOAT);
    public static final Id<DairyAnimal> YAK = Faunas.registerAnimal(TFCEntities.YAK);
    public static final Id<WoolyAnimal> ALPACA = Faunas.registerAnimal(TFCEntities.ALPACA);
    public static final Id<WoolyAnimal> SHEEP = Faunas.registerAnimal(TFCEntities.SHEEP);
    public static final Id<WoolyAnimal> MUSK_OX = Faunas.registerAnimal(TFCEntities.MUSK_OX);
    public static final Id<OviparousAnimal> CHICKEN = Faunas.registerAnimal(TFCEntities.CHICKEN);
    public static final Id<OviparousAnimal> DUCK = Faunas.registerAnimal(TFCEntities.DUCK);
    public static final Id<OviparousAnimal> QUAIL = Faunas.registerAnimal(TFCEntities.QUAIL);
    public static final Id<TFCRabbit> RABBIT = Faunas.registerAnimal(TFCEntities.RABBIT);
    public static final Id<TFCFox> FOX = Faunas.registerAnimal(TFCEntities.FOX);
    public static final Id<TFCPanda> PANDA = Faunas.registerAnimal(TFCEntities.PANDA);
    public static final Id<TFCOcelot> OCELOT = Faunas.registerAnimal(TFCEntities.OCELOT);
    public static final Id<RammingPrey> BOAR = Faunas.registerAnimal(TFCEntities.BOAR);
    public static final Id<RammingPrey> WILDEBEEST = Faunas.registerAnimal(TFCEntities.WILDEBEEST);
    public static final Id<RammingPrey> BISON = Faunas.registerAnimal(TFCEntities.BISON);
    public static final Id<Prey> BONGO = Faunas.registerAnimal(TFCEntities.BONGO);
    public static final Id<Prey> CARIBOU = Faunas.registerAnimal(TFCEntities.CARIBOU);
    public static final Id<Prey> DEER = Faunas.registerAnimal(TFCEntities.DEER);
    public static final Id<Prey> GAZELLE = Faunas.registerAnimal(TFCEntities.GAZELLE);
    public static final Id<RammingPrey> MOOSE = Faunas.registerAnimal(TFCEntities.MOOSE);
    public static final Id<WingedPrey> GROUSE = Faunas.registerAnimal(TFCEntities.GROUSE);
    public static final Id<WingedPrey> PHEASANT = Faunas.registerAnimal(TFCEntities.PHEASANT);
    public static final Id<WingedPrey> TURKEY = Faunas.registerAnimal(TFCEntities.TURKEY);
    public static final Id<WingedPrey> PEAFOWL = Faunas.registerAnimal(TFCEntities.PEAFOWL);
    public static final Id<TFCDonkey> DONKEY = Faunas.registerAnimal(TFCEntities.DONKEY);
    public static final Id<TFCMule> MULE = Faunas.registerAnimal(TFCEntities.MULE);
    public static final Id<TFCHorse> HORSE = Faunas.registerAnimal(TFCEntities.HORSE);

    public static void registerSpawnPlacements(RegisterSpawnPlacementsEvent event) {
        FISH.values().forEach(fish -> Faunas.registerSpawnPlacement(event, fish));
        Faunas.registerSpawnPlacement(event, COD);
        Faunas.registerSpawnPlacement(event, JELLYFISH);
        Faunas.registerSpawnPlacement(event, TROPICAL_FISH);
        Faunas.registerSpawnPlacement(event, PUFFERFISH);
        Faunas.registerSpawnPlacement(event, LOBSTER);
        Faunas.registerSpawnPlacement(event, CRAYFISH);
        Faunas.registerSpawnPlacement(event, ISOPOD);
        Faunas.registerSpawnPlacement(event, HORSESHOE_CRAB);
        Faunas.registerSpawnPlacement(event, DOLPHIN);
        Faunas.registerSpawnPlacement(event, ORCA);
        Faunas.registerSpawnPlacement(event, MANATEE);
        Faunas.registerSpawnPlacement(event, TURTLE);
        Faunas.registerSpawnPlacement(event, PENGUIN);
        Faunas.registerSpawnPlacement(event, LEOPARD_SEAL);
        Faunas.registerSpawnPlacement(event, FROG);
        Faunas.registerSpawnPlacement(event, POLAR_BEAR);
        Faunas.registerSpawnPlacement(event, GRIZZLY_BEAR);
        Faunas.registerSpawnPlacement(event, BLACK_BEAR);
        Faunas.registerSpawnPlacement(event, COUGAR);
        Faunas.registerSpawnPlacement(event, PANTHER);
        Faunas.registerSpawnPlacement(event, LION);
        Faunas.registerSpawnPlacement(event, SABERTOOTH);
        Faunas.registerSpawnPlacement(event, TIGER);
        Faunas.registerSpawnPlacement(event, CROCODILE);
        Faunas.registerSpawnPlacement(event, SQUID);
        Faunas.registerSpawnPlacement(event, OCTOPOTEUTHIS);
        Faunas.registerSpawnPlacement(event, PIG);
        Faunas.registerSpawnPlacement(event, COW);
        Faunas.registerSpawnPlacement(event, GOAT);
        Faunas.registerSpawnPlacement(event, YAK);
        Faunas.registerSpawnPlacement(event, ALPACA);
        Faunas.registerSpawnPlacement(event, SHEEP);
        Faunas.registerSpawnPlacement(event, MUSK_OX);
        Faunas.registerSpawnPlacement(event, CHICKEN);
        Faunas.registerSpawnPlacement(event, DUCK);
        Faunas.registerSpawnPlacement(event, QUAIL);
        Faunas.registerSpawnPlacement(event, RABBIT);
        Faunas.registerSpawnPlacement(event, FOX);
        Faunas.registerSpawnPlacement(event, PANDA);
        Faunas.registerSpawnPlacement(event, OCELOT);
        Faunas.registerSpawnPlacement(event, BOAR);
        Faunas.registerSpawnPlacement(event, WILDEBEEST);
        Faunas.registerSpawnPlacement(event, BISON);
        Faunas.registerSpawnPlacement(event, MOOSE);
        Faunas.registerSpawnPlacement(event, BONGO);
        Faunas.registerSpawnPlacement(event, CARIBOU);
        Faunas.registerSpawnPlacement(event, DEER);
        Faunas.registerSpawnPlacement(event, GAZELLE);
        Faunas.registerSpawnPlacement(event, GROUSE);
        Faunas.registerSpawnPlacement(event, PHEASANT);
        Faunas.registerSpawnPlacement(event, TURKEY);
        Faunas.registerSpawnPlacement(event, PEAFOWL);
        Faunas.registerSpawnPlacement(event, DONKEY);
        Faunas.registerSpawnPlacement(event, MULE);
        Faunas.registerSpawnPlacement(event, HORSE);
        Faunas.registerSpawnPlacement(event, WOLF);
        Faunas.registerSpawnPlacement(event, HYENA);
        Faunas.registerSpawnPlacement(event, DIREWOLF);
    }

    private static <E extends Mob> Id<E> registerAnimal(IdHolder<EntityType<E>> entity) {
        return Faunas.register(entity, SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES);
    }

    private static <E extends Mob> Id<E> registerFish(IdHolder<EntityType<E>> entity) {
        return Faunas.register(entity, SpawnPlacementTypes.IN_WATER, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES);
    }

    private static <E extends Mob> Id<E> registerAmphibiousPredator(IdHolder<EntityType<E>> entity) {
        return Faunas.register(entity, SpawnPlacementTypes.NO_RESTRICTIONS, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES);
    }

    private static <E extends Mob> Id<E> register(IdHolder<EntityType<E>> entity, SpawnPlacementType spawnPlacement, Heightmap.Types heightmapType) {
        return new Id<E>(entity, Fauna.MANAGER.getReference(entity.getId()), spawnPlacement, heightmapType);
    }

    private static <E extends Mob> void registerSpawnPlacement(RegisterSpawnPlacementsEvent event, Id<E> type) {
        event.register(type.entity().get(), type.spawnPlacementType(), type.heightmapType(), (mob, level, heightmap, pos, rand) -> {
            AquaticMob aquaticMob;
            Fauna fauna = type.fauna().get();
            ChunkGenerator generator = level.getLevel().getChunkSource().getGenerator();
            if (rand.nextInt(fauna.chance()) != 0) {
                return false;
            }
            if (mob instanceof AquaticMob && !(aquaticMob = (AquaticMob)mob).canSpawnIn(level.getFluidState(pos).getType())) {
                return false;
            }
            int seaLevel = generator.getSeaLevel();
            if (fauna.distanceBelowSeaLevel() != -1 && pos.getY() > seaLevel - fauna.distanceBelowSeaLevel()) {
                return false;
            }
            ChunkData data = ChunkData.get((LevelReader)level, pos);
            if (!fauna.climate().isValid(data, pos, rand, SolarCalculator.getInNorthernHemisphere(pos, (Level)level.getLevel()))) {
                return false;
            }
            BlockPos below = pos.below();
            if (fauna.solidGround() && !Helpers.isBlock(level.getBlockState(below), (TagKey<Block>)BlockTags.VALID_SPAWN)) {
                return false;
            }
            if (!fauna.months().isEmpty() && !fauna.months().contains((Object)Calendars.SERVER.getHemispheralCalendarMonthOfYear(SolarCalculator.getInNorthernHemisphere(pos, (Level)level.getLevel())))) {
                return false;
            }
            return fauna.maxBrightness() == -1 || level.getRawBrightness(pos, 0) <= fauna.maxBrightness();
        }, RegisterSpawnPlacementsEvent.Operation.REPLACE);
    }

    public record Id<E extends Mob>(Supplier<EntityType<E>> entity, DataManager.Reference<Fauna> fauna, SpawnPlacementType spawnPlacementType, Heightmap.Types heightmapType) {
    }
}

