/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.entities;

import net.dries007.tfc.common.blocks.TFCBlocks;
import net.dries007.tfc.common.blocks.TFCLightBlock;
import net.dries007.tfc.common.fluids.FluidHelpers;
import net.dries007.tfc.util.Helpers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.Fluid;

public interface IGlow {
    default public Entity getEntity() {
        return (Entity)this;
    }

    public void setLightPos(BlockPos var1);

    public BlockPos getLightPos();

    default public int getLightLevel() {
        return 10;
    }

    default public int getLightUpdateDistanceSqr() {
        return 9;
    }

    default public int getLightUpdateInterval() {
        return 20;
    }

    default public void saveLight(CompoundTag tag) {
        BlockPos light = this.getLightPos();
        tag.putInt("lightX", light.getX());
        tag.putInt("lightY", light.getY());
        tag.putInt("lightZ", light.getZ());
    }

    default public void readLight(CompoundTag tag) {
        this.setLightPos(new BlockPos(tag.getInt("lightX"), tag.getInt("lightY"), tag.getInt("lightZ")));
    }

    default public void tickGlow() {
        Entity entity = this.getEntity();
        if (entity.tickCount % this.getLightUpdateInterval() == 0) {
            boolean initialized;
            BlockPos oldPos = this.getLightPos();
            BlockPos currentPos = entity.blockPosition();
            boolean bl = initialized = !oldPos.equals((Object)BlockPos.ZERO);
            if (oldPos.distSqr((Vec3i)currentPos) > (double)this.getLightUpdateDistanceSqr() || !initialized) {
                BlockState newState;
                if (initialized && entity.level().hasChunkAt(oldPos) && Helpers.isBlock(entity.level().getBlockState(oldPos), (Block)TFCBlocks.LIGHT.get())) {
                    entity.level().setBlockAndUpdate(oldPos, entity.level().getFluidState(oldPos).createLegacyBlock());
                }
                BlockState currentState = entity.level().getBlockState(currentPos);
                Fluid fluid = currentState.getFluidState().getType();
                if (FluidHelpers.isAirOrEmptyFluid(currentState) && !currentState.hasProperty((Property)FlowingFluid.LEVEL) && (newState = FluidHelpers.fillWithFluid((BlockState)((Block)TFCBlocks.LIGHT.get()).defaultBlockState().setValue((Property)TFCLightBlock.LEVEL, (Comparable)Integer.valueOf(this.getLightLevel())), fluid)) != null) {
                    entity.level().setBlockAndUpdate(currentPos, newState);
                    this.setLightPos(currentPos);
                }
            }
        }
    }

    default public void tryRemoveLight() {
        Entity entity = this.getEntity();
        Level level = entity.level();
        if (!level.isLoaded(entity.blockPosition())) {
            return;
        }
        BlockPos light = this.getLightPos();
        BlockState state = level.getBlockState(light);
        if (Helpers.isBlock(state, (Block)TFCBlocks.LIGHT.get())) {
            level.setBlockAndUpdate(light, state.getFluidState().createLegacyBlock());
        }
    }
}

