/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.entities.ai;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import java.util.Optional;
import java.util.function.Predicate;
import net.dries007.tfc.util.Helpers;
import net.minecraft.tags.TagKey;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.behavior.BehaviorControl;
import net.minecraft.world.entity.ai.behavior.EntityTracker;
import net.minecraft.world.entity.ai.behavior.SetEntityLookTargetSometimes;
import net.minecraft.world.entity.ai.behavior.declarative.BehaviorBuilder;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.NearestVisibleLivingEntities;

public class SetLookTarget {
    public static BehaviorControl<LivingEntity> create(float distance, UniformInt interval) {
        return SetLookTarget.create(distance, interval, (LivingEntity p) -> true);
    }

    public static BehaviorControl<LivingEntity> create(EntityType<?> type, float distance, UniformInt interval) {
        return SetLookTarget.create(distance, interval, (LivingEntity e) -> type.equals(e.getType()));
    }

    public static BehaviorControl<LivingEntity> create(TagKey<EntityType<?>> tag, float distance, UniformInt interval) {
        return SetLookTarget.create(distance, interval, (LivingEntity e) -> Helpers.isEntity((Entity)e, tag));
    }

    public static BehaviorControl<LivingEntity> create(float distance, UniformInt interval, Predicate<LivingEntity> predicate) {
        float f = distance * distance;
        SetEntityLookTargetSometimes.Ticker setLookTargetTicker = new SetEntityLookTargetSometimes.Ticker(interval);
        return BehaviorBuilder.create(instance -> instance.group((App)instance.absent(MemoryModuleType.LOOK_TARGET), (App)instance.present(MemoryModuleType.NEAREST_VISIBLE_LIVING_ENTITIES)).apply((Applicative)instance, (posTracker, nearVisible) -> (server, entity, time) -> {
            Optional optional = ((NearestVisibleLivingEntities)instance.get(nearVisible)).findClosest(predicate.and(e -> e.distanceToSqr((Entity)entity) <= (double)f));
            if (optional.isEmpty()) {
                return false;
            }
            if (!setLookTargetTicker.tickDownAndCheck(server.random)) {
                return false;
            }
            posTracker.set((Object)new EntityTracker((Entity)optional.get(), true));
            return true;
        }));
    }
}

