/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.entities.ai.amphibian;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.dries007.tfc.common.entities.aquatic.AmphibiousAnimal;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;

public class AmphibianPlayDeadBehavior
extends Behavior<AmphibiousAnimal> {
    public static void update(AmphibiousAnimal animal) {
        Brain<AmphibiousAnimal> brain = animal.getBrain();
        brain.getMemory(MemoryModuleType.PLAY_DEAD_TICKS).ifPresent(integer -> {
            if (integer <= 0) {
                brain.eraseMemory(MemoryModuleType.PLAY_DEAD_TICKS);
                brain.eraseMemory(MemoryModuleType.HURT_BY_ENTITY);
                brain.useDefaultActivity();
            } else {
                brain.setMemory(MemoryModuleType.PLAY_DEAD_TICKS, (Object)(integer - 1));
            }
        });
    }

    public AmphibianPlayDeadBehavior() {
        super((Map)ImmutableMap.of((Object)MemoryModuleType.PLAY_DEAD_TICKS, (Object)MemoryStatus.VALUE_PRESENT, (Object)MemoryModuleType.HURT_BY_ENTITY, (Object)MemoryStatus.VALUE_PRESENT), 200);
    }

    protected boolean canStillUse(ServerLevel level, AmphibiousAnimal animal, long time) {
        return animal.getBrain().hasMemoryValue(MemoryModuleType.PLAY_DEAD_TICKS);
    }

    protected void start(ServerLevel level, AmphibiousAnimal animal, long time) {
        Brain<AmphibiousAnimal> brain = animal.getBrain();
        brain.eraseMemory(MemoryModuleType.WALK_TARGET);
        brain.eraseMemory(MemoryModuleType.LOOK_TARGET);
        if (animal.isPlayingDeadEffective()) {
            animal.addEffect(new MobEffectInstance(MobEffects.REGENERATION, 200, 0, false, false));
            animal.addEffect(new MobEffectInstance(MobEffects.DAMAGE_RESISTANCE, 200, 2, false, false));
        }
    }
}

