/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.entities.ai.amphibian;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import java.util.Optional;
import java.util.function.Function;
import net.dries007.tfc.common.TFCTags;
import net.dries007.tfc.util.Helpers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.behavior.OneShot;
import net.minecraft.world.entity.ai.behavior.declarative.BehaviorBuilder;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.WalkTarget;
import net.minecraft.world.entity.ai.util.AirAndWaterRandomPos;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.Vec3;

public class AmphibiousSetWalkTargetAwayFrom {
    public static OneShot<PathfinderMob> entity(MemoryModuleType<LivingEntity> walkTargetAwayFromMemory, Function<LivingEntity, Float> speedModifier, int desiredDistance, boolean hasTarget) {
        return AmphibiousSetWalkTargetAwayFrom.create(walkTargetAwayFromMemory, speedModifier, desiredDistance, hasTarget, Entity::position);
    }

    private static <T> OneShot<PathfinderMob> create(MemoryModuleType<LivingEntity> walkTargetAwayFromMemory, Function<LivingEntity, Float> speedModifier, int desiredDistance, boolean hasTarget, Function<T, Vec3> toPosition) {
        return BehaviorBuilder.create(m -> m.group((App)m.registered(MemoryModuleType.WALK_TARGET), (App)m.present(walkTargetAwayFromMemory)).apply((Applicative)m, (pathToTarget, memoryAccessor) -> (level, mob, distance) -> {
            LivingEntity attacker;
            Vec3 escapeFromPos;
            Optional optional = m.tryGet(pathToTarget);
            if (optional.isPresent() && !hasTarget) {
                return false;
            }
            Vec3 currentPos = mob.position();
            if (!currentPos.closerThan((Position)(escapeFromPos = (attacker = (LivingEntity)m.get(memoryAccessor)).position()), (double)desiredDistance)) {
                return false;
            }
            if (optional.isPresent() && ((WalkTarget)optional.get()).getSpeedModifier() == ((Float)speedModifier.apply(mob)).floatValue() && AmphibiousSetWalkTargetAwayFrom.isTargetPosValidForEscape(currentPos, escapeFromPos, ((WalkTarget)optional.get()).getTarget().currentPosition())) {
                return false;
            }
            Vec3 bestLandEscapePos = currentPos;
            Vec3 bestWaterEscapePos = currentPos;
            for (int i = 0; i < 25; ++i) {
                Vec3 destination = AirAndWaterRandomPos.getPos((PathfinderMob)mob, (int)10, (int)7, (int)3, (double)0.0, (double)0.0, (double)1.0);
                if (destination != null) {
                    BlockPos pos = new BlockPos((int)destination.x, (int)destination.y, (int)destination.z);
                    BlockState state = level.getBlockState(pos);
                    if (Helpers.isFluid(state.getFluidState(), (TagKey<Fluid>)FluidTags.WATER)) {
                        bestWaterEscapePos = AmphibiousSetWalkTargetAwayFrom.getVectorFartherFromChaser(escapeFromPos, bestWaterEscapePos, destination);
                    } else {
                        BlockState belowState = level.getBlockState(pos.below());
                        if (!belowState.isEmpty() && !Helpers.isFluid(belowState.getFluidState(), (TagKey<Fluid>)FluidTags.WATER)) {
                            bestLandEscapePos = AmphibiousSetWalkTargetAwayFrom.getVectorFartherFromChaser(escapeFromPos, bestLandEscapePos, destination);
                        }
                    }
                }
                if (Helpers.isEntity((Entity)attacker, TFCTags.Entities.OCEAN_PREDATORS) && AmphibiousSetWalkTargetAwayFrom.isTargetPosValidForEscape(currentPos, escapeFromPos, bestLandEscapePos)) {
                    pathToTarget.set((Object)new WalkTarget(bestLandEscapePos, ((Float)speedModifier.apply(mob)).floatValue(), 0));
                    continue;
                }
                Vec3 bestEscapePos = AmphibiousSetWalkTargetAwayFrom.getVectorFartherFromChaser(escapeFromPos, bestLandEscapePos, bestWaterEscapePos);
                pathToTarget.set((Object)new WalkTarget(bestEscapePos, ((Float)speedModifier.apply(mob)).floatValue(), 0));
            }
            return true;
        }));
    }

    private static Vec3 getVectorFartherFromChaser(Vec3 escapeFromPos, Vec3 vector0, Vec3 vector1) {
        Vec3 delta0 = escapeFromPos.subtract(vector0);
        Vec3 delta1 = escapeFromPos.subtract(vector1);
        if (delta0.lengthSqr() > delta1.lengthSqr()) {
            return vector0;
        }
        return vector1;
    }

    private static boolean isTargetPosValidForEscape(Vec3 currentPos, Vec3 escapeFromPos, Vec3 destinationPos) {
        Vec3 escapeFromDelta;
        Vec3 destinationDelta = destinationPos.subtract(currentPos);
        return destinationDelta.dot(escapeFromDelta = escapeFromPos.subtract(currentPos)) < 0.0;
    }
}

