/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.entities.ai.livestock;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Optional;
import net.dries007.tfc.common.entities.BrainAnimalBehavior;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.behavior.BehaviorUtils;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.memory.NearestVisibleLivingEntities;
import net.minecraft.world.entity.animal.Animal;

public class BreedBehavior<T extends Animal>
extends Behavior<T> {
    private final float speedModifier;
    private long spawnChildAtTime;
    private long nextAttemptTime = -1L;

    public BreedBehavior(float speed) {
        super((Map)ImmutableMap.of((Object)MemoryModuleType.NEAREST_VISIBLE_LIVING_ENTITIES, (Object)MemoryStatus.VALUE_PRESENT, (Object)MemoryModuleType.BREED_TARGET, (Object)MemoryStatus.VALUE_ABSENT, (Object)MemoryModuleType.WALK_TARGET, (Object)MemoryStatus.REGISTERED, (Object)MemoryModuleType.LOOK_TARGET, (Object)MemoryStatus.REGISTERED), 110);
        this.speedModifier = speed;
    }

    protected boolean checkExtraStartConditions(ServerLevel level, T animal) {
        if (level.getGameTime() > this.nextAttemptTime) {
            this.nextAttemptTime = level.getGameTime() + 200L;
            return ((BrainAnimalBehavior)animal).isMale() && this.findValidBreedPartner(animal).isPresent();
        }
        return false;
    }

    protected void start(ServerLevel level, T animal, long time) {
        AgeableMob target = this.findValidBreedPartner(animal).get();
        animal.getBrain().setMemory(MemoryModuleType.BREED_TARGET, (Object)target);
        target.getBrain().setMemory(MemoryModuleType.BREED_TARGET, animal);
        BehaviorUtils.lockGazeAndWalkToEachOther(animal, (LivingEntity)target, (float)this.speedModifier, (int)2);
        this.spawnChildAtTime = time + 60L + (long)animal.getRandom().nextInt(50);
    }

    protected boolean canStillUse(ServerLevel level, T animal, long time) {
        Animal targetAnimal;
        if (!this.hasValidBreedPartner(animal)) {
            return false;
        }
        AgeableMob target = (AgeableMob)animal.getBrain().getMemory(MemoryModuleType.BREED_TARGET).get();
        return target.isAlive() && target instanceof Animal && animal.canMate(targetAnimal = (Animal)target) && BehaviorUtils.entityIsVisible((Brain)animal.getBrain(), (LivingEntity)target) && time <= this.spawnChildAtTime;
    }

    protected void tick(ServerLevel level, T animal, long time) {
        AgeableMob target = (AgeableMob)animal.getBrain().getMemory(MemoryModuleType.BREED_TARGET).get();
        BehaviorUtils.lockGazeAndWalkToEachOther(animal, (LivingEntity)target, (float)this.speedModifier, (int)2);
        if (animal.closerThan((Entity)target, 3.0) && time >= this.spawnChildAtTime) {
            target.getBreedOffspring(level, animal);
            animal.getBrain().eraseMemory(MemoryModuleType.BREED_TARGET);
            target.getBrain().eraseMemory(MemoryModuleType.BREED_TARGET);
        }
    }

    protected void stop(ServerLevel level, T animal, long speed) {
        ((BrainAnimalBehavior)animal).setLastMatedNow();
        animal.getBrain().eraseMemory(MemoryModuleType.BREED_TARGET);
        animal.getBrain().eraseMemory(MemoryModuleType.WALK_TARGET);
        animal.getBrain().eraseMemory(MemoryModuleType.LOOK_TARGET);
        this.spawnChildAtTime = 0L;
    }

    private boolean hasValidBreedPartner(T animal) {
        Brain brain = animal.getBrain();
        if (brain.hasMemoryValue(MemoryModuleType.BREED_TARGET)) {
            BrainAnimalBehavior behavior;
            AgeableMob target = (AgeableMob)brain.getMemory(MemoryModuleType.BREED_TARGET).get();
            return animal.getType() == target.getType() && target instanceof BrainAnimalBehavior && !(behavior = (BrainAnimalBehavior)target).isMale();
        }
        return false;
    }

    private Optional<AgeableMob> findValidBreedPartner(T animal) {
        return ((NearestVisibleLivingEntities)animal.getBrain().getMemory(MemoryModuleType.NEAREST_VISIBLE_LIVING_ENTITIES).get()).findClosest(target -> {
            Animal targetAnimal;
            return target.getType() == animal.getType() && target instanceof Animal && animal.canMate(targetAnimal = (Animal)target);
        }).map(t -> (AgeableMob)t);
    }
}

