/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.entities.ai.livestock;

import com.google.common.collect.ImmutableSet;
import it.unimi.dsi.fastutil.longs.Long2LongMap;
import it.unimi.dsi.fastutil.longs.Long2LongOpenHashMap;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.dries007.tfc.common.entities.ai.TFCBrain;
import net.dries007.tfc.common.entities.livestock.OviparousAnimal;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.sensing.Sensor;
import net.minecraft.world.entity.ai.village.poi.PoiManager;
import net.minecraft.world.entity.ai.village.poi.PoiType;
import net.minecraft.world.level.pathfinder.Path;

public class NearestNestBoxSensor
extends Sensor<OviparousAnimal> {
    private static final int CACHE_TIMEOUT = 40;
    private static final int BATCH_SIZE = 5;
    private int triedCount;
    private long lastUpdate;
    private final Long2LongMap batchCache = new Long2LongOpenHashMap();

    protected void doTick(ServerLevel level, OviparousAnimal animal) {
        if (animal.isReadyForAnimalProduct() && !animal.isPassenger()) {
            this.triedCount = 0;
            this.lastUpdate = level.getGameTime() + (long)level.getRandom().nextInt(20);
            PoiManager manager = level.getPoiManager();
            Predicate<BlockPos> predicate = pos -> {
                long packed = pos.asLong();
                if (this.batchCache.containsKey(packed)) {
                    return false;
                }
                if (++this.triedCount >= 5) {
                    return false;
                }
                this.batchCache.putIfAbsent(packed, this.lastUpdate + 40L);
                return true;
            };
            Stream found = manager.findAll(p -> p.value() == TFCBrain.NEST_BOX_POI.get(), predicate, animal.blockPosition(), 48, PoiManager.Occupancy.ANY);
            Path path = animal.getNavigation().createPath(found, ((PoiType)TFCBrain.NEST_BOX_POI.get()).validRange());
            if (path != null && path.canReach()) {
                BlockPos target = path.getTarget();
                manager.getType(target).ifPresent(poi -> animal.getBrain().setMemory((MemoryModuleType)TFCBrain.NEST_BOX_MEMORY.get(), (Object)target));
            } else if (this.triedCount < 5) {
                this.batchCache.long2LongEntrySet().removeIf(set -> set.getLongValue() < this.lastUpdate);
            }
        }
    }

    public Set<MemoryModuleType<?>> requires() {
        return ImmutableSet.of((Object)((MemoryModuleType)TFCBrain.NEST_BOX_MEMORY.get()));
    }
}

