/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.entities.ai.pet;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import net.dries007.tfc.common.TFCTags;
import net.dries007.tfc.common.entities.ai.TFCBrain;
import net.dries007.tfc.util.Helpers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.Position;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.behavior.OneShot;
import net.minecraft.world.entity.ai.behavior.declarative.BehaviorBuilder;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.util.LandRandomPos;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.Vec3;

public class TamableFindSleepPos {
    public static OneShot<PathfinderMob> create() {
        return BehaviorBuilder.create(instance -> instance.group((App)instance.present(MemoryModuleType.HOME), (App)instance.absent(MemoryModuleType.AVOID_TARGET), (App)instance.registered(MemoryModuleType.WALK_TARGET), (App)instance.registered((MemoryModuleType)TFCBrain.SLEEP_POS.get())).apply((Applicative)instance, (home, avoid, walk, sleep) -> (level, entity, time) -> {
            Vec3 newPos;
            GlobalPos globalPos = instance.tryGet(sleep).orElse(GlobalPos.of((ResourceKey)level.dimension(), (BlockPos)entity.blockPosition()));
            BlockPos homePos = globalPos.pos();
            if (!(globalPos.dimension() == level.dimension() && TamableFindSleepPos.wantsToSitAt(level, homePos) || (newPos = LandRandomPos.getPos((PathfinderMob)entity, (int)12, (int)5, pos -> TamableFindSleepPos.wantsToSitAt(level, pos) ? (double)entity.getWalkTargetValue(pos) : -10.0)) == null)) {
                sleep.set((Object)GlobalPos.of((ResourceKey)level.dimension(), (BlockPos)BlockPos.containing((Position)newPos)));
                return true;
            }
            if (level.getBlockState(globalPos.pos()).getFluidState().isEmpty()) {
                sleep.set((Object)globalPos);
                return true;
            }
            return false;
        }));
    }

    private static boolean wantsToSitAt(ServerLevel level, BlockPos pos) {
        BlockState state = level.getBlockState(pos);
        return Helpers.isBlock(state, TFCTags.Blocks.PET_SITS_ON) && state.isPathfindable(PathComputationType.LAND) && level.getBlockState(pos.above()).isAir();
    }
}

