/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.entities.ai.predator;

import com.google.common.collect.ImmutableSet;
import java.util.List;
import java.util.Set;
import net.dries007.tfc.common.entities.ai.TFCBrain;
import net.dries007.tfc.common.entities.ai.predator.PackPredator;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.sensing.Sensor;
import net.minecraft.world.phys.AABB;

public class PackLeaderSensor
extends Sensor<PackPredator> {
    public PackLeaderSensor() {
        super(120);
    }

    public Set<MemoryModuleType<?>> requires() {
        return ImmutableSet.of((Object)MemoryModuleType.NEAREST_VISIBLE_ADULT, (Object)MemoryModuleType.NEAREST_VISIBLE_LIVING_ENTITIES);
    }

    protected void doTick(ServerLevel level, PackPredator predator) {
        AABB aabb = predator.getBoundingBox().inflate(32.0, 32.0, 32.0);
        List list = level.getEntitiesOfClass(LivingEntity.class, aabb, entity -> entity.isAlive() && !entity.equals((Object)predator) && entity.getType().equals(predator.getType()));
        this.setAlpha(predator, list);
    }

    private void setAlpha(PackPredator mob, List<LivingEntity> nearby) {
        int maxRespect = mob.getRespect();
        PackPredator alpha = mob;
        for (LivingEntity entity : nearby) {
            PackPredator predator;
            if (!(entity instanceof PackPredator) || (predator = (PackPredator)entity).isBaby()) continue;
            int respect = predator.getRespect();
            if (respect == maxRespect) {
                if (respect > 0) {
                    predator.addRespect(-1);
                } else {
                    predator.addRespect(1);
                }
            }
            if (respect <= maxRespect) continue;
            maxRespect = respect;
            alpha = predator;
        }
        mob.getBrain().setMemory((MemoryModuleType)TFCBrain.ALPHA.get(), (Object)alpha);
    }
}

