/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.entities.ai.prey;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.ToIntFunction;
import net.dries007.tfc.common.entities.ai.predator.PredatorAi;
import net.dries007.tfc.common.entities.ai.prey.RammingPreyAi;
import net.dries007.tfc.common.entities.prey.RammingPrey;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.behavior.EntityTracker;
import net.minecraft.world.entity.ai.behavior.PrepareRamNearestTarget;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.memory.WalkTarget;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;

public class PrepareRamNearestTargetTFC<E extends PathfinderMob>
extends Behavior<E> {
    private final ToIntFunction<E> getCooldownOnFail;
    private final float walkSpeed;
    private final int ramPrepareTime;
    private final Function<E, SoundEvent> getPrepareRamSound;
    private Optional<Long> reachedRamPositionTimestamp = Optional.empty();
    private Optional<PrepareRamNearestTarget.RamCandidate> ramCandidate = Optional.empty();

    public PrepareRamNearestTargetTFC(ToIntFunction<E> coolDownOnFail, float walkSpeed, int ramPrepareTime, Function<E, SoundEvent> prepareRamSound) {
        super((Map)ImmutableMap.of((Object)MemoryModuleType.LOOK_TARGET, (Object)MemoryStatus.REGISTERED, (Object)MemoryModuleType.RAM_COOLDOWN_TICKS, (Object)MemoryStatus.VALUE_ABSENT, (Object)MemoryModuleType.NEAREST_VISIBLE_LIVING_ENTITIES, (Object)MemoryStatus.VALUE_PRESENT, (Object)MemoryModuleType.RAM_TARGET, (Object)MemoryStatus.VALUE_ABSENT), 160);
        this.getCooldownOnFail = coolDownOnFail;
        this.walkSpeed = walkSpeed;
        this.ramPrepareTime = ramPrepareTime;
        this.getPrepareRamSound = prepareRamSound;
    }

    protected void start(ServerLevel level, PathfinderMob rammingPrey, long time) {
        Brain brain = rammingPrey.getBrain();
        TargetingConditions ramTargeting = ((RammingPrey)rammingPrey).isMale() && !rammingPrey.isBaby() ? RammingPreyAi.RAM_TARGET_CONDITIONS_ADULT_MALE : RammingPreyAi.RAM_TARGET_CONDITIONS;
        brain.getMemory(MemoryModuleType.NEAREST_VISIBLE_LIVING_ENTITIES).flatMap(nearestVisibleLivingEntities -> nearestVisibleLivingEntities.findClosest(nearestVisibleEntity -> ramTargeting.test((LivingEntity)rammingPrey, nearestVisibleEntity))).ifPresent(target -> this.chooseRamPosition(rammingPrey, (LivingEntity)target));
    }

    protected void stop(ServerLevel level, E rammingPrey, long time) {
        Brain brain = rammingPrey.getBrain();
        if (!brain.hasMemoryValue(MemoryModuleType.RAM_TARGET)) {
            level.broadcastEntityEvent(rammingPrey, (byte)59);
            brain.setMemory(MemoryModuleType.RAM_COOLDOWN_TICKS, (Object)this.getCooldownOnFail.applyAsInt(rammingPrey));
        }
    }

    protected boolean canStillUse(ServerLevel level, PathfinderMob rammingPrey, long time) {
        return this.ramCandidate.isPresent() && this.ramCandidate.get().getTarget().isAlive();
    }

    protected void tick(ServerLevel level, E rammingPrey, long time) {
        if (!this.ramCandidate.isEmpty()) {
            boolean flag;
            rammingPrey.getBrain().setMemory(MemoryModuleType.WALK_TARGET, (Object)new WalkTarget(this.ramCandidate.get().getStartPosition(), this.walkSpeed, 0));
            rammingPrey.getBrain().setMemory(MemoryModuleType.LOOK_TARGET, (Object)new EntityTracker((Entity)this.ramCandidate.get().getTarget(), true));
            boolean bl = flag = !this.ramCandidate.get().getTarget().blockPosition().equals((Object)this.ramCandidate.get().getTargetPosition());
            if (flag) {
                if (PredatorAi.hasNearbyAttacker(rammingPrey)) {
                    level.broadcastEntityEvent(rammingPrey, (byte)58);
                } else {
                    level.broadcastEntityEvent(rammingPrey, (byte)59);
                }
                rammingPrey.getNavigation().stop();
                this.chooseRamPosition((PathfinderMob)rammingPrey, this.ramCandidate.get().getTarget());
            } else {
                BlockPos blockpos = rammingPrey.blockPosition();
                if (blockpos.equals((Object)this.ramCandidate.get().getStartPosition())) {
                    level.broadcastEntityEvent(rammingPrey, (byte)58);
                    if (this.reachedRamPositionTimestamp.isEmpty()) {
                        this.reachedRamPositionTimestamp = Optional.of(time);
                    }
                    if (time - this.reachedRamPositionTimestamp.get() >= (long)this.ramPrepareTime) {
                        if (rammingPrey instanceof RammingPrey) {
                            ((RammingPrey)rammingPrey).setAttackDamageMultiplier(this.calcRamDamageMultiplier(blockpos, this.ramCandidate.get().getTargetPosition()));
                        }
                        rammingPrey.getBrain().setMemory(MemoryModuleType.RAM_TARGET, (Object)this.getEdgeOfBlock(blockpos, this.ramCandidate.get().getTargetPosition()));
                        level.playSound((Player)null, rammingPrey, this.getPrepareRamSound.apply(rammingPrey), SoundSource.NEUTRAL, 1.0f, rammingPrey.getVoicePitch());
                        this.ramCandidate = Optional.empty();
                        this.reachedRamPositionTimestamp = Optional.empty();
                    }
                }
            }
        }
    }

    private float calcRamDamageMultiplier(BlockPos startPos, BlockPos finishPos) {
        float dist = (float)startPos.distSqr((Vec3i)finishPos);
        int maxRamDistance = 9;
        return Mth.clamp((float)(1.2f * dist / 9.0f), (float)0.25f, (float)2.0f);
    }

    private Vec3 getEdgeOfBlock(BlockPos pos1, BlockPos pos2) {
        double d0 = 0.5;
        double d1 = 0.5 * (double)Mth.sign((double)(pos2.getX() - pos1.getX()));
        double d2 = 0.5 * (double)Mth.sign((double)(pos2.getZ() - pos1.getZ()));
        return Vec3.atBottomCenterOf((Vec3i)pos2).add(d1, 0.0, d2);
    }

    private void chooseRamPosition(PathfinderMob rammingPrey, LivingEntity target) {
        this.ramCandidate = Optional.of(new PrepareRamNearestTarget.RamCandidate(rammingPrey.blockPosition(), target.blockPosition(), target));
    }
}

