/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.entities.ai.prey;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.dries007.tfc.common.entities.ai.SetLookTarget;
import net.dries007.tfc.common.entities.ai.prey.AvoidPredatorAndRammersBehavior;
import net.dries007.tfc.common.entities.prey.Prey;
import net.minecraft.util.TimeUtil;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.behavior.AnimalPanic;
import net.minecraft.world.entity.ai.behavior.BabyFollowAdult;
import net.minecraft.world.entity.ai.behavior.BehaviorUtils;
import net.minecraft.world.entity.ai.behavior.DoNothing;
import net.minecraft.world.entity.ai.behavior.EraseMemoryIf;
import net.minecraft.world.entity.ai.behavior.LookAtTargetSink;
import net.minecraft.world.entity.ai.behavior.MoveToTargetSink;
import net.minecraft.world.entity.ai.behavior.RandomStroll;
import net.minecraft.world.entity.ai.behavior.RunOne;
import net.minecraft.world.entity.ai.behavior.SetWalkTargetAwayFrom;
import net.minecraft.world.entity.ai.behavior.SetWalkTargetFromLookTarget;
import net.minecraft.world.entity.ai.behavior.Swim;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.sensing.Sensor;
import net.minecraft.world.entity.ai.sensing.SensorType;
import net.minecraft.world.entity.schedule.Activity;

public class PreyAi {
    public static final int AVOID_RANGE = 400;
    private static final UniformInt RETREAT_DURATION = TimeUtil.rangeOfSeconds((int)7, (int)22);
    public static final ImmutableList<SensorType<? extends Sensor<? super Prey>>> SENSOR_TYPES = ImmutableList.of((Object)SensorType.NEAREST_LIVING_ENTITIES, (Object)SensorType.NEAREST_PLAYERS, (Object)SensorType.HURT_BY);
    public static final ImmutableList<MemoryModuleType<?>> MEMORY_TYPES = ImmutableList.of((Object)MemoryModuleType.LOOK_TARGET, (Object)MemoryModuleType.NEAREST_VISIBLE_LIVING_ENTITIES, (Object)MemoryModuleType.NEAREST_LIVING_ENTITIES, (Object)MemoryModuleType.WALK_TARGET, (Object)MemoryModuleType.CANT_REACH_WALK_TARGET_SINCE, (Object)MemoryModuleType.PATH, (Object)MemoryModuleType.AVOID_TARGET, (Object)MemoryModuleType.NEAREST_VISIBLE_ADULT);

    public static Brain<?> makeBrain(Brain<? extends Prey> brain) {
        PreyAi.initCoreActivity(brain);
        PreyAi.initIdleActivity(brain);
        PreyAi.initRetreatActivity(brain);
        brain.setCoreActivities((Set)ImmutableSet.of((Object)Activity.CORE));
        brain.setDefaultActivity(Activity.IDLE);
        brain.useDefaultActivity();
        return brain;
    }

    public static void initCoreActivity(Brain<? extends Prey> brain) {
        brain.addActivity(Activity.CORE, 0, ImmutableList.of((Object)new Swim(0.7f), (Object)new AnimalPanic(2.0f), (Object)new LookAtTargetSink(45, 90), (Object)new MoveToTargetSink()));
    }

    public static void initIdleActivity(Brain<? extends Prey> brain) {
        brain.addActivity(Activity.IDLE, ImmutableList.of((Object)Pair.of((Object)0, SetLookTarget.create(EntityType.PLAYER, 6.0f, UniformInt.of((int)30, (int)60))), (Object)Pair.of((Object)1, AvoidPredatorAndRammersBehavior.create(false)), (Object)Pair.of((Object)2, (Object)BabyFollowAdult.create((UniformInt)UniformInt.of((int)5, (int)16), (float)1.25f)), (Object)Pair.of((Object)3, PreyAi.createIdleMovementBehaviors())));
    }

    public static void initRetreatActivity(Brain<? extends Prey> brain) {
        brain.addActivityAndRemoveMemoryWhenStopped(Activity.AVOID, 10, ImmutableList.of((Object)SetWalkTargetAwayFrom.entity((MemoryModuleType)MemoryModuleType.AVOID_TARGET, (float)1.1f, (int)15, (boolean)false), PreyAi.createIdleMovementBehaviors(), SetLookTarget.create(8.0f, UniformInt.of((int)30, (int)60)), (Object)EraseMemoryIf.create(PreyAi::wantsToStopFleeing, (MemoryModuleType)MemoryModuleType.AVOID_TARGET)), MemoryModuleType.AVOID_TARGET);
    }

    public static RunOne<Prey> createIdleMovementBehaviors() {
        return new RunOne((Map)ImmutableMap.of((Object)MemoryModuleType.WALK_TARGET, (Object)MemoryStatus.VALUE_ABSENT), (List)ImmutableList.of((Object)Pair.of((Object)RandomStroll.stroll((float)1.0f), (Object)1), (Object)Pair.of((Object)SetWalkTargetFromLookTarget.create((float)1.0f, (int)3), (Object)1), (Object)Pair.of((Object)new DoNothing(30, 60), (Object)1)));
    }

    public static void updateActivity(Prey prey) {
        prey.getBrain().setActiveActivityToFirstValid((List)ImmutableList.of((Object)Activity.AVOID, (Object)Activity.IDLE));
    }

    public static Optional<LivingEntity> getAvoidTarget(LivingEntity prey) {
        return prey.getBrain().hasMemoryValue(MemoryModuleType.AVOID_TARGET) ? prey.getBrain().getMemory(MemoryModuleType.AVOID_TARGET) : Optional.empty();
    }

    public static void wasHurtBy(LivingEntity prey, LivingEntity attacker) {
        Brain brain = prey.getBrain();
        PreyAi.getAvoidTarget(prey).ifPresent(avoid -> {
            if (avoid.getType() != attacker.getType()) {
                brain.eraseMemory(MemoryModuleType.AVOID_TARGET);
                brain.setMemoryWithExpiry(MemoryModuleType.AVOID_TARGET, (Object)attacker, (long)RETREAT_DURATION.sample(prey.getRandom()));
                PreyAi.broadcastAvoidTarget(prey, attacker);
            }
        });
    }

    public static void broadcastAvoidTarget(LivingEntity prey, LivingEntity attacker) {
        Brain brain = prey.getBrain();
        brain.getMemory(MemoryModuleType.NEAREST_VISIBLE_LIVING_ENTITIES).ifPresent(entities -> entities.findAll(e -> e.getType() == prey.getType()).forEach(friend -> {
            LivingEntity closest = BehaviorUtils.getNearestTarget((LivingEntity)friend, (Optional)friend.getBrain().getMemory(MemoryModuleType.AVOID_TARGET), (LivingEntity)attacker);
            PreyAi.setAvoidTarget(friend, closest);
        }));
    }

    public static void setAvoidTarget(LivingEntity prey, LivingEntity attacker) {
        Brain brain = prey.getBrain();
        brain.eraseMemory(MemoryModuleType.WALK_TARGET);
        brain.eraseMemory(MemoryModuleType.LOOK_TARGET);
        brain.setMemoryWithExpiry(MemoryModuleType.AVOID_TARGET, (Object)attacker, (long)RETREAT_DURATION.sample(prey.getRandom()));
    }

    public static boolean wantsToStopFleeing(LivingEntity prey) {
        Brain brain = prey.getBrain();
        return !brain.hasMemoryValue(MemoryModuleType.AVOID_TARGET) || ((LivingEntity)brain.getMemory(MemoryModuleType.AVOID_TARGET).get()).distanceToSqr((Entity)prey) > 400.0;
    }
}

