/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.entities.ai.prey;

import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.ToDoubleFunction;
import net.dries007.tfc.common.entities.ai.prey.RammingPreyAi;
import net.dries007.tfc.common.entities.prey.RammingPrey;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.memory.WalkTarget;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;

public class RamTargetTFC
extends Behavior<RammingPrey> {
    public static final int TIME_OUT_DURATION = 200;
    public static final float RAM_SPEED_FORCE_FACTOR = 1.65f;
    private final Function<RammingPrey, UniformInt> getTimeBetweenRams;
    private final float speed;
    private final ToDoubleFunction<RammingPrey> getKnockbackForce;
    private Vec3 ramDirection;
    private final Function<RammingPrey, SoundEvent> getImpactSound;

    public RamTargetTFC(Function<RammingPrey, UniformInt> getTimeBetweenRams, float speed, ToDoubleFunction<RammingPrey> getKnockbackForce, Function<RammingPrey, SoundEvent> getImpactSound) {
        super((Map)ImmutableMap.of((Object)MemoryModuleType.RAM_COOLDOWN_TICKS, (Object)MemoryStatus.VALUE_ABSENT, (Object)MemoryModuleType.RAM_TARGET, (Object)MemoryStatus.VALUE_PRESENT), 200);
        this.getTimeBetweenRams = getTimeBetweenRams;
        this.speed = speed;
        this.getKnockbackForce = getKnockbackForce;
        this.getImpactSound = getImpactSound;
        this.ramDirection = Vec3.ZERO;
    }

    protected boolean checkExtraStartConditions(ServerLevel level, RammingPrey rammingPrey) {
        return rammingPrey.getBrain().hasMemoryValue(MemoryModuleType.RAM_TARGET);
    }

    protected boolean canStillUse(ServerLevel level, RammingPrey rammingPrey, long time) {
        return rammingPrey.getBrain().hasMemoryValue(MemoryModuleType.RAM_TARGET);
    }

    protected void start(ServerLevel level, RammingPrey rammingPrey, long time) {
        BlockPos blockpos = rammingPrey.blockPosition();
        Brain<RammingPrey> brain = rammingPrey.getBrain();
        Vec3 ramTargetVector = (Vec3)brain.getMemory(MemoryModuleType.RAM_TARGET).get();
        this.ramDirection = new Vec3((double)blockpos.getX() - ramTargetVector.x(), 0.0, (double)blockpos.getZ() - ramTargetVector.z()).normalize();
        brain.setMemory(MemoryModuleType.WALK_TARGET, (Object)new WalkTarget(ramTargetVector, this.speed, 0));
    }

    protected void tick(ServerLevel level, RammingPrey rammingPrey, long time) {
        Brain<RammingPrey> brain = rammingPrey.getBrain();
        TargetingConditions ramTargeting = rammingPrey.isMale() && !rammingPrey.isBaby() ? RammingPreyAi.RAM_TARGET_CONDITIONS_ADULT_MALE : RammingPreyAi.RAM_TARGET_CONDITIONS;
        List list = level.getNearbyEntities(LivingEntity.class, ramTargeting, (LivingEntity)rammingPrey, rammingPrey.getBoundingBox().inflate(rammingPrey.getRammingReach()));
        if (!list.isEmpty()) {
            LivingEntity livingentity = (LivingEntity)list.get(0);
            livingentity.hurt(level.damageSources().noAggroMobAttack((LivingEntity)rammingPrey), (float)rammingPrey.getAttributeValue(Attributes.ATTACK_DAMAGE) * rammingPrey.getAttackDamageMultiplier());
            int i = rammingPrey.hasEffect(MobEffects.MOVEMENT_SPEED) ? rammingPrey.getEffect(MobEffects.MOVEMENT_SPEED).getAmplifier() + 1 : 0;
            int j = rammingPrey.hasEffect(MobEffects.MOVEMENT_SLOWDOWN) ? rammingPrey.getEffect(MobEffects.MOVEMENT_SLOWDOWN).getAmplifier() + 1 : 0;
            float f = 0.25f * (float)(i - j);
            float f1 = Mth.clamp((float)(rammingPrey.getSpeed() * 1.65f), (float)0.2f, (float)3.0f) + f;
            float f2 = livingentity.isDamageSourceBlocked(level.damageSources().mobAttack((LivingEntity)rammingPrey)) ? 0.5f : 1.0f;
            float f3 = rammingPrey.getAttackDamageMultiplier() * 0.6f;
            livingentity.knockback((double)(f1 * f2 * f3) * this.getKnockbackForce.applyAsDouble(rammingPrey), this.ramDirection.x(), this.ramDirection.z());
            this.finishRam(level, rammingPrey);
            level.playSound((Player)null, (Entity)rammingPrey, this.getImpactSound.apply(rammingPrey), SoundSource.NEUTRAL, 1.0f, 1.0f);
        } else {
            boolean flag1;
            Optional optionalWalkTarget = brain.getMemory(MemoryModuleType.WALK_TARGET);
            Optional optionalRamTarget = brain.getMemory(MemoryModuleType.RAM_TARGET);
            boolean bl = flag1 = optionalWalkTarget.isEmpty() || optionalRamTarget.isEmpty() || ((WalkTarget)optionalWalkTarget.get()).getTarget().currentPosition().closerThan((Position)optionalRamTarget.get(), 0.25);
            if (flag1) {
                this.finishRam(level, rammingPrey);
            }
        }
    }

    protected void finishRam(ServerLevel serverLevel, RammingPrey rammingPrey) {
        serverLevel.broadcastEntityEvent((Entity)rammingPrey, (byte)59);
        rammingPrey.getBrain().setMemory(MemoryModuleType.RAM_COOLDOWN_TICKS, (Object)this.getTimeBetweenRams.apply(rammingPrey).sample(serverLevel.random));
        rammingPrey.getBrain().eraseMemory(MemoryModuleType.RAM_TARGET);
    }
}

