/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.entities.aquatic;

import com.mojang.serialization.Dynamic;
import java.util.Optional;
import net.dries007.tfc.client.TFCSounds;
import net.dries007.tfc.common.component.food.FoodCapability;
import net.dries007.tfc.common.entities.Temptable;
import net.dries007.tfc.common.entities.ai.amphibian.AmphibianAi;
import net.dries007.tfc.common.entities.aquatic.TrueAmphibiousMoveControl;
import net.dries007.tfc.common.entities.prey.WildAnimal;
import net.dries007.tfc.util.Helpers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.SmoothSwimmingLookControl;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.navigation.WaterBoundPathNavigation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.pathfinder.AmphibiousNodeEvaluator;
import net.minecraft.world.level.pathfinder.PathFinder;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.fluids.FluidType;
import org.jetbrains.annotations.Nullable;

public abstract class AmphibiousAnimal
extends WildAnimal
implements Temptable {
    public static final int PLAY_DEAD_TIME = 200;
    private static final EntityDataAccessor<Boolean> DATA_PLAYING_DEAD = SynchedEntityData.defineId(AmphibiousAnimal.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.createMobAttributes().add(Attributes.MAX_HEALTH, 14.0).add(Attributes.MOVEMENT_SPEED, 1.0).add(Attributes.ATTACK_DAMAGE, 2.0).add(Attributes.STEP_HEIGHT, 1.0);
    }

    public AmphibiousAnimal(EntityType<? extends AmphibiousAnimal> type, Level level, TFCSounds.EntityId sound) {
        super(type, level, sound);
        this.setPathfindingMalus(PathType.WALKABLE, 0.0f);
        this.setPathfindingMalus(PathType.WATER, 0.0f);
        this.moveControl = new AmphibianMoveControl(this);
        this.lookControl = new SmoothSwimmingLookControl((Mob)this, 20);
    }

    public boolean isPlayingDeadEffective() {
        return true;
    }

    public void playAmbientSound() {
        if (!this.isPlayingDead()) {
            super.playAmbientSound();
        }
    }

    @Override
    public float getWalkTargetValue(BlockPos pos, LevelReader level) {
        return 0.0f;
    }

    protected Brain.Provider<? extends AmphibiousAnimal> brainProvider() {
        return Brain.provider(AmphibianAi.MEMORY_TYPES, AmphibianAi.SENSOR_TYPES);
    }

    protected Brain<?> makeBrain(Dynamic<?> dynamic) {
        return AmphibianAi.makeBrain((Brain<? extends AmphibiousAnimal>)this.brainProvider().makeBrain(dynamic));
    }

    protected void customServerAiStep() {
        this.getBrain().tick((ServerLevel)this.level(), (LivingEntity)this);
        AmphibianAi.updateActivity(this);
        if (!this.isNoAi() && !this.isInWaterOrBubble()) {
            Optional optionalTicks = this.getBrain().getMemory(MemoryModuleType.PLAY_DEAD_TICKS);
            this.setPlayingDead(optionalTicks.isPresent() && (Integer)optionalTicks.get() > 0);
        }
    }

    public boolean hurt(DamageSource source, float amount) {
        boolean hurt = super.hurt(source, amount);
        if (!this.level().isClientSide && this.getHealth() > 0.0f && amount > 0.5f && !this.isPlayingDead()) {
            this.brain.setMemory(MemoryModuleType.PLAY_DEAD_TICKS, (Object)200);
        }
        return hurt;
    }

    @Override
    @Nullable
    public SpawnGroupData finalizeSpawn(ServerLevelAccessor level, DifficultyInstance difficulty, MobSpawnType spawnType, @Nullable SpawnGroupData spawnData) {
        this.getBrain().setMemory(MemoryModuleType.HOME, (Object)GlobalPos.of((ResourceKey)level.getLevel().dimension(), (BlockPos)this.blockPosition()));
        return super.finalizeSpawn(level, difficulty, spawnType, spawnData);
    }

    public Brain<AmphibiousAnimal> getBrain() {
        return super.getBrain();
    }

    public boolean canDrownInFluidType(FluidType type) {
        return !this.canSwimInFluidType(type);
    }

    public void travel(Vec3 movement) {
        if (this.isPlayingDead()) {
            movement = new Vec3(0.0, movement.y < 0.0 ? movement.y : 0.0, 0.0);
        }
        if (this.isEffectiveAi() && this.isInWater()) {
            this.moveRelative(this.getSpeed(), movement);
            this.move(MoverType.SELF, this.getDeltaMovement());
            this.setDeltaMovement(this.getDeltaMovement().scale(0.9));
        } else {
            super.travel(movement);
        }
    }

    public boolean isPushedByFluid(FluidType type) {
        return false;
    }

    @Override
    public boolean canBeLeashed() {
        return true;
    }

    @Override
    protected PathNavigation createNavigation(Level level) {
        return new AmphibianNavigation(this, level);
    }

    @Override
    public void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(DATA_PLAYING_DEAD, (Object)false);
    }

    protected InteractionResult mobInteract(Player player, InteractionHand hand) {
        ItemStack held = player.getItemInHand(hand);
        if (this.isFood(held) && !FoodCapability.isRotten(held) && this.getHealth() < this.getMaxHealth()) {
            this.heal(1.0f);
            held.shrink(1);
            return InteractionResult.sidedSuccess((boolean)this.level().isClientSide);
        }
        return super.mobInteract(player, hand);
    }

    public boolean doHurtTarget(Entity entity) {
        boolean hurt = super.doHurtTarget(entity);
        if (!entity.isAlive()) {
            this.getBrain().setMemoryWithExpiry(MemoryModuleType.HUNTED_RECENTLY, (Object)true, 1000L);
        }
        return hurt;
    }

    public float getWalkTargetValue(BlockPos pos) {
        return Helpers.isBlock(this.level().getBlockState(pos.below()), (TagKey<Block>)BlockTags.SAND) ? 10.0f : super.getWalkTargetValue(pos);
    }

    public boolean isPlayingDead() {
        return (Boolean)this.entityData.get(DATA_PLAYING_DEAD);
    }

    public void setPlayingDead(boolean dead) {
        this.entityData.set(DATA_PLAYING_DEAD, (Object)dead);
    }

    public class AmphibianMoveControl
    extends TrueAmphibiousMoveControl {
        public AmphibianMoveControl(AmphibiousAnimal animal) {
            super((Mob)animal, 85, 10, 0.1f, 0.5f, false);
        }

        @Override
        public void tick() {
            if (!AmphibiousAnimal.this.isPlayingDead()) {
                super.tick();
            }
        }
    }

    public static class AmphibianNavigation
    extends WaterBoundPathNavigation {
        AmphibianNavigation(AmphibiousAnimal animal, Level level) {
            super((Mob)animal, level);
        }

        protected PathFinder createPathFinder(int distance) {
            this.nodeEvaluator = new AmphibiousNodeEvaluator(false);
            return new PathFinder(this.nodeEvaluator, distance);
        }

        protected boolean canUpdatePath() {
            return true;
        }

        public boolean isStableDestination(BlockPos pos) {
            return !this.level.getBlockState(pos.below()).isAir();
        }
    }
}

