/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.entities.aquatic;

import java.util.function.Predicate;
import net.dries007.tfc.common.TFCTags;
import net.dries007.tfc.common.entities.EntityHelpers;
import net.dries007.tfc.common.entities.ai.TFCAvoidEntityGoal;
import net.dries007.tfc.common.entities.aquatic.AquaticMob;
import net.dries007.tfc.common.fluids.TFCFluids;
import net.dries007.tfc.util.Helpers;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.RandomSwimmingGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.navigation.WaterBoundPathNavigation;
import net.minecraft.world.entity.animal.WaterAnimal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;

public class AquaticCritter
extends WaterAnimal
implements AquaticMob {
    public final AnimationState idleAnimation = new AnimationState();
    public final AnimationState hurtAnimation = new AnimationState();
    private final Predicate<Fluid> fluidTest;

    public static AquaticCritter salty(EntityType<? extends WaterAnimal> type, Level level) {
        return new AquaticCritter(type, level, true);
    }

    public static AquaticCritter fresh(EntityType<? extends WaterAnimal> type, Level level) {
        return new AquaticCritter(type, level, false);
    }

    public AquaticCritter(EntityType<? extends WaterAnimal> type, Level level, boolean salty) {
        super(type, level);
        this.fluidTest = salty ? f -> f.isSame((Fluid)TFCFluids.SALT_WATER.getSource()) : f -> f.isSame((Fluid)Fluids.WATER);
    }

    public void tick() {
        if (this.level().isClientSide) {
            EntityHelpers.startOrStop(this.idleAnimation, this.getDeltaMovement().lengthSqr() < 1.0E-6, this.tickCount);
            EntityHelpers.startOrStop(this.hurtAnimation, this.hurtTime > 0, this.tickCount);
        }
        super.tick();
    }

    public void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(1, new CritterEscapeGoal<Player>((PathfinderMob)this, Player.class, 8.0f, 2.0, 2.0));
        this.goalSelector.addGoal(2, (Goal)new AvoidEntityGoal((PathfinderMob)this, WaterAnimal.class, 8.0f, 5.0, (double)5.4f, e -> Helpers.isEntity((Entity)e, TFCTags.Entities.OCEAN_PREDATORS)));
        this.goalSelector.addGoal(3, (Goal)new RandomSwimmingGoal((PathfinderMob)this, 1.0, 30));
    }

    @Override
    public boolean canSpawnIn(Fluid fluid) {
        return this.fluidTest.test(fluid);
    }

    protected PathNavigation createNavigation(Level pLevel) {
        return new WaterBoundPathNavigation((Mob)this, pLevel);
    }

    static class CritterEscapeGoal<T extends LivingEntity>
    extends TFCAvoidEntityGoal<T> {
        public CritterEscapeGoal(PathfinderMob mob, Class<T> avoidClass, float maxDist, double walkSpeedModifier, double sprintSpeedModifier) {
            super(mob, avoidClass, maxDist, walkSpeedModifier, sprintSpeedModifier);
        }

        public boolean shouldEscape() {
            return this.mob.getLastHurtByMob() != null;
        }

        @Override
        public boolean canUse() {
            return this.shouldEscape() && super.canUse();
        }

        @Override
        public boolean canContinueToUse() {
            return this.toAvoid != null && (!this.pathNav.isDone() || this.mob.distanceToSqr((Entity)this.toAvoid) > 49.0);
        }
    }
}

