/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.entities.aquatic;

import com.mojang.serialization.Dynamic;
import net.dries007.tfc.client.TFCSounds;
import net.dries007.tfc.common.TFCTags;
import net.dries007.tfc.common.entities.ai.amphibian.PinnipedAI;
import net.dries007.tfc.common.entities.aquatic.AmphibiousAnimal;
import net.dries007.tfc.util.Helpers;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class LeopardSeal
extends AmphibiousAnimal {
    public static AttributeSupplier.Builder createAttributes() {
        return Mob.createMobAttributes().add(Attributes.MAX_HEALTH, 24.0).add(Attributes.MOVEMENT_SPEED, 1.0).add(Attributes.ATTACK_DAMAGE, 6.0).add(Attributes.STEP_HEIGHT, 1.0);
    }

    public LeopardSeal(EntityType<? extends AmphibiousAnimal> type, Level level) {
        super(type, level, TFCSounds.SEAL);
    }

    @Override
    public boolean isPlayingDeadEffective() {
        return false;
    }

    @Override
    public boolean isFood(ItemStack stack) {
        return Helpers.isItem(stack, TFCTags.Items.SEAL_FOOD);
    }

    protected SoundEvent getAmbientSound() {
        return (SoundEvent)this.ambient.get();
    }

    @Override
    public void playAmbientSound() {
        if (!this.isInWaterOrBubble()) {
            super.playAmbientSound();
        }
    }

    @Override
    protected Brain.Provider<? extends AmphibiousAnimal> brainProvider() {
        return Brain.provider(PinnipedAI.MEMORY_TYPES, PinnipedAI.SENSOR_TYPES);
    }

    @Override
    protected Brain<?> makeBrain(Dynamic<?> dynamic) {
        return PinnipedAI.makeBrain((Brain<? extends AmphibiousAnimal>)this.brainProvider().makeBrain(dynamic));
    }

    @Override
    protected void customServerAiStep() {
        this.getBrain().tick((ServerLevel)this.level(), (LivingEntity)this);
        PinnipedAI.updateActivity(this);
    }

    @Override
    public boolean hurt(DamageSource source, float amount) {
        return super.hurt(source, amount);
    }
}

