/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.entities.aquatic;

import net.dries007.tfc.client.TFCSounds;
import net.dries007.tfc.common.TFCTags;
import net.dries007.tfc.common.entities.ai.TFCAvoidEntityGoal;
import net.dries007.tfc.common.entities.aquatic.AquaticMob;
import net.dries007.tfc.util.Helpers;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.SmoothSwimmingLookControl;
import net.minecraft.world.entity.ai.control.SmoothSwimmingMoveControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomSwimmingGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.navigation.WaterBoundPathNavigation;
import net.minecraft.world.entity.animal.AbstractFish;
import net.minecraft.world.entity.animal.WaterAnimal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import org.jetbrains.annotations.Nullable;

public class Manatee
extends WaterAnimal
implements AquaticMob {
    public static AttributeSupplier.Builder createAttributes() {
        return AbstractFish.createAttributes().add(Attributes.MOVEMENT_SPEED, 0.4).add(Attributes.MAX_HEALTH, 20.0);
    }

    public Manatee(EntityType<? extends WaterAnimal> type, Level level) {
        super(type, level);
        this.moveControl = new SmoothSwimmingMoveControl((Mob)this, 85, 10, 0.1f, 0.5f, true);
        this.lookControl = new SmoothSwimmingLookControl((Mob)this, 10);
    }

    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(0, (Goal)new PanicGoal((PathfinderMob)this, (double)1.2f));
        this.goalSelector.addGoal(2, new TFCAvoidEntityGoal<Player>((PathfinderMob)this, Player.class, 8.0f, 5.0, 5.4));
        this.goalSelector.addGoal(4, (Goal)new RandomSwimmingGoal((PathfinderMob)this, 1.0, 40));
    }

    protected PathNavigation createNavigation(Level level) {
        return new WaterBoundPathNavigation((Mob)this, level);
    }

    @Override
    public boolean canSpawnIn(Fluid fluid) {
        return fluid.isSame((Fluid)Fluids.WATER);
    }

    public void aiStep() {
        if (!this.isInWater() && this.onGround() && this.verticalCollision) {
            this.setDeltaMovement(this.getDeltaMovement().add((double)((this.random.nextFloat() * 2.0f - 1.0f) * 0.05f), (double)0.4f, (double)((this.random.nextFloat() * 2.0f - 1.0f) * 0.05f)));
            this.setOnGround(false);
            this.hasImpulse = true;
            this.playSound(this.getFlopSound(), this.getSoundVolume(), this.getVoicePitch());
        }
        super.aiStep();
    }

    public float getVoicePitch() {
        return super.getVoicePitch() * 0.5f;
    }

    protected SoundEvent getFlopSound() {
        return TFCSounds.MANATEE.flop().get();
    }

    @Nullable
    protected SoundEvent getAmbientSound() {
        return TFCSounds.MANATEE.ambient().get();
    }

    protected SoundEvent getDeathSound() {
        return TFCSounds.MANATEE.death().get();
    }

    protected SoundEvent getHurtSound(DamageSource source) {
        return TFCSounds.MANATEE.hurt().get();
    }

    protected float getBlockSpeedFactor() {
        return Helpers.isBlock(this.level().getBlockState(this.blockPosition()), TFCTags.Blocks.ANIMAL_IGNORED_PLANTS) ? 1.0f : super.getBlockSpeedFactor();
    }
}

