/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.entities.aquatic;

import com.mojang.datafixers.util.Pair;
import net.dries007.tfc.common.effect.TFCEffects;
import net.dries007.tfc.common.entities.IGlow;
import net.dries007.tfc.common.entities.aquatic.TFCSquid;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.portal.DimensionTransition;
import org.jetbrains.annotations.Nullable;

public class Octopoteuthis
extends TFCSquid
implements IGlow {
    private static final EntityDataAccessor<Integer> DATA_DARK_TICKS_REMAINING = SynchedEntityData.defineId(Octopoteuthis.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<BlockPos> DATA_LIGHT_POS = SynchedEntityData.defineId(Octopoteuthis.class, (EntityDataSerializer)EntityDataSerializers.BLOCK_POS);

    public Octopoteuthis(EntityType<? extends Octopoteuthis> type, Level level) {
        super(type, level);
    }

    protected ParticleOptions getInkParticle() {
        return ParticleTypes.GLOW_SQUID_INK;
    }

    public void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(DATA_DARK_TICKS_REMAINING, (Object)0);
        builder.define(DATA_LIGHT_POS, (Object)BlockPos.ZERO);
    }

    public SoundEvent getSquirtSound() {
        return SoundEvents.GLOW_SQUID_SQUIRT;
    }

    public SoundEvent getAmbientSound() {
        return SoundEvents.GLOW_SQUID_AMBIENT;
    }

    public SoundEvent getHurtSound(DamageSource source) {
        return SoundEvents.GLOW_SQUID_HURT;
    }

    public SoundEvent getDeathSound() {
        return SoundEvents.GLOW_SQUID_DEATH;
    }

    public void addAdditionalSaveData(CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        tag.putInt("DarkTicksRemaining", this.getDarkTicksRemaining());
        this.saveLight(tag);
    }

    public void readAdditionalSaveData(CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        this.setDarkTicks(tag.getInt("DarkTicksRemaining"));
        this.readLight(tag);
    }

    @Override
    public void tickGlow() {
        super.tick();
        IGlow.super.tickGlow();
    }

    @Override
    public int getLightLevel() {
        return (int)Mth.clamp((float)((float)this.getSize() * 0.234375f), (float)1.0f, (float)15.0f);
    }

    public void aiStep() {
        super.aiStep();
        int ticks = this.getDarkTicksRemaining();
        if (ticks > 0) {
            this.setDarkTicks(ticks - 1);
        }
        this.level().addParticle((ParticleOptions)ParticleTypes.GLOW, this.getRandomX(0.6), this.getRandomY(), this.getRandomZ(0.6), 0.0, 0.0, 0.0);
    }

    public void remove(Entity.RemovalReason reason) {
        this.tryRemoveLight();
        super.remove(reason);
    }

    @Nullable
    public Entity changeDimension(DimensionTransition transition) {
        this.tryRemoveLight();
        return super.changeDimension(transition);
    }

    @Override
    public boolean hurt(DamageSource source, float amount) {
        boolean hurt = super.hurt(source, amount);
        if (hurt) {
            this.setDarkTicks(100);
        }
        return hurt;
    }

    @Override
    public Holder<MobEffect> getInkEffect() {
        return TFCEffects.GLOW_INK.holder();
    }

    @Override
    public Pair<Integer, Integer> getSizeRangeForSpawning() {
        return Pair.of((Object)22, (Object)100);
    }

    private void setDarkTicks(int ticks) {
        this.entityData.set(DATA_DARK_TICKS_REMAINING, (Object)ticks);
    }

    public int getDarkTicksRemaining() {
        return (Integer)this.entityData.get(DATA_DARK_TICKS_REMAINING);
    }

    @Override
    public void setLightPos(BlockPos pos) {
        this.entityData.set(DATA_LIGHT_POS, (Object)pos);
    }

    @Override
    public BlockPos getLightPos() {
        return (BlockPos)this.entityData.get(DATA_LIGHT_POS);
    }
}

