/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.entities.aquatic;

import net.dries007.tfc.client.TFCSounds;
import net.dries007.tfc.common.TFCTags;
import net.dries007.tfc.common.entities.EntityHelpers;
import net.dries007.tfc.common.entities.aquatic.AmphibiousAnimal;
import net.dries007.tfc.util.Helpers;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class Penguin
extends AmphibiousAnimal {
    public final AnimationState walkingAnimation = new AnimationState();
    public final AnimationState swimmingAnimation = new AnimationState();

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.createMobAttributes().add(Attributes.MAX_HEALTH, 8.0).add(Attributes.MOVEMENT_SPEED, 1.0).add(Attributes.ATTACK_DAMAGE, 2.0).add(Attributes.STEP_HEIGHT, 1.0);
    }

    public Penguin(EntityType<? extends AmphibiousAnimal> type, Level level) {
        super(type, level, TFCSounds.PENGUIN);
    }

    @Override
    public boolean isPlayingDeadEffective() {
        return false;
    }

    @Override
    public void tick() {
        if (this.level().isClientSide) {
            EntityHelpers.startOrStop(this.walkingAnimation, EntityHelpers.isMovingOnLand((Entity)this), this.tickCount);
            EntityHelpers.startOrStop(this.swimmingAnimation, EntityHelpers.isMovingInWater((Entity)this), this.tickCount);
        }
        super.tick();
    }

    @Override
    public boolean isFood(ItemStack stack) {
        return Helpers.isItem(stack, TFCTags.Items.PENGUIN_FOOD);
    }

    protected SoundEvent getAmbientSound() {
        return (SoundEvent)this.ambient.get();
    }

    @Override
    public void playAmbientSound() {
        if (!this.isInWaterOrBubble()) {
            super.playAmbientSound();
        }
    }
}

