/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.entities.livestock;

import java.util.Locale;
import javax.annotation.Nonnull;
import net.dries007.tfc.common.component.TFCComponents;
import net.dries007.tfc.common.component.food.FoodCapability;
import net.dries007.tfc.common.component.item.ItemComponent;
import net.dries007.tfc.common.entities.BrainAnimalBehavior;
import net.dries007.tfc.common.entities.EntityHelpers;
import net.dries007.tfc.common.entities.GenderedRenderAnimal;
import net.dries007.tfc.common.entities.livestock.Age;
import net.dries007.tfc.common.entities.livestock.CommonAnimalBehavior;
import net.dries007.tfc.common.entities.livestock.Gender;
import net.dries007.tfc.config.TFCConfig;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.advancements.TFCAdvancements;
import net.minecraft.Util;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.neoforged.neoforge.items.ItemHandlerHelper;
import org.jetbrains.annotations.Nullable;

public interface TFCAnimalProperties
extends GenderedRenderAnimal,
BrainAnimalBehavior,
CommonAnimalBehavior {
    public static final long MATING_COOLDOWN_DEFAULT_TICKS = 24000L;
    public static final float READY_TO_MATE_FAMILIARITY = 0.3f;
    public static final float[] AGE_SCALES = (float[])Util.make(() -> {
        float[] scales = new float[32];
        for (int i = 0; i < scales.length; ++i) {
            scales[i] = Mth.map((float)(i + 1), (float)1.0f, (float)32.0f, (float)0.8f, (float)1.2f);
        }
        return scales;
    });

    default public LivingEntity getEntity() {
        return (LivingEntity)this;
    }

    default public boolean isHungry() {
        return this.calendar().getTicks() > this.getLastFedTick() + 24000L;
    }

    public TagKey<Item> getFoodTag();

    default public EntityType<?> getEntityTypeForBaby() {
        return this.getEntity().getType();
    }

    default public void tickAnimalData() {
        Age age;
        float familiarity = this.getFamiliarity();
        long currentTick = this.calendar().getTicks();
        long familiarityDecayTick = this.getLastFamiliarityTick();
        if (familiarity > 0.0f && familiarityDecayTick != -1L && currentTick > familiarityDecayTick + 24000L && (double)familiarity < TFCConfig.SERVER.familiarityDecayLimit.get()) {
            this.setFamiliarity(familiarity - 0.02f * (float)(currentTick - familiarityDecayTick - 24000L) / 24000.0f);
        }
        if ((age = this.getAgeType()) != this.getLastAge()) {
            this.setLastAge(age);
            this.getEntity().refreshDimensions();
        }
        if (!this.level().isClientSide && age == Age.ADULT && this.getUses() > this.getUsesToElderly() && this.getOldTick() == -1L) {
            this.setOldTick(this.calendar().getTicks() + (1L + (long)this.getEntity().getRandom().nextInt(5)) * 24000L);
        }
    }

    default public InteractionResult mobInteract(Player player, InteractionHand hand) {
        Level level = player.level();
        ItemStack stack = player.getItemInHand(hand);
        if (!stack.isEmpty()) {
            if (stack.getItem() instanceof SpawnEggItem) {
                return InteractionResult.PASS;
            }
            if (this.isFood(stack)) {
                if (this.isHungry()) {
                    return this.eatFood(stack, hand, player);
                }
                if (!level.isClientSide()) {
                    this.showExtraClickInfo(player);
                }
                return InteractionResult.FAIL;
            }
        }
        return InteractionResult.PASS;
    }

    default public void showExtraClickInfo(Player player) {
    }

    default public InteractionResult eatFood(@Nonnull ItemStack stack, InteractionHand hand, Player player) {
        LivingEntity entity = this.getEntity();
        Level level = entity.level();
        RandomSource random = entity.getRandom();
        for (int i = 0; i < 5; ++i) {
            level.addParticle((ParticleOptions)new ItemParticleOption(ParticleTypes.ITEM, stack), entity.getX() + 0.5, entity.getEyeY(), entity.getZ(), (double)Helpers.triangle(random, 0.1f), (double)Helpers.triangle(random, 0.1f), (double)Helpers.triangle(random, 0.1f));
        }
        entity.heal(1.0f);
        if (!level.isClientSide) {
            this.setLastFedNow();
            if (!player.isCreative()) {
                @Nullable ItemComponent bowl = (ItemComponent)stack.get(TFCComponents.BOWL);
                if (bowl != null) {
                    ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)bowl.stack().copy());
                }
                if (stack.hasCraftingRemainingItem()) {
                    ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)stack.getCraftingRemainingItem());
                }
                stack.shrink(1);
            }
            if (this.getAgeType() == Age.CHILD || this.getFamiliarity() < this.getAdultFamiliarityCap()) {
                float familiarity = this.getFamiliarity() + 0.06f;
                if (this.getAgeType() != Age.CHILD) {
                    familiarity = Math.min(familiarity, this.getAdultFamiliarityCap());
                }
                this.setFamiliarity(familiarity);
                if (player instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)player;
                    TFCAdvancements.FED_ANIMAL.trigger(serverPlayer, (Entity)entity);
                }
            }
            entity.playSound(this.eatingSound(stack), 1.0f, 1.0f);
        }
        return InteractionResult.sidedSuccess((boolean)level.isClientSide);
    }

    default public SoundEvent eatingSound(ItemStack food) {
        return SoundEvents.PLAYER_BURP;
    }

    default public void saveCommonAnimalData(CompoundTag nbt) {
        nbt.putBoolean("gender", this.isMale());
        nbt.putByte("lastAge", (byte)this.getLastAge().ordinal());
        nbt.putInt("geneticSize", this.getGeneticSize());
        nbt.putInt("uses", this.getUses());
        nbt.putBoolean("fertilized", this.isFertilized());
        nbt.putFloat("familiarity", this.getFamiliarity());
        nbt.putLong("lastFamiliarityTick", ((Long)this.getEntityData().get(this.animalData().lastFamiliarityTick())).longValue());
        nbt.putLong("birthTick", this.getBirthTick());
        nbt.putLong("oldTick", this.getOldTick());
        nbt.putLong("lastFedTick", this.getLastFedTick());
        nbt.putLong("lastMateTick", this.getLastMateTick());
    }

    default public void readCommonAnimalData(CompoundTag nbt) {
        this.setGender(nbt.getBoolean("gender") ? Gender.MALE : Gender.FEMALE);
        this.setLastAge(Age.valueOf(nbt.getInt("lastAge")));
        this.setGeneticSize(EntityHelpers.getIntOrDefault(nbt, "geneticSize", 16));
        this.setUses(nbt.getInt("uses"));
        this.setFertilized(nbt.getBoolean("fertilized"));
        this.getEntityData().set(this.animalData().familiarity(), (Object)Float.valueOf(nbt.getFloat("familiarity")));
        this.getEntityData().set(this.animalData().lastFamiliarityTick(), (Object)nbt.getLong("lastFamiliarityTick"));
        this.setBirthTick(nbt.getLong("birthTick"));
        this.setOldTick(nbt.getLong("oldTick"));
        this.getEntityData().set(this.animalData().lastFedTick(), (Object)nbt.getLong("lastFedTick"));
        this.getEntityData().set(this.animalData().lastMateTick(), (Object)nbt.getLong("lastMateTick"));
    }

    default public void initCommonAnimalData(ServerLevelAccessor level, DifficultyInstance difficulty, MobSpawnType reason) {
        RandomSource random = this.getEntity().getRandom();
        this.setGender(Gender.valueOf(random.nextBoolean()));
        this.setBirthTick(EntityHelpers.getRandomGrowth((Entity)this.getEntity(), random, this.getDaysToAdulthood()));
        this.setOldTick(-1L);
        this.setFamiliarity(0.0f);
        this.setUses(0);
        this.setGeneticSize(Mth.nextInt((RandomSource)random, (int)4, (int)18));
        this.setFertilized(false);
        LivingEntity livingEntity = this.getEntity();
        if (livingEntity instanceof AgeableMob) {
            AgeableMob mob = (AgeableMob)livingEntity;
            mob.setAge(0);
        }
    }

    default public boolean isReadyToMate() {
        return this.getAgeType() == Age.ADULT && this.getFamiliarity() >= 0.3f && !this.isFertilized() && !this.isHungry() && this.getLastMateTick() + 24000L <= this.calendar().getTicks();
    }

    default public int getGeneticSize() {
        return ((Byte)this.getEntityData().get(this.animalData().geneticSize())).byteValue();
    }

    default public void setGeneticSize(int size) {
        this.getEntityData().set(this.animalData().geneticSize(), (Object)((byte)Mth.clamp((int)size, (int)1, (int)32)));
        AttributeInstance instance = this.getEntity().getAttribute(Attributes.SCALE);
        if (instance != null) {
            instance.setBaseValue((double)AGE_SCALES[this.getGeneticSize() - 1]);
        }
    }

    default public float getAgeScale() {
        return AGE_SCALES[this.getGeneticSize() - 1];
    }

    default public void onFertilized(TFCAnimalProperties male) {
        this.setFertilized(true);
        this.setLastFedYesterday();
        male.setLastFedYesterday();
        male.addUses(5);
    }

    default public void setBabyTraits(TFCAnimalProperties baby) {
        baby.setGender(Gender.valueOf(this.getEntity().getRandom().nextBoolean()));
        baby.setBirthTickNow();
        baby.setFamiliarity(this.getFamiliarity() < 0.9f ? this.getFamiliarity() / 2.0f : this.getFamiliarity() * 0.9f);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Nullable
    default public AgeableMob getBreedOffspring(ServerLevel level, AgeableMob other) {
        if (!this.getGender().equals((Object)Gender.FEMALE)) return null;
        if (other != this && other instanceof TFCAnimalProperties) {
            TFCAnimalProperties otherFertile = (TFCAnimalProperties)other;
            if (!this.isFertilized()) {
                this.onFertilized(otherFertile);
                return null;
            }
        }
        if (other != this) return null;
        Entity baby = this.getEntityTypeForBaby().create((Level)level);
        if (!(baby instanceof TFCAnimalProperties)) return null;
        TFCAnimalProperties properties = (TFCAnimalProperties)baby;
        if (!(baby instanceof AgeableMob)) return null;
        AgeableMob ageable = (AgeableMob)baby;
        this.setBabyTraits(properties);
        return ageable;
    }

    default public boolean checkExtraBreedConditions(TFCAnimalProperties other) {
        return true;
    }

    default public Age getAgeType() {
        long currentTick = this.calendar().getTicks();
        long oldTick = this.getOldTick();
        if (oldTick != -1L && currentTick > oldTick) {
            return Age.OLD;
        }
        long adultTick = this.getBirthTick() + (long)this.animalConfig().adulthoodDays().get().intValue() * 24000L;
        if (currentTick > adultTick) {
            return Age.ADULT;
        }
        return Age.CHILD;
    }

    default public boolean isReadyForAnimalProduct() {
        return false;
    }

    default public boolean hasProduct() {
        return false;
    }

    default public void setProductsCooldown() {
    }

    default public long getProductsCooldown() {
        return 0L;
    }

    @Override
    default public boolean displayMaleCharacteristics() {
        return !this.getEntity().isBaby() && this.isMale();
    }

    @Override
    default public boolean displayFemaleCharacteristics() {
        return !this.getEntity().isBaby() && this.isFemale();
    }

    default public boolean isFood(ItemStack stack) {
        return (this.eatsRottenFood() || !FoodCapability.isRotten(stack)) && Helpers.isItem(stack, this.getFoodTag());
    }

    default public Component getGenderedTypeName() {
        return Component.translatable((String)(this.getEntity().getType().getDescriptionId() + "." + this.getGender().name().toLowerCase(Locale.ROOT)));
    }

    default public MutableComponent getProductReadyName() {
        return Component.translatable((String)"tfc.jade.product.generic");
    }
}

