/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.entities.livestock.horse;

import java.util.function.Predicate;
import java.util.function.Supplier;
import net.dries007.tfc.client.TFCSounds;
import net.dries007.tfc.common.TFCTags;
import net.dries007.tfc.common.entities.EntityHelpers;
import net.dries007.tfc.common.entities.ai.TFCAvoidEntityGoal;
import net.dries007.tfc.common.entities.ai.TFCGroundPathNavigation;
import net.dries007.tfc.common.entities.livestock.Age;
import net.dries007.tfc.common.entities.livestock.CommonAnimalData;
import net.dries007.tfc.common.entities.livestock.TFCAnimalProperties;
import net.dries007.tfc.common.entities.livestock.horse.HorseProperties;
import net.dries007.tfc.common.fluids.FluidHelpers;
import net.dries007.tfc.config.animals.AnimalConfig;
import net.dries007.tfc.config.animals.MammalConfig;
import net.dries007.tfc.util.Helpers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.TagKey;
import net.minecraft.world.Container;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.horse.AbstractChestedHorse;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.capability.IFluidHandlerItem;
import net.neoforged.neoforge.items.ItemHandlerHelper;
import org.jetbrains.annotations.Nullable;

public abstract class TFCChestedHorse
extends AbstractChestedHorse
implements HorseProperties {
    private static final CommonAnimalData ANIMAL_DATA = CommonAnimalData.create(TFCChestedHorse.class);
    private static final EntityDataAccessor<Long> PREGNANT_TIME = SynchedEntityData.defineId(TFCChestedHorse.class, (EntityDataSerializer)EntityDataSerializers.LONG);
    private static final EntityDataAccessor<ItemStack> CHEST_ITEM = SynchedEntityData.defineId(TFCChestedHorse.class, (EntityDataSerializer)EntityDataSerializers.ITEM_STACK);
    private boolean overburdened = false;
    @Nullable
    private CompoundTag genes;
    private final Supplier<? extends SoundEvent> ambient;
    private final Supplier<? extends SoundEvent> hurt;
    private final Supplier<? extends SoundEvent> death;
    private final Supplier<? extends SoundEvent> step;
    private final Supplier<? extends SoundEvent> eat;
    private final Supplier<? extends SoundEvent> angry;
    private final AnimalConfig config;
    private final MammalConfig mammalConfig;

    public static boolean vanillaParentingCheck(AbstractHorse horse) {
        return !horse.isVehicle() && !horse.isPassenger() && horse.isTamed() && !horse.isBaby();
    }

    public TFCChestedHorse(EntityType<? extends TFCChestedHorse> type, Level level, TFCSounds.EntityId sounds, Supplier<? extends SoundEvent> eatSound, Supplier<? extends SoundEvent> angrySound, MammalConfig config) {
        super(type, level);
        this.ambient = sounds.ambient();
        this.hurt = sounds.hurt();
        this.death = sounds.death();
        this.step = sounds.step();
        this.eat = eatSound;
        this.angry = angrySound;
        this.config = config.inner();
        this.mammalConfig = config;
    }

    public ItemStack getChestItem() {
        return (ItemStack)this.entityData.get(CHEST_ITEM);
    }

    public void setChestItem(ItemStack stack) {
        this.entityData.set(CHEST_ITEM, (Object)stack);
    }

    public boolean hasChest() {
        return !this.getChestItem().isEmpty() && Helpers.isItem(this.getChestItem(), (TagKey<Item>)Tags.Items.CHESTS_WOODEN);
    }

    public void containerChanged(Container container) {
        super.containerChanged(container);
        this.overburdened = Helpers.getCarryCount(container).isNonZero();
    }

    protected void registerGoals() {
        super.registerGoals();
        EntityHelpers.removeGoalOfPriority(this.goalSelector, 3);
        this.goalSelector.addGoal(3, (Goal)new TemptGoal((PathfinderMob)this, 1.25, (Predicate)Ingredient.of((TagKey)this.getFoodTag()), false));
        this.goalSelector.addGoal(5, new TFCAvoidEntityGoal<PathfinderMob>((PathfinderMob)this, PathfinderMob.class, 8.0f, 1.6f, 1.4f, TFCTags.Entities.HUNTS_LAND_PREY));
    }

    protected void dropEquipment() {
        if (!this.getChestItem().isEmpty()) {
            if (!this.level().isClientSide) {
                this.spawnAtLocation(this.getChestItem());
            }
            this.setChestItem(ItemStack.EMPTY);
        }
        super.dropEquipment();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean canMate(Animal otherAnimal) {
        if (!(otherAnimal instanceof TFCAnimalProperties)) return false;
        TFCAnimalProperties other = (TFCAnimalProperties)otherAnimal;
        if (this.getGender() == other.getGender()) return false;
        if (!this.isReadyToMate()) return false;
        if (!other.isReadyToMate()) return false;
        return true;
    }

    @Override
    public InteractionResult mobInteract(Player player, InteractionHand hand) {
        InteractionResult result = HorseProperties.super.mobInteract(player, hand);
        if (result == InteractionResult.PASS) {
            ItemStack stack = player.getItemInHand(hand);
            if (!this.isBaby()) {
                if (this.isTamed() && player.isSecondaryUseActive()) {
                    if (!this.hasChest() && !this.getChestItem().isEmpty()) {
                        if (stack.isEmpty()) {
                            ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)this.getChestItem().copy());
                            this.setChestItem(ItemStack.EMPTY);
                            return InteractionResult.sidedSuccess((boolean)this.level().isClientSide);
                        }
                        IFluidHandlerItem destFluidItemHandler = (IFluidHandlerItem)stack.getCapability(Capabilities.FluidHandler.ITEM);
                        IFluidHandlerItem sourceFluidItemHandler = (IFluidHandlerItem)this.getChestItem().getCapability(Capabilities.FluidHandler.ITEM);
                        if (destFluidItemHandler != null && sourceFluidItemHandler != null && FluidHelpers.transferBetweenItemAndOther(this.getChestItem(), destFluidItemHandler, (IFluidHandler)sourceFluidItemHandler, (IFluidHandler)destFluidItemHandler, FluidHelpers.Transfer.FILL, this.level(), this.blockPosition(), FluidHelpers.with(player, hand))) {
                            return InteractionResult.sidedSuccess((boolean)this.level().isClientSide);
                        }
                    }
                    this.openCustomInventoryScreen(player);
                    return InteractionResult.sidedSuccess((boolean)this.level().isClientSide);
                }
                if (this.isVehicle()) {
                    return InteractionResult.PASS;
                }
            }
            if (!stack.isEmpty()) {
                if (!this.isTamed()) {
                    this.makeMad();
                    return InteractionResult.sidedSuccess((boolean)this.level().isClientSide);
                }
                if (this.getChestItem().isEmpty() && Helpers.isItem(stack, TFCTags.Items.CARRIED_BY_HORSE)) {
                    this.setChestItem(stack.copy());
                    this.playChestEquipsSound();
                    if (!player.getAbilities().instabuild) {
                        stack.shrink(1);
                    }
                    this.createInventory();
                    return InteractionResult.sidedSuccess((boolean)this.level().isClientSide);
                }
                if (!this.isBaby() && !this.isSaddled() && stack.is(Items.SADDLE)) {
                    this.openCustomInventoryScreen(player);
                    return InteractionResult.sidedSuccess((boolean)this.level().isClientSide);
                }
            }
            if (this.isBaby()) {
                return InteractionResult.PASS;
            }
            if (this.isTamed() && this.getOwnerUUID() == null) {
                this.tameWithName(player);
            }
            this.doPlayerRide(player);
            return InteractionResult.sidedSuccess((boolean)this.level().isClientSide);
        }
        return result;
    }

    public boolean isTamed() {
        return this.getFamiliarity() > 0.15f;
    }

    public SlotAccess getSlot(int slot) {
        return slot == 499 ? new SlotAccess(){

            public ItemStack get() {
                return TFCChestedHorse.this.getChestItem();
            }

            public boolean set(ItemStack stack) {
                TFCChestedHorse horse = TFCChestedHorse.this;
                if (stack.isEmpty()) {
                    if (horse.hasChest()) {
                        horse.setChestItem(ItemStack.EMPTY);
                        horse.createInventory();
                    }
                    return true;
                }
                if (Helpers.isItem(stack, TFCTags.Items.CARRIED_BY_HORSE)) {
                    if (!horse.hasChest()) {
                        horse.setChestItem(stack);
                        horse.createInventory();
                    }
                    return true;
                }
                return false;
            }
        } : super.getSlot(slot);
    }

    protected SoundEvent getEatingSound() {
        super.getEatingSound();
        return this.eat.get();
    }

    protected SoundEvent getAngrySound() {
        super.getAngrySound();
        return this.angry.get();
    }

    protected float getBlockSpeedFactor() {
        return Helpers.isBlock(this.level().getBlockState(this.blockPosition()), TFCTags.Blocks.ANIMAL_IGNORED_PLANTS) ? 1.0f : super.getBlockSpeedFactor();
    }

    public boolean canBeLeashed() {
        return super.canBeLeashed() && !this.overburdened;
    }

    @Nullable
    public SpawnGroupData finalizeSpawn(ServerLevelAccessor level, DifficultyInstance difficulty, MobSpawnType spawnType, @Nullable SpawnGroupData spawnData) {
        spawnData = super.finalizeSpawn(level, difficulty, spawnType, spawnData);
        if (spawnType != MobSpawnType.BREEDING) {
            this.initCommonAnimalData(level, difficulty, spawnType);
        }
        this.setPregnantTime(-1L);
        return spawnData;
    }

    @Override
    public MammalConfig getMammalConfig() {
        return this.mammalConfig;
    }

    @Override
    public long getPregnantTime() {
        return (Long)this.entityData.get(PREGNANT_TIME);
    }

    @Override
    public void setPregnantTime(long day) {
        this.entityData.set(PREGNANT_TIME, (Object)day);
    }

    @Override
    public void setGenes(@Nullable CompoundTag tag) {
        this.genes = tag;
    }

    @Override
    @Nullable
    public CompoundTag getGenes() {
        return this.genes;
    }

    @Override
    public AnimalConfig animalConfig() {
        return this.config;
    }

    @Override
    public CommonAnimalData animalData() {
        return ANIMAL_DATA;
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        this.animalData().define(builder);
        builder.define(PREGNANT_TIME, (Object)-1L);
        builder.define(CHEST_ITEM, (Object)ItemStack.EMPTY);
    }

    public void addAdditionalSaveData(CompoundTag nbt) {
        nbt.put("chestItem", this.getChestItem().saveOptional((HolderLookup.Provider)this.registryAccess()));
        super.addAdditionalSaveData(nbt);
        this.saveCommonAnimalData(nbt);
        nbt.putBoolean("overburdened", this.overburdened);
    }

    public void readAdditionalSaveData(CompoundTag nbt) {
        this.setChestItem(ItemStack.parseOptional((HolderLookup.Provider)this.registryAccess(), (CompoundTag)nbt.getCompound("chestItem")));
        super.readAdditionalSaveData(nbt);
        this.readCommonAnimalData(nbt);
        this.overburdened = nbt.getBoolean("overburdened");
    }

    public boolean isBaby() {
        return this.getAgeType() == Age.CHILD;
    }

    public void setAge(int age) {
        super.setAge(0);
    }

    public int getAge() {
        return this.isBaby() ? -24000 : 0;
    }

    @Override
    @Nullable
    public AgeableMob getBreedOffspring(ServerLevel level, AgeableMob other) {
        return HorseProperties.super.getBreedOffspring(level, other);
    }

    public void onSyncedDataUpdated(EntityDataAccessor<?> data) {
        super.onSyncedDataUpdated(data);
        if (ANIMAL_DATA.birthTick().equals(data)) {
            this.refreshDimensions();
        }
    }

    public void tick() {
        super.tick();
        if (this.level().getGameTime() % 20L == 0L) {
            this.tickAnimalData();
            if (this.overburdened) {
                this.addEffect(Helpers.getOverburdened(true));
            }
        }
    }

    @Override
    public boolean isFood(ItemStack stack) {
        return HorseProperties.super.isFood(stack);
    }

    public Component getTypeName() {
        return this.getGenderedTypeName();
    }

    protected SoundEvent getAmbientSound() {
        super.getAmbientSound();
        return this.ambient.get();
    }

    protected SoundEvent getHurtSound(DamageSource src) {
        super.getHurtSound(src);
        return this.hurt.get();
    }

    protected SoundEvent getDeathSound() {
        super.getDeathSound();
        return this.death.get();
    }

    protected void playStepSound(BlockPos pos, BlockState block) {
        super.playStepSound(pos, block);
        this.playSound(this.step.get(), 0.15f, 1.0f);
    }

    public float getWalkTargetValue(BlockPos pos, LevelReader level) {
        return level.getBlockState(pos.below()).is(TFCTags.Blocks.BUSH_PLANTABLE_ON) ? 10.0f : level.getPathfindingCostFromLightLevels(pos);
    }

    public PathNavigation createNavigation(Level level) {
        return new TFCGroundPathNavigation((Mob)this, level);
    }

    public boolean isInWall() {
        return !this.level().isClientSide && super.isInWall();
    }

    protected void pushEntities() {
        if (!this.level().isClientSide) {
            super.pushEntities();
        }
    }
}

