/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.entities.livestock.horse;

import java.util.function.Predicate;
import java.util.function.Supplier;
import net.dries007.tfc.client.TFCSounds;
import net.dries007.tfc.common.TFCTags;
import net.dries007.tfc.common.entities.EntityHelpers;
import net.dries007.tfc.common.entities.TFCEntities;
import net.dries007.tfc.common.entities.ai.TFCAvoidEntityGoal;
import net.dries007.tfc.common.entities.ai.TFCGroundPathNavigation;
import net.dries007.tfc.common.entities.livestock.Age;
import net.dries007.tfc.common.entities.livestock.CommonAnimalData;
import net.dries007.tfc.common.entities.livestock.MammalProperties;
import net.dries007.tfc.common.entities.livestock.TFCAnimalProperties;
import net.dries007.tfc.common.entities.livestock.horse.HorseProperties;
import net.dries007.tfc.common.entities.livestock.horse.TFCChestedHorse;
import net.dries007.tfc.common.entities.livestock.horse.TFCDonkey;
import net.dries007.tfc.config.TFCConfig;
import net.dries007.tfc.config.animals.AnimalConfig;
import net.dries007.tfc.config.animals.MammalConfig;
import net.dries007.tfc.mixin.accessor.HorseAccessor;
import net.dries007.tfc.util.Helpers;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.animal.horse.Horse;
import net.minecraft.world.entity.animal.horse.Markings;
import net.minecraft.world.entity.animal.horse.Variant;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class TFCHorse
extends Horse
implements HorseProperties {
    private static final CommonAnimalData ANIMAL_DATA = CommonAnimalData.create(TFCHorse.class);
    private static final EntityDataAccessor<Long> PREGNANT_TIME = SynchedEntityData.defineId(TFCHorse.class, (EntityDataSerializer)EntityDataSerializers.LONG);
    @Nullable
    private CompoundTag genes;
    private final Supplier<? extends SoundEvent> ambient;
    private final Supplier<? extends SoundEvent> hurt;
    private final Supplier<? extends SoundEvent> death;
    private final Supplier<? extends SoundEvent> step;
    private final Supplier<? extends SoundEvent> eat;
    private final Supplier<? extends SoundEvent> angry;
    private final AnimalConfig config;
    private final MammalConfig mammalConfig;

    public TFCHorse(EntityType<? extends TFCHorse> type, Level level) {
        this(type, level, TFCSounds.HORSE, () -> SoundEvents.HORSE_EAT, () -> SoundEvents.HORSE_ANGRY, TFCConfig.SERVER.horseConfig);
    }

    public TFCHorse(EntityType<? extends TFCHorse> type, Level level, TFCSounds.EntityId sounds, Supplier<? extends SoundEvent> eatSound, Supplier<? extends SoundEvent> angrySound, MammalConfig config) {
        super(type, level);
        this.ambient = sounds.ambient();
        this.hurt = sounds.hurt();
        this.death = sounds.death();
        this.step = sounds.step();
        this.eat = eatSound;
        this.angry = angrySound;
        this.config = config.inner();
        this.mammalConfig = config;
    }

    @Override
    public void createGenes(CompoundTag tag, TFCAnimalProperties maleProperties) {
        HorseProperties.super.createGenes(tag, maleProperties);
        AbstractHorse male = (AbstractHorse)maleProperties;
        boolean isMule = maleProperties instanceof TFCDonkey;
        tag.putBoolean("isMule", isMule);
        if (!isMule && male instanceof TFCHorse) {
            TFCHorse maleHorse = (TFCHorse)male;
            tag.putInt("markings1", maleHorse.getMarkings().getId());
            tag.putInt("markings2", this.getMarkings().getId());
            tag.putInt("variant1", maleHorse.getVariant().getId());
            tag.putInt("variant2", this.getVariant().getId());
        }
    }

    @Override
    public void applyGenes(CompoundTag tag, MammalProperties babyProperties) {
        HorseProperties.super.applyGenes(tag, babyProperties);
        if (babyProperties instanceof TFCHorse) {
            TFCHorse baby = (TFCHorse)babyProperties;
            if (tag.contains("markings1")) {
                int i = this.random.nextInt(9);
                Variant variant = i < 4 ? Variant.byId((int)tag.getInt("variant1")) : (i < 8 ? Variant.byId((int)tag.getInt("variant2")) : (Variant)Util.getRandom((Object[])Variant.values(), (RandomSource)this.random));
                int j = this.random.nextInt(5);
                Markings markings = j < 2 ? Markings.byId((int)tag.getInt("markings1")) : (j < 4 ? Markings.byId((int)tag.getInt("markings2")) : (Markings)Util.getRandom((Object[])Markings.values(), (RandomSource)this.random));
                ((HorseAccessor)((Object)baby)).invoke$setVariantAndTypeMarkings(variant, markings);
            }
        }
    }

    @Override
    public TagKey<Item> getFoodTag() {
        return TFCTags.Items.HORSE_FOOD;
    }

    protected void registerGoals() {
        super.registerGoals();
        EntityHelpers.removeGoalOfPriority(this.goalSelector, 3);
        this.goalSelector.addGoal(3, (Goal)new TemptGoal((PathfinderMob)this, 1.25, (Predicate)Ingredient.of(this.getFoodTag()), false));
        this.goalSelector.addGoal(5, new TFCAvoidEntityGoal<PathfinderMob>((PathfinderMob)this, PathfinderMob.class, 8.0f, 1.6f, 1.4f, TFCTags.Entities.HUNTS_LAND_PREY));
    }

    @Override
    public EntityType<?> getEntityTypeForBaby() {
        CompoundTag genes = this.getGenes();
        return genes != null && genes.contains("isMule") && genes.getBoolean("isMule") ? (EntityType)TFCEntities.MULE.get() : (EntityType)TFCEntities.HORSE.get();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean canMate(Animal otherAnimal) {
        if (!(otherAnimal instanceof TFCAnimalProperties)) return false;
        TFCAnimalProperties other = (TFCAnimalProperties)otherAnimal;
        if (this.getGender() == other.getGender()) return false;
        if (!this.isReadyToMate()) return false;
        if (!other.isReadyToMate()) return false;
        if (!this.checkExtraBreedConditions(other)) return false;
        return true;
    }

    @Override
    public boolean checkExtraBreedConditions(TFCAnimalProperties otherAnimal) {
        if (HorseProperties.super.checkExtraBreedConditions(otherAnimal) && (otherAnimal instanceof TFCDonkey || otherAnimal instanceof Horse)) {
            AbstractHorse otherHorse = (AbstractHorse)otherAnimal;
            return TFCChestedHorse.vanillaParentingCheck((AbstractHorse)this) && TFCChestedHorse.vanillaParentingCheck(otherHorse);
        }
        return false;
    }

    @Override
    public InteractionResult mobInteract(Player player, InteractionHand hand) {
        InteractionResult result = HorseProperties.super.mobInteract(player, hand);
        if (result == InteractionResult.PASS) {
            ItemStack stack = player.getItemInHand(hand);
            if (!this.isBaby()) {
                if (this.isTamed() && player.isSecondaryUseActive()) {
                    this.openCustomInventoryScreen(player);
                    return InteractionResult.sidedSuccess((boolean)this.level().isClientSide);
                }
                if (this.isVehicle()) {
                    return InteractionResult.PASS;
                }
            }
            if (!stack.isEmpty()) {
                boolean canBeSaddled;
                InteractionResult res = stack.interactLivingEntity(player, (LivingEntity)this, hand);
                if (res.consumesAction()) {
                    return res;
                }
                if (!this.isTamed()) {
                    this.makeMad();
                    return InteractionResult.sidedSuccess((boolean)this.level().isClientSide);
                }
                boolean bl = canBeSaddled = !this.isBaby() && !this.isSaddled() && stack.is(Items.SADDLE);
                if (this.isBodyArmorItem(stack) || canBeSaddled) {
                    this.openCustomInventoryScreen(player);
                    return InteractionResult.sidedSuccess((boolean)this.level().isClientSide);
                }
            }
            if (this.isBaby()) {
                return InteractionResult.PASS;
            }
            if (this.isTamed() && this.getOwnerUUID() == null) {
                this.tameWithName(player);
            }
            this.doPlayerRide(player);
            return InteractionResult.sidedSuccess((boolean)this.level().isClientSide);
        }
        return result;
    }

    public boolean isTamed() {
        return this.getFamiliarity() > 0.15f;
    }

    protected SoundEvent getEatingSound() {
        super.getEatingSound();
        return this.eat.get();
    }

    protected SoundEvent getAngrySound() {
        super.getAngrySound();
        return this.angry.get();
    }

    protected float getBlockSpeedFactor() {
        return Helpers.isBlock(this.level().getBlockState(this.blockPosition()), TFCTags.Blocks.ANIMAL_IGNORED_PLANTS) ? 1.0f : super.getBlockSpeedFactor();
    }

    @Nullable
    public SpawnGroupData finalizeSpawn(ServerLevelAccessor level, DifficultyInstance difficulty, MobSpawnType spawnType, @Nullable SpawnGroupData spawnData) {
        spawnData = super.finalizeSpawn(level, difficulty, spawnType, spawnData);
        if (spawnType != MobSpawnType.BREEDING) {
            this.initCommonAnimalData(level, difficulty, spawnType);
        }
        this.setPregnantTime(-1L);
        return spawnData;
    }

    @Override
    public MammalConfig getMammalConfig() {
        return this.mammalConfig;
    }

    @Override
    public long getPregnantTime() {
        return (Long)this.entityData.get(PREGNANT_TIME);
    }

    @Override
    public void setPregnantTime(long day) {
        this.entityData.set(PREGNANT_TIME, (Object)day);
    }

    @Override
    public void setGenes(@Nullable CompoundTag tag) {
        this.genes = tag;
    }

    @Override
    @Nullable
    public CompoundTag getGenes() {
        return this.genes;
    }

    @Override
    public AnimalConfig animalConfig() {
        return this.config;
    }

    @Override
    public CommonAnimalData animalData() {
        return ANIMAL_DATA;
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        this.animalData().define(builder);
        builder.define(PREGNANT_TIME, (Object)-1L);
    }

    public void addAdditionalSaveData(CompoundTag nbt) {
        super.addAdditionalSaveData(nbt);
        this.saveCommonAnimalData(nbt);
    }

    public void readAdditionalSaveData(CompoundTag nbt) {
        super.readAdditionalSaveData(nbt);
        this.readCommonAnimalData(nbt);
    }

    public boolean isBaby() {
        return this.getAgeType() == Age.CHILD;
    }

    public void setAge(int age) {
        super.setAge(0);
    }

    public int getAge() {
        return this.isBaby() ? -24000 : 0;
    }

    @Override
    @Nullable
    public AgeableMob getBreedOffspring(ServerLevel level, AgeableMob other) {
        return HorseProperties.super.getBreedOffspring(level, other);
    }

    public void onSyncedDataUpdated(EntityDataAccessor<?> data) {
        super.onSyncedDataUpdated(data);
        if (ANIMAL_DATA.birthTick().equals(data)) {
            this.refreshDimensions();
        }
    }

    public void tick() {
        super.tick();
        if (this.level().getGameTime() % 20L == 0L) {
            this.tickAnimalData();
        }
    }

    @Override
    public boolean isFood(ItemStack stack) {
        return HorseProperties.super.isFood(stack);
    }

    public Component getTypeName() {
        return this.getGenderedTypeName();
    }

    protected SoundEvent getAmbientSound() {
        super.getAmbientSound();
        return this.ambient.get();
    }

    protected SoundEvent getHurtSound(DamageSource src) {
        super.getHurtSound(src);
        return this.hurt.get();
    }

    protected SoundEvent getDeathSound() {
        super.getDeathSound();
        return this.death.get();
    }

    protected void playStepSound(BlockPos pos, BlockState block) {
        super.playStepSound(pos, block);
        this.playSound(this.step.get(), 0.15f, 1.0f);
    }

    public float getWalkTargetValue(BlockPos pos, LevelReader level) {
        return level.getBlockState(pos.below()).is(TFCTags.Blocks.BUSH_PLANTABLE_ON) ? 10.0f : level.getPathfindingCostFromLightLevels(pos);
    }

    public PathNavigation createNavigation(Level level) {
        return new TFCGroundPathNavigation((Mob)this, level);
    }

    public boolean isInWall() {
        return !this.level().isClientSide && super.isInWall();
    }

    protected void pushEntities() {
        if (!this.level().isClientSide) {
            super.pushEntities();
        }
    }
}

