/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.entities.misc;

import java.util.function.Supplier;
import net.dries007.tfc.common.blockentities.TFCChestBlockEntity;
import net.dries007.tfc.common.container.ISlotCallback;
import net.dries007.tfc.common.container.RestrictedChestContainer;
import net.dries007.tfc.common.container.TFCContainerTypes;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.Container;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.entity.vehicle.ChestBoat;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class TFCChestBoat
extends ChestBoat
implements ISlotCallback {
    public static final EntityDataAccessor<ItemStack> CHEST_ITEM = SynchedEntityData.defineId(TFCChestBoat.class, (EntityDataSerializer)EntityDataSerializers.ITEM_STACK);
    private final Supplier<? extends Item> drop;

    public TFCChestBoat(EntityType<? extends Boat> type, Level level, Supplier<? extends Item> drop) {
        super(type, level);
        this.drop = drop;
    }

    @Nullable
    public AbstractContainerMenu createMenu(int windowId, Inventory inv, Player player) {
        if (this.getLootTable() != null && player.isSpectator()) {
            return null;
        }
        this.unpackLootTable(inv.player);
        return new RestrictedChestContainer((MenuType)TFCContainerTypes.CHEST_9x2.get(), windowId, inv, (Container)this, 2);
    }

    public void destroy(DamageSource source) {
        super.destroy(source);
        this.spawnAtLocation(this.getChestItem().copy());
    }

    public int getContainerSize() {
        return 18;
    }

    public boolean canPlaceItem(int slot, ItemStack stack) {
        return TFCChestBlockEntity.isValid(stack);
    }

    @Override
    public boolean isItemValid(int slot, ItemStack stack) {
        return this.canPlaceItem(slot, stack);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(CHEST_ITEM, (Object)ItemStack.EMPTY);
    }

    protected void readAdditionalSaveData(CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        this.setChestItem(ItemStack.parseOptional((HolderLookup.Provider)this.level().registryAccess(), (CompoundTag)tag.getCompound("chestItem")));
    }

    protected void addAdditionalSaveData(CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        tag.put("chestItem", this.getChestItem().save((HolderLookup.Provider)this.level().registryAccess()));
    }

    public EntityType<?> getType() {
        return super.getType();
    }

    public Item getDropItem() {
        return this.drop.get();
    }

    public ItemStack getChestItem() {
        return (ItemStack)this.entityData.get(CHEST_ITEM);
    }

    public void setChestItem(ItemStack stack) {
        this.entityData.set(CHEST_ITEM, (Object)stack.copy());
    }
}

