/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.entities.misc;

import net.dries007.tfc.TerraFirmaCraft;
import net.dries007.tfc.common.component.TFCComponents;
import net.dries007.tfc.common.entities.TFCEntities;
import net.dries007.tfc.common.items.TFCFishingRodItem;
import net.dries007.tfc.util.advancements.TFCAdvancements;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.stats.Stats;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.animal.AbstractFish;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.FishingHook;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.entity.IEntityWithComplexSpawn;

public class TFCFishingHook
extends FishingHook
implements IEntityWithComplexSpawn {
    public static final EntityDataAccessor<ItemStack> BAIT = SynchedEntityData.defineId(TFCFishingHook.class, (EntityDataSerializer)EntityDataSerializers.ITEM_STACK);
    public int pullExhaustion = 0;
    private float strength = 0.04f;
    private long lastPulled = 0L;

    public TFCFishingHook(EntityType<? extends TFCFishingHook> type, Level level) {
        super(type, level);
    }

    public TFCFishingHook(Player player, Level level, float strength, ItemStack bait) {
        this((EntityType<? extends TFCFishingHook>)((EntityType)TFCEntities.FISHING_BOBBER.get()), level);
        this.setOwner((Entity)player);
        float f = player.getXRot();
        float f1 = player.getYRot();
        float f2 = Mth.cos((float)(-f1 * ((float)Math.PI / 180) - (float)Math.PI));
        float f3 = Mth.sin((float)(-f1 * ((float)Math.PI / 180) - (float)Math.PI));
        float f4 = -Mth.cos((float)(-f * ((float)Math.PI / 180)));
        float f5 = Mth.sin((float)(-f * ((float)Math.PI / 180)));
        double d0 = player.getX() - (double)f3 * 0.3;
        double d1 = player.getEyeY();
        double d2 = player.getZ() - (double)f2 * 0.3;
        this.moveTo(d0, d1, d2, f1, f);
        Vec3 vec3 = new Vec3((double)(-f3), (double)Mth.clamp((float)(-(f5 / f4)), (float)-5.0f, (float)5.0f), (double)(-f2));
        double d3 = vec3.length();
        vec3 = vec3.multiply(0.6 / d3 + 0.5 + this.random.nextGaussian() * 0.0045, 0.6 / d3 + 0.5 + this.random.nextGaussian() * 0.0045, 0.6 / d3 + 0.5 + this.random.nextGaussian() * 0.0045);
        this.setDeltaMovement(vec3);
        this.setYRot((float)(Mth.atan2((double)vec3.x, (double)vec3.z) * 57.2957763671875));
        this.setXRot((float)(Mth.atan2((double)vec3.y, (double)vec3.horizontalDistance()) * 57.2957763671875));
        this.yRotO = this.getYRot();
        this.xRotO = this.getXRot();
        this.strength = strength;
        this.setBait(bait);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(BAIT, (Object)ItemStack.EMPTY);
    }

    public void setBait(ItemStack item) {
        this.entityData.set(BAIT, (Object)item);
    }

    public ItemStack getBait() {
        return (ItemStack)this.entityData.get(BAIT);
    }

    public void tick() {
        super.tick();
        if (this.hookedIn != null && !this.hookedIn.isRemoved()) {
            this.currentState = FishingHook.FishHookState.HOOKED_IN_ENTITY;
            this.setPos(this.hookedIn.getX(), this.hookedIn.getY(0.8), this.hookedIn.getZ());
        }
        if (this.pullExhaustion > 0) {
            --this.pullExhaustion;
        }
    }

    public void catchingFish(BlockPos pos) {
    }

    public int retrieve(ItemStack stack) {
        Player player = this.getPlayerOwner();
        long diff = this.level().getGameTime() - this.lastPulled;
        if (diff < 25L) {
            this.pullExhaustion = (int)((long)this.pullExhaustion + (25L - diff) * 2L);
            if (this.pullExhaustion > 100) {
                if (player != null && this.level().isClientSide) {
                    player.displayClientMessage((Component)Component.translatable((String)"tfc.fishing.pulled_too_hard"), true);
                }
                this.eatBait();
                this.playSound(SoundEvents.ITEM_BREAK, 1.0f, 0.5f + this.random.nextFloat());
                this.discard();
                return 1;
            }
            this.playSound(SoundEvents.FISHING_BOBBER_THROW, 1.0f, 0.5f + this.random.nextFloat());
        }
        this.lastPulled = this.level().getGameTime();
        if (!this.level().isClientSide && player != null && !this.shouldStopFishing(player)) {
            if (this.hookedIn != null) {
                this.pullEntity(this.hookedIn);
                if (this.hookedIn instanceof AbstractFish) {
                    player.awardStat(Stats.FISH_CAUGHT, 1);
                }
                TFCAdvancements.HOOKED_ENTITY.trigger((ServerPlayer)player, this.hookedIn);
                this.level().broadcastEntityEvent((Entity)this, (byte)31);
            }
            if (this.hookedIn == null || this.hookedIn.isRemoved()) {
                this.discard();
            }
            return this.onGround() ? 2 : 1;
        }
        return 0;
    }

    public void writeSpawnData(RegistryFriendlyByteBuf buffer) {
        Entity owner = this.getOwner();
        buffer.writeVarInt(owner == null ? this.getId() : owner.getId());
    }

    public void readSpawnData(RegistryFriendlyByteBuf additionalData) {
        int id = additionalData.readVarInt();
        Entity entity = this.level().getEntity(id);
        if (entity != null) {
            this.setOwner(entity);
        }
        if (this.getPlayerOwner() == null) {
            TerraFirmaCraft.LOGGER.error("Failed to recreate fishing hook on client. {} (id: {}) is not a valid owner.", (Object)this.level().getEntity(id), (Object)id);
            this.kill();
        }
    }

    protected void pullEntity(Entity entity) {
        Entity owner = this.getOwner();
        if (owner != null) {
            double dx = owner.getX() - this.getX();
            double dy = owner.getY() - this.getY();
            double dz = owner.getZ() - this.getZ();
            if (dy > 0.0 && dx < 5.0 && dz < 5.0) {
                dy = 4.0;
            }
            entity.setDeltaMovement(new Vec3(dx, dy, dz).normalize().scale((double)this.strength));
        }
    }

    public void addAdditionalSaveData(CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        tag.putLong("lastPulled", this.lastPulled);
        tag.putInt("exhaustion", this.pullExhaustion);
        tag.putFloat("strength", this.strength);
    }

    public void readAdditionalSaveData(CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        this.lastPulled = tag.getLong("lastPulled");
        this.pullExhaustion = tag.getInt("exhaustion");
        this.strength = tag.getFloat("strength");
    }

    public void eatBait() {
        Player owner = this.getPlayerOwner();
        if (owner != null) {
            ItemStack main = owner.getMainHandItem();
            ItemStack off = owner.getOffhandItem();
            ItemStack use = ItemStack.EMPTY;
            if (main.getItem() instanceof TFCFishingRodItem) {
                use = main;
            } else if (off.getItem() instanceof TFCFishingRodItem) {
                use = off;
            }
            if (!use.isEmpty()) {
                use.remove(TFCComponents.BAIT);
            }
            this.playSound(SoundEvents.GENERIC_EAT, 1.0f, 1.0f);
        }
    }
}

