/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.entities.predator;

import com.mojang.serialization.Dynamic;
import java.util.function.Supplier;
import net.dries007.tfc.client.TFCSounds;
import net.dries007.tfc.client.particle.TFCParticles;
import net.dries007.tfc.common.effect.TFCEffects;
import net.dries007.tfc.common.entities.ai.TFCBrain;
import net.dries007.tfc.common.entities.ai.predator.PredatorAi;
import net.dries007.tfc.common.entities.prey.WildAnimal;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.schedule.Activity;
import net.minecraft.world.entity.schedule.Schedule;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import org.jetbrains.annotations.Nullable;

public class Predator
extends WildAnimal {
    public static final EntityDataAccessor<Boolean> DATA_SLEEPING = SynchedEntityData.defineId(Predator.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public final AnimationState sleepingAnimation = new AnimationState();
    public final AnimationState attackingAnimation = new AnimationState();
    private final Supplier<SoundEvent> attack;
    private final Supplier<SoundEvent> sleeping;
    public final boolean diurnal;

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.createMonsterAttributes().add(Attributes.MAX_HEALTH, 40.0).add(Attributes.MOVEMENT_SPEED, (double)0.3f).add(Attributes.ATTACK_KNOCKBACK, 1.0).add(Attributes.ATTACK_DAMAGE, 6.0).add(Attributes.STEP_HEIGHT, 1.0);
    }

    public static AttributeSupplier.Builder createBearAttributes() {
        return Monster.createMonsterAttributes().add(Attributes.MAX_HEALTH, 40.0).add(Attributes.MOVEMENT_SPEED, (double)0.3f).add(Attributes.ATTACK_KNOCKBACK, 1.0).add(Attributes.ATTACK_DAMAGE, 6.0).add(Attributes.KNOCKBACK_RESISTANCE, 0.8).add(Attributes.STEP_HEIGHT, 1.0);
    }

    public static Predator createBear(EntityType<? extends Predator> type, Level level) {
        return new Predator(type, level, true, TFCSounds.BEAR);
    }

    public Predator(EntityType<? extends Predator> type, Level level, boolean diurnal, TFCSounds.EntityId sounds) {
        super(type, level, sounds);
        this.diurnal = diurnal;
        this.getBrain().setSchedule(diurnal ? (Schedule)TFCBrain.DIURNAL.get() : (Schedule)TFCBrain.NOCTURNAL.get());
        this.attack = sounds.attack().orElseThrow();
        this.sleeping = sounds.sleep().orElseThrow();
    }

    public boolean isDiurnal() {
        return this.diurnal;
    }

    protected Brain.Provider<? extends Predator> brainProvider() {
        return Brain.provider(PredatorAi.MEMORY_TYPES, PredatorAi.SENSOR_TYPES);
    }

    protected Brain<?> makeBrain(Dynamic<?> dynamic) {
        return PredatorAi.makeBrain((Brain<? extends Predator>)this.brainProvider().makeBrain(dynamic), this);
    }

    protected void customServerAiStep() {
        this.getBrain().tick((ServerLevel)this.level(), (LivingEntity)this);
        PredatorAi.updateActivity(this);
    }

    public Brain<Predator> getBrain() {
        return super.getBrain();
    }

    @Override
    public void tick() {
        if (this.level().isClientSide) {
            this.tickAnimationStates();
        }
        super.tick();
    }

    public void tickAnimationStates() {
        if (this.isSleeping()) {
            if (this.getRandom().nextInt(10) == 0) {
                this.level().addParticle((ParticleOptions)TFCParticles.SLEEP.get(), this.getX(), this.getY() + (double)this.getEyeHeight(), this.getZ(), 0.01, 0.05, 0.01);
            }
            this.sleepingAnimation.startIfStopped(this.tickCount);
        } else {
            this.sleepingAnimation.stop();
        }
    }

    public boolean hurt(DamageSource source, float amount) {
        Entity entity;
        boolean hurt = super.hurt(source, amount);
        if (!this.level().isClientSide && (entity = source.getDirectEntity()) instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            if (this.isAlive() && EntitySelector.NO_CREATIVE_OR_SPECTATOR.test(livingEntity)) {
                this.brain.setMemory(MemoryModuleType.ATTACK_TARGET, (Object)livingEntity);
            }
        }
        if (!this.level().isClientSide && this.isAlive()) {
            this.brain.eraseMemory(MemoryModuleType.CANT_REACH_WALK_TARGET_SINCE);
            this.brain.eraseMemory(MemoryModuleType.HUNTED_RECENTLY);
            this.brain.eraseMemory(MemoryModuleType.PACIFIED);
            this.brain.setActiveActivityIfPossible(Activity.FIGHT);
            this.setSleeping(false);
        }
        return hurt;
    }

    public boolean doHurtTarget(Entity target) {
        return this.doHurtTarget(target, 5);
    }

    public boolean doHurtTarget(Entity target, int pinChance) {
        boolean hurt = super.doHurtTarget(target);
        this.level().broadcastEntityEvent((Entity)this, (byte)4);
        this.playSound(this.getAttackSound(), 1.0f, this.getVoicePitch());
        if (pinChance > 0 && hurt && target instanceof Player) {
            Player player = (Player)target;
            if (this.random.nextInt(pinChance) == 0 && player.getAttributeValue(Attributes.KNOCKBACK_RESISTANCE) <= 0.0) {
                this.pinPlayer(player);
            }
        }
        return hurt;
    }

    @Override
    public void addAdditionalSaveData(CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        tag.putBoolean("sleeping", this.isSleeping());
    }

    @Override
    public void readAdditionalSaveData(CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        this.setSleeping(tag.getBoolean("sleeping"));
    }

    public void handleEntityEvent(byte id) {
        if (id == 4) {
            this.attackingAnimation.start(this.tickCount);
            this.playSound(this.getAttackSound(), 1.0f, this.getVoicePitch());
        }
        super.handleEntityEvent(id);
    }

    @Override
    @Nullable
    public SpawnGroupData finalizeSpawn(ServerLevelAccessor level, DifficultyInstance difficulty, MobSpawnType spawnType, @Nullable SpawnGroupData spawnData) {
        spawnData = super.finalizeSpawn(level, difficulty, spawnType, spawnData);
        this.getBrain().setMemory(MemoryModuleType.HOME, (Object)GlobalPos.of((ResourceKey)level.getLevel().dimension(), (BlockPos)this.blockPosition()));
        return spawnData;
    }

    @Override
    public void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(DATA_SLEEPING, (Object)false);
    }

    public boolean isSleeping() {
        return (Boolean)this.entityData.get(DATA_SLEEPING);
    }

    public void setSleeping(boolean asleep) {
        this.entityData.set(DATA_SLEEPING, (Object)asleep);
    }

    public SoundEvent getAttackSound() {
        return this.attack.get();
    }

    protected SoundEvent getAmbientSound() {
        return this.isSleeping() ? this.sleeping.get() : super.getAmbientSound();
    }

    protected void onOffspringSpawnedFromEgg(Player player, Mob offspring) {
        super.onOffspringSpawnedFromEgg(player, offspring);
        if (offspring instanceof Predator) {
            Predator predator = (Predator)offspring;
            predator.getBrain().setMemory(MemoryModuleType.HOME, (Object)GlobalPos.of((ResourceKey)this.level().dimension(), (BlockPos)PredatorAi.getHomePos((LivingEntity)this)));
        }
    }

    public boolean pinPlayer(Player player) {
        if (this.distanceToSqr((Entity)player) < 6.0) {
            if (!player.level().isClientSide) {
                player.addEffect(new MobEffectInstance(TFCEffects.PINNED.holder(), 35, 0, false, false));
            }
            return true;
        }
        return false;
    }
}

