/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.entities.prey;

import com.mojang.serialization.Dynamic;
import java.util.Collection;
import java.util.Optional;
import net.dries007.tfc.common.TFCTags;
import net.dries007.tfc.common.component.food.FoodCapability;
import net.dries007.tfc.common.entities.BrainAnimalBehavior;
import net.dries007.tfc.common.entities.TFCEntities;
import net.dries007.tfc.common.entities.Temptable;
import net.dries007.tfc.common.entities.prey.TFCFrogAi;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.calendar.Calendars;
import net.dries007.tfc.world.chunkdata.ChunkData;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.stats.Stats;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.FrogVariant;
import net.minecraft.world.entity.animal.frog.Frog;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import org.jetbrains.annotations.Nullable;

public class TFCFrog
extends Frog
implements Temptable,
BrainAnimalBehavior {
    public static final EntityDataAccessor<Boolean> DATA_IS_MALE = SynchedEntityData.defineId(TFCFrog.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public static final EntityDataAccessor<Float> DATA_FAMILIARITY = SynchedEntityData.defineId(TFCFrog.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private long lastMated = Long.MIN_VALUE;
    private long nextFeedTime = Long.MIN_VALUE;

    public TFCFrog(EntityType<? extends Frog> type, Level level) {
        super(type, level);
    }

    protected Brain.Provider<Frog> brainProvider() {
        return Brain.provider((Collection)MEMORY_TYPES, TFCFrogAi.SENSOR_TYPES);
    }

    protected Brain<?> makeBrain(Dynamic<?> dynamic) {
        return TFCFrogAi.makeBrain((Brain<? extends Frog>)super.makeBrain(dynamic));
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(DATA_IS_MALE, (Object)true);
        builder.define(DATA_FAMILIARITY, (Object)Float.valueOf(0.0f));
    }

    public void readAdditionalSaveData(CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        this.setFamiliarity(tag.getFloat("familiarity"));
        this.setIsMale(tag.getBoolean("male"));
        this.lastMated = tag.getLong("lastMated");
        this.nextFeedTime = tag.getLong("nextFeed");
    }

    public void addAdditionalSaveData(CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        tag.putBoolean("male", this.isMale());
        tag.putFloat("familiarity", this.getFamiliarity());
        tag.putLong("lastMated", this.lastMated);
        tag.putLong("nextFeed", this.nextFeedTime);
    }

    public float getFamiliarity() {
        return ((Float)this.entityData.get(DATA_FAMILIARITY)).floatValue();
    }

    public void setFamiliarity(float familiarity) {
        this.entityData.set(DATA_FAMILIARITY, (Object)Float.valueOf(familiarity));
    }

    public void setIsMale(boolean male) {
        this.entityData.set(DATA_IS_MALE, (Object)male);
    }

    @Override
    public boolean isMale() {
        return (Boolean)this.entityData.get(DATA_IS_MALE);
    }

    @Override
    public void setLastMatedNow() {
        this.lastMated = Calendars.get((LevelReader)this.level()).getTicks();
    }

    public boolean canMate(Animal animal) {
        if (animal != this && animal instanceof TFCFrog) {
            TFCFrog other = (TFCFrog)animal;
            float min = 0.3f;
            return other.isMale() != this.isMale() && this.beenLongEnoughToMate() && other.beenLongEnoughToMate() && this.getFamiliarity() > 0.3f && other.getFamiliarity() > 0.3f && this.fedRecently() && other.fedRecently();
        }
        return false;
    }

    protected boolean beenLongEnoughToMate() {
        return Calendars.get((LevelReader)this.level()).getTicks() > this.lastMated + 288000L;
    }

    @Override
    public boolean isFood(ItemStack stack) {
        return !FoodCapability.isRotten(stack) && Helpers.isItem(stack, TFCTags.Items.FROG_FOOD);
    }

    @Nullable
    public SpawnGroupData finalizeSpawn(ServerLevelAccessor level, DifficultyInstance difficulty, MobSpawnType spawnType, @Nullable SpawnGroupData spawnData) {
        spawnData = super.finalizeSpawn(level, difficulty, spawnType, spawnData);
        BlockPos pos = this.blockPosition();
        ChunkData data = ChunkData.get((LevelReader)level, pos);
        float temp = data.getAverageSeaLevelTemp(pos);
        this.setVariant((Holder)BuiltInRegistries.FROG_VARIANT.getHolderOrThrow(temp < 0.0f ? FrogVariant.COLD : (temp > 18.0f ? FrogVariant.WARM : FrogVariant.TEMPERATE)));
        this.setIsMale(this.random.nextBoolean());
        return spawnData;
    }

    @Nullable
    public AgeableMob getBreedOffspring(ServerLevel level, AgeableMob mob) {
        if (mob == this) {
            TFCFrog frog = (TFCFrog)((EntityType)TFCEntities.FROG.get()).create((Level)level);
            if (frog != null) {
                frog.getBrain().setMemory(MemoryModuleType.LONG_JUMP_COOLDOWN_TICKS, (Object)UniformInt.of((int)100, (int)140).sample(this.random));
            }
            return frog;
        }
        if (mob instanceof TFCFrog) {
            TFCFrog animal = (TFCFrog)mob;
            this.spawnChildFromBreeding(level, (Animal)animal);
        }
        return null;
    }

    public void finalizeSpawnChildFromBreeding(ServerLevel level, Animal animal, @Nullable AgeableMob mob) {
        Optional.ofNullable(this.getLoveCause()).or(() -> Optional.ofNullable(animal.getLoveCause())).ifPresent(player -> {
            player.awardStat(Stats.ANIMALS_BRED);
            CriteriaTriggers.BRED_ANIMALS.trigger(player, (Animal)this, animal, mob);
        });
        this.resetLove();
        animal.resetLove();
        level.broadcastEntityEvent((Entity)this, (byte)18);
    }

    public InteractionResult mobInteract(Player player, InteractionHand hand) {
        ItemStack held = player.getItemInHand(hand);
        if (this.isFood(held)) {
            long ticks;
            if (!this.level().isClientSide && (ticks = Calendars.SERVER.getTicks()) > this.nextFeedTime) {
                this.setFamiliarity(this.getFamiliarity() + 0.1f);
                this.nextFeedTime = ticks + 24000L;
                this.usePlayerItem(player, hand, held);
                this.playSound(SoundEvents.FROG_EAT);
            }
            return InteractionResult.sidedSuccess((boolean)this.level().isClientSide);
        }
        return super.mobInteract(player, hand);
    }

    private boolean fedRecently() {
        return Calendars.get((LevelReader)this.level()).getTicks() < this.nextFeedTime;
    }
}

