/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.entities.prey;

import java.util.function.Predicate;
import net.dries007.tfc.common.TFCTags;
import net.dries007.tfc.common.entities.EntityHelpers;
import net.dries007.tfc.common.entities.ai.TFCAvoidEntityGoal;
import net.dries007.tfc.common.entities.ai.TFCGroundPathNavigation;
import net.dries007.tfc.common.entities.livestock.Age;
import net.dries007.tfc.common.entities.livestock.CommonAnimalData;
import net.dries007.tfc.common.entities.livestock.MammalProperties;
import net.dries007.tfc.common.entities.livestock.TFCAnimalProperties;
import net.dries007.tfc.config.animals.AnimalConfig;
import net.dries007.tfc.config.animals.MammalConfig;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.world.chunkdata.ChunkData;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.TagKey;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MoveToBlockGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.Rabbit;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.event.EventHooks;
import org.jetbrains.annotations.Nullable;

public class TFCRabbit
extends Rabbit
implements MammalProperties {
    private static final CommonAnimalData ANIMAL_DATA = CommonAnimalData.create(TFCRabbit.class);
    private static final EntityDataAccessor<Long> PREGNANT_TIME = SynchedEntityData.defineId(TFCRabbit.class, (EntityDataSerializer)EntityDataSerializers.LONG);
    @Nullable
    private CompoundTag genes;
    private final AnimalConfig config;
    private final MammalConfig mammalConfig;
    private int moreCarrotTicks;

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.createMobAttributes().add(Attributes.MAX_HEALTH, 12.0).add(Attributes.MOVEMENT_SPEED, (double)0.3f).add(Attributes.ATTACK_DAMAGE, 3.0);
    }

    public TFCRabbit(EntityType<? extends Rabbit> type, Level level, MammalConfig config) {
        super(type, level);
        this.config = config.inner();
        this.mammalConfig = config;
    }

    public void customServerAiStep() {
        super.customServerAiStep();
        if (this.moreCarrotTicks > 0) {
            this.moreCarrotTicks -= this.random.nextInt(3);
            if (this.moreCarrotTicks < 0) {
                this.moreCarrotTicks = 0;
            }
        }
    }

    protected void registerGoals() {
        super.registerGoals();
        EntityHelpers.removeGoalOfPriority(this.goalSelector, 3);
        EntityHelpers.removeGoalOfPriority(this.goalSelector, 4);
        EntityHelpers.removeGoalOfPriority(this.goalSelector, 5);
        this.goalSelector.addGoal(3, (Goal)new TemptGoal((PathfinderMob)this, 1.25, (Predicate)Ingredient.of(this.getFoodTag()), false));
        this.goalSelector.addGoal(4, new TFCAvoidEntityGoal<PathfinderMob>((PathfinderMob)this, PathfinderMob.class, 8.0f, 2.2, 2.2, TFCTags.Entities.HUNTS_LAND_PREY));
        this.goalSelector.addGoal(5, (Goal)new RaidGardenGoal(this));
    }

    protected float getJumpPower() {
        return 0.42f * this.getBlockJumpFactor() + this.getJumpBoostPower();
    }

    public void jumpFromGround() {
        super.jumpFromGround();
        if (this.getDeltaMovement().x == 0.0 || this.getDeltaMovement().z == 0.0) {
            Vec3 wanted = new Vec3(this.moveControl.getWantedX(), this.moveControl.getWantedY(), this.moveControl.getWantedZ());
            Vec3 delta = wanted.subtract(this.position()).normalize().scale(0.1);
            this.setDeltaMovement(this.getDeltaMovement().add(delta));
        }
    }

    @Nullable
    public TFCRabbit getBreedOffspring(ServerLevel level, AgeableMob other) {
        TFCRabbit rabbit;
        AgeableMob mob = MammalProperties.super.getBreedOffspring(level, other);
        return mob instanceof TFCRabbit ? (rabbit = (TFCRabbit)mob) : null;
    }

    @Override
    public void createGenes(CompoundTag tag, TFCAnimalProperties male) {
        MammalProperties.super.createGenes(tag, male);
        tag.putString("variant1", this.getVariant().getSerializedName());
        if (male instanceof TFCRabbit) {
            TFCRabbit rabbit = (TFCRabbit)male;
            tag.putString("variant2", rabbit.getVariant().getSerializedName());
        }
    }

    @Override
    public void applyGenes(CompoundTag tag, MammalProperties baby) {
        MammalProperties.super.applyGenes(tag, baby);
        if (baby instanceof TFCRabbit) {
            TFCRabbit rabbit = (TFCRabbit)baby;
            if (tag.contains("variant2", 3) && this.random.nextInt(10) != 0) {
                rabbit.setVariant(Rabbit.Variant.byId((int)(this.random.nextBoolean() ? tag.getInt("variant1") : tag.getInt("variant2"))));
            } else {
                Level level = this.level();
                if (level instanceof ServerLevelAccessor) {
                    ServerLevelAccessor server = (ServerLevelAccessor)level;
                    rabbit.setVariant(this.getRandomRabbitType(server, this.blockPosition()));
                }
            }
        }
    }

    @Override
    public TagKey<Item> getFoodTag() {
        return TFCTags.Items.RABBIT_FOOD;
    }

    public boolean canMate(Animal otherAnimal) {
        if (otherAnimal.getClass() != this.getClass()) {
            return false;
        }
        TFCRabbit other = (TFCRabbit)otherAnimal;
        return this.getGender() != other.getGender() && this.isReadyToMate() && other.isReadyToMate();
    }

    @Nullable
    public SpawnGroupData finalizeSpawn(ServerLevelAccessor level, DifficultyInstance difficulty, MobSpawnType spawnType, @Nullable SpawnGroupData spawnData) {
        spawnData = super.finalizeSpawn(level, difficulty, spawnType, spawnData);
        if (spawnType != MobSpawnType.BREEDING) {
            this.initCommonAnimalData(level, difficulty, spawnType);
            this.setVariant(this.getRandomRabbitType(level, this.blockPosition()));
        }
        this.setPregnantTime(-1L);
        return spawnData;
    }

    @Override
    public MammalConfig getMammalConfig() {
        return this.mammalConfig;
    }

    @Override
    public long getPregnantTime() {
        return (Long)this.entityData.get(PREGNANT_TIME);
    }

    @Override
    public void setPregnantTime(long day) {
        this.entityData.set(PREGNANT_TIME, (Object)day);
    }

    @Override
    public void setGenes(@Nullable CompoundTag tag) {
        this.genes = tag;
    }

    @Override
    @Nullable
    public CompoundTag getGenes() {
        return this.genes;
    }

    @Override
    public AnimalConfig animalConfig() {
        return this.config;
    }

    @Override
    public CommonAnimalData animalData() {
        return ANIMAL_DATA;
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        this.animalData().define(builder);
        builder.define(PREGNANT_TIME, (Object)-1L);
    }

    public void addAdditionalSaveData(CompoundTag nbt) {
        super.addAdditionalSaveData(nbt);
        this.saveCommonAnimalData(nbt);
        nbt.putInt("TFCMoreCarrotTicks", this.moreCarrotTicks);
    }

    public void readAdditionalSaveData(CompoundTag nbt) {
        super.readAdditionalSaveData(nbt);
        this.readCommonAnimalData(nbt);
        this.moreCarrotTicks = nbt.getInt("TFCMoreCarrotTicks");
    }

    public boolean isBaby() {
        return this.getAgeType() == Age.CHILD;
    }

    public void setAge(int age) {
        super.setAge(0);
    }

    public int getAge() {
        return this.isBaby() ? -24000 : 0;
    }

    public void onSyncedDataUpdated(EntityDataAccessor<?> data) {
        super.onSyncedDataUpdated(data);
        if (ANIMAL_DATA.birthTick().equals(data)) {
            this.refreshDimensions();
        }
    }

    public void tick() {
        super.tick();
        if (this.level().getGameTime() % 20L == 0L) {
            if (!this.getEntity().level().isClientSide() && this.isMale() && this.isReadyToMate()) {
                EntityHelpers.findFemaleMate(this);
            }
            this.tickAnimalData();
        }
    }

    @Override
    public boolean isFood(ItemStack stack) {
        return MammalProperties.super.isFood(stack);
    }

    public Component getTypeName() {
        return this.getGenderedTypeName();
    }

    public float getWalkTargetValue(BlockPos pos, LevelReader level) {
        return level.getBlockState(pos.below()).is(TFCTags.Blocks.BUSH_PLANTABLE_ON) ? 10.0f : level.getPathfindingCostFromLightLevels(pos);
    }

    public PathNavigation createNavigation(Level level) {
        return new TFCGroundPathNavigation((Mob)this, level);
    }

    public boolean isInWall() {
        return !this.level().isClientSide && super.isInWall();
    }

    protected void pushEntities() {
        if (!this.level().isClientSide) {
            super.pushEntities();
        }
    }

    @Override
    public InteractionResult mobInteract(Player player, InteractionHand hand) {
        InteractionResult result = MammalProperties.super.mobInteract(player, hand);
        return result == InteractionResult.PASS ? super.mobInteract(player, hand) : result;
    }

    private Rabbit.Variant getRandomRabbitType(ServerLevelAccessor level, BlockPos pos) {
        int i = this.random.nextInt(100);
        ChunkData data = ChunkData.get((LevelReader)level, pos);
        float rain = data.getRainfall(pos);
        float temp = data.getAverageSeaLevelTemp(pos);
        if (temp < 0.0f) {
            return i < 80 ? Rabbit.Variant.WHITE : Rabbit.Variant.WHITE_SPLOTCHED;
        }
        if (rain < 125.0f) {
            return Rabbit.Variant.GOLD;
        }
        return i < 50 ? Rabbit.Variant.BROWN : (i < 90 ? Rabbit.Variant.SALT : Rabbit.Variant.BLACK);
    }

    public boolean wantsMoreFood() {
        return this.moreCarrotTicks == 0;
    }

    public static class RaidGardenGoal
    extends MoveToBlockGoal {
        private final TFCRabbit rabbit;
        private boolean wantsToRaid;
        private boolean canRaid;

        public RaidGardenGoal(TFCRabbit rabbit) {
            super((PathfinderMob)rabbit, (double)0.7f, 16);
            this.rabbit = rabbit;
        }

        public boolean canUse() {
            if (this.nextStartTick <= 0) {
                if (!EventHooks.canEntityGrief((Level)this.rabbit.level(), (Entity)this.rabbit)) {
                    return false;
                }
                this.canRaid = false;
                this.wantsToRaid = this.rabbit.wantsMoreFood();
            }
            return super.canUse();
        }

        public boolean canContinueToUse() {
            return this.canRaid && super.canContinueToUse();
        }

        public void tick() {
            super.tick();
            this.rabbit.getLookControl().setLookAt((double)this.blockPos.getX() + 0.5, (double)(this.blockPos.getY() + 1), (double)this.blockPos.getZ() + 0.5, 10.0f, (float)this.rabbit.getMaxHeadXRot());
            if (this.isReachedTarget()) {
                Level level = this.rabbit.level();
                BlockPos abovePos = this.blockPos.above();
                BlockState aboveState = level.getBlockState(abovePos);
                Block aboveBlock = aboveState.getBlock();
                if (this.canRaid && Helpers.isBlock(aboveBlock, TFCTags.Blocks.RABBIT_RAIDABLE)) {
                    level.setBlock(abovePos, Blocks.AIR.defaultBlockState(), 2);
                    level.destroyBlock(abovePos, true, (Entity)this.rabbit);
                    this.rabbit.moreCarrotTicks = 40;
                }
                this.canRaid = false;
                this.nextStartTick = 10;
            }
        }

        protected boolean isValidTarget(LevelReader level, BlockPos pos) {
            BlockState state = level.getBlockState(pos);
            if (Helpers.isBlock(state, TFCTags.Blocks.FARMLANDS) && this.wantsToRaid && !this.canRaid && Helpers.isBlock(state = level.getBlockState(pos.above()), TFCTags.Blocks.RABBIT_RAIDABLE)) {
                this.canRaid = true;
                return true;
            }
            return false;
        }
    }
}

