/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.entities.prey;

import net.dries007.tfc.client.TFCSounds;
import net.dries007.tfc.common.entities.EntityHelpers;
import net.dries007.tfc.common.entities.Pluckable;
import net.dries007.tfc.common.entities.prey.Prey;
import net.dries007.tfc.common.entities.prey.WildAnimal;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class WingedPrey
extends Prey
implements Pluckable {
    public float flapping = 1.0f;
    public float oFlap;
    public float flap;
    public float oFlapSpeed;
    public float flapSpeed;
    private float nextFlap = 1.0f;
    private long lastPlucked = Long.MIN_VALUE;

    public WingedPrey(EntityType<? extends Prey> type, Level level, TFCSounds.EntityId sounds) {
        super((EntityType<? extends WildAnimal>)type, level, sounds);
    }

    @Override
    public void readAdditionalSaveData(CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        EntityHelpers.getLongOrDefault(tag, "plucked", Long.MIN_VALUE);
    }

    @Override
    public void addAdditionalSaveData(CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        tag.putLong("plucked", this.lastPlucked);
    }

    @Override
    public long getLastPluckedTick() {
        return this.lastPlucked;
    }

    @Override
    public void setLastPluckedTick(long tick) {
        this.lastPlucked = tick;
    }

    protected boolean isFlapping() {
        return this.flyDist > this.nextFlap;
    }

    protected void onFlap() {
        this.nextFlap = this.flyDist + this.flapSpeed / 2.0f;
    }

    public void aiStep() {
        super.aiStep();
        this.oFlap = this.flap;
        this.oFlapSpeed = this.flapSpeed;
        this.flapSpeed += (this.onGround() ? -1.0f : 4.0f) * 0.3f;
        this.flapSpeed = Mth.clamp((float)this.flapSpeed, (float)0.0f, (float)1.0f);
        if (this.isPassenger()) {
            this.flapSpeed = 0.0f;
        }
        if (!this.onGround() && this.flapping < 1.0f) {
            this.flapping = 1.0f;
        }
        this.flapping *= 0.9f;
        Vec3 move = this.getDeltaMovement();
        if (!this.onGround() && move.y < 0.0) {
            this.setDeltaMovement(move.multiply(1.0, 0.6, 1.0));
        }
        this.flap += this.flapping * 2.0f;
    }

    public boolean causeFallDamage(float amount, float speed, DamageSource src) {
        return false;
    }

    public InteractionResult mobInteract(Player player, InteractionHand hand) {
        return this.pluck(player, hand, (LivingEntity)this) ? InteractionResult.sidedSuccess((boolean)this.level().isClientSide) : super.mobInteract(player, hand);
    }
}

