/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.fluids;

import it.unimi.dsi.fastutil.objects.Object2IntArrayMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.function.Consumer;
import net.dries007.tfc.common.TFCTags;
import net.dries007.tfc.common.blocks.TFCBlocks;
import net.dries007.tfc.common.blocks.rock.AqueductBlock;
import net.dries007.tfc.common.component.size.ItemSizeManager;
import net.dries007.tfc.common.fluids.BucketPickupExtension;
import net.dries007.tfc.common.fluids.FlowingFluidExtension;
import net.dries007.tfc.common.fluids.FluidProperty;
import net.dries007.tfc.common.fluids.IFluidLoggable;
import net.dries007.tfc.common.fluids.TFCFluids;
import net.dries007.tfc.mixin.accessor.FlowingFluidAccessor;
import net.dries007.tfc.util.Helpers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BucketPickup;
import net.minecraft.world.level.block.LiquidBlockContainer;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.common.NeoForgeMod;
import net.neoforged.neoforge.common.SoundActions;
import net.neoforged.neoforge.event.EventHooks;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.FluidType;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.capability.IFluidHandlerItem;
import net.neoforged.neoforge.items.ItemHandlerHelper;
import org.jetbrains.annotations.Nullable;

public final class FluidHelpers {
    public static final int BUCKET_VOLUME = 1000;

    public static boolean canFluidExtinguishFire(Fluid fluid) {
        return fluid != Fluids.EMPTY && fluid.getFluidType().getTemperature() < 400;
    }

    public static boolean isInWaterLikeFluid(Entity entity) {
        return entity.isInFluidType((fluidType, value) -> fluidType == TFCFluids.SALT_WATER.type().get() || fluidType == TFCFluids.SPRING_WATER.type().get());
    }

    public static boolean isEyeInWaterLikeFluid(Entity entity) {
        return entity.isEyeInFluidType((FluidType)TFCFluids.SALT_WATER.type().get()) || entity.isEyeInFluidType((FluidType)TFCFluids.SALT_WATER.type().get());
    }

    public static boolean transferBetweenWorldAndItem(ItemStack originalStack, Level level, BlockHitResult target, Player player, InteractionHand hand, boolean allowPlacingAnyLiquidBlocks, boolean allowPlacingSourceBlocks, boolean allowInfiniteSourceFilling) {
        return FluidHelpers.transferBetweenWorldAndItem(originalStack, level, target, FluidHelpers.with(player, hand), allowPlacingAnyLiquidBlocks, allowPlacingSourceBlocks, allowInfiniteSourceFilling);
    }

    public static boolean transferBetweenWorldAndItem(ItemStack originalStack, Level level, BlockHitResult target, AfterTransfer after, boolean allowPlacingAnyLiquidBlocks, boolean allowPlacingSourceBlocks, boolean allowInfiniteSourceFilling) {
        return target.getType() == HitResult.Type.BLOCK && FluidHelpers.transferBetweenWorldAndItem(originalStack, level, target.getBlockPos(), target, after, allowPlacingAnyLiquidBlocks, allowPlacingSourceBlocks, allowInfiniteSourceFilling);
    }

    public static boolean transferBetweenWorldAndItem(ItemStack originalStack, Level level, BlockPos pos, @Nullable BlockHitResult target, AfterTransfer after, boolean allowPlacingAnyLiquidBlocks, boolean allowPlacingSourceBlocks, boolean allowInfiniteSourceFilling) {
        BlockEntity entity;
        BlockState state = level.getBlockState(pos);
        ItemStack stack = originalStack.copyWithCount(1);
        IFluidHandlerItem handler = (IFluidHandlerItem)stack.getCapability(Capabilities.FluidHandler.ITEM);
        if (handler == null) {
            return false;
        }
        FluidStack aggressiveDrained = handler.drain(Integer.MAX_VALUE, IFluidHandler.FluidAction.SIMULATE);
        if (aggressiveDrained.isEmpty()) {
            if (FluidHelpers.pickupFluidInto(level, pos, state, (IFluidHandler)handler, allowInfiniteSourceFilling)) {
                FluidHelpers.updateContainerItem(originalStack, handler, after);
                return true;
            }
        } else if (allowPlacingAnyLiquidBlocks && FluidHelpers.emptyFluidFrom((IFluidHandler)handler, level, pos, state, target, allowPlacingSourceBlocks)) {
            FluidHelpers.updateContainerItem(originalStack, handler, after);
            return true;
        }
        if ((entity = level.getBlockEntity(pos)) != null) {
            return FluidHelpers.transferBetweenBlockEntityAndItem(originalStack, entity, level, pos, after);
        }
        return false;
    }

    public static boolean transferBetweenBlockEntityAndItem(ItemStack originalStack, BlockEntity entity, Player player, InteractionHand hand) {
        return FluidHelpers.transferBetweenBlockEntityAndItem(originalStack, entity, player.level(), player.blockPosition(), FluidHelpers.with(player, hand));
    }

    public static boolean transferBetweenBlockEntityAndItem(ItemStack originalStack, BlockEntity entity, Level level, BlockPos pos, AfterTransfer after) {
        return FluidHelpers.transferBetweenBlockHandlerAndItem(originalStack, (IFluidHandler)Helpers.getCapability(Capabilities.FluidHandler.BLOCK, entity), level, pos, after);
    }

    public static boolean transferBetweenBlockHandlerAndItem(ItemStack originalStack, @Nullable IFluidHandler blockHandler, Level level, BlockPos pos, AfterTransfer after) {
        ItemStack stack = originalStack.copyWithCount(1);
        IFluidHandlerItem itemHandler = (IFluidHandlerItem)stack.getCapability(Capabilities.FluidHandler.ITEM);
        if (itemHandler == null || blockHandler == null) {
            return false;
        }
        FluidStack aggressiveDrained = itemHandler.drain(Integer.MAX_VALUE, IFluidHandler.FluidAction.SIMULATE);
        if (aggressiveDrained.isEmpty()) {
            return FluidHelpers.transferBetweenItemAndOther(originalStack, itemHandler, blockHandler, (IFluidHandler)itemHandler, Transfer.FILL, level, pos, after);
        }
        return FluidHelpers.transferBetweenItemAndOther(originalStack, itemHandler, (IFluidHandler)itemHandler, blockHandler, Transfer.DRAIN, level, pos, after);
    }

    public static boolean transferBetweenItemAndOther(ItemStack originalStack, IFluidHandlerItem itemHandler, IFluidHandler from, IFluidHandler to, Transfer type, Level level, BlockPos pos, AfterTransfer after) {
        return FluidHelpers.transferBetweenItemAndOther(originalStack, itemHandler, from, to, fluid -> FluidHelpers.playTransferSound(level, pos, fluid, type), after);
    }

    public static boolean transferBetweenItemAndOther(ItemStack originalStack, IFluidHandlerItem itemHandler, IFluidHandler from, IFluidHandler to, Consumer<FluidStack> sound, AfterTransfer after) {
        int optimisticFilled;
        FluidStack aggressiveDrained = from.drain(Integer.MAX_VALUE, IFluidHandler.FluidAction.SIMULATE);
        int maximumFilled = to.fill(aggressiveDrained, IFluidHandler.FluidAction.SIMULATE);
        if (maximumFilled <= 0) {
            return false;
        }
        FluidStack optimisticDrained = from.drain(maximumFilled, IFluidHandler.FluidAction.SIMULATE);
        if (optimisticDrained.getAmount() > 0 && (optimisticFilled = to.fill(optimisticDrained, IFluidHandler.FluidAction.SIMULATE)) > 0) {
            to.fill(from.drain(optimisticDrained, IFluidHandler.FluidAction.EXECUTE), IFluidHandler.FluidAction.EXECUTE);
            FluidHelpers.updateContainerItem(originalStack, itemHandler, after);
            sound.accept(optimisticDrained);
            return true;
        }
        to.fill(from.drain(Integer.MAX_VALUE, IFluidHandler.FluidAction.EXECUTE), IFluidHandler.FluidAction.EXECUTE);
        FluidHelpers.updateContainerItem(originalStack, itemHandler, after);
        sound.accept(aggressiveDrained);
        return true;
    }

    public static void updateContainerItem(ItemStack originalStack, IFluidHandlerItem itemHandler, AfterTransfer after) {
        if (originalStack.isEmpty()) {
            after.updateContainerItem(ItemStack.EMPTY);
        } else if (originalStack.getCount() == 1) {
            after.updateContainerItem(itemHandler.getContainer());
        } else {
            originalStack.shrink(1);
            after.updateContainerItem(originalStack, itemHandler.getContainer());
        }
    }

    public static boolean transferExact(IFluidHandler from, IFluidHandler to, int amount) {
        FluidStack drained = from.drain(amount, IFluidHandler.FluidAction.SIMULATE);
        if (drained.getAmount() == amount && to.fill(drained, IFluidHandler.FluidAction.SIMULATE) == amount) {
            to.fill(from.drain(amount, IFluidHandler.FluidAction.EXECUTE), IFluidHandler.FluidAction.EXECUTE);
            return true;
        }
        return false;
    }

    public static boolean pickupFluidInto(Level level, BlockPos pos, BlockState state, IFluidHandler to, boolean allowInfiniteSourceFilling) {
        FluidStack fluid = FluidHelpers.pickupFluid(level, pos, state, IFluidHandler.FluidAction.SIMULATE);
        if (fluid != null && !fluid.isEmpty()) {
            int filled;
            if (allowInfiniteSourceFilling && fluid.getFluid() instanceof FlowingFluid) {
                BlockState queryState = state;
                if (state.getBlock() instanceof AqueductBlock) {
                    queryState = state.getFluidState().createLegacyBlock();
                }
                if (EventHooks.canCreateFluidSource((Level)level, (BlockPos)pos, (BlockState)queryState)) {
                    fluid.setAmount(Integer.MAX_VALUE);
                }
            }
            if ((filled = to.fill(fluid, IFluidHandler.FluidAction.EXECUTE)) > 0) {
                FluidHelpers.pickupFluid(level, pos, state, IFluidHandler.FluidAction.EXECUTE);
                return true;
            }
        }
        return false;
    }

    @Nullable
    public static FluidStack pickupFluid(Level level, BlockPos pos, BlockState state, IFluidHandler.FluidAction action) {
        return FluidHelpers.pickupFluid(level, pos, state, action, fluid -> FluidHelpers.playTransferSound(level, pos, fluid, Transfer.FILL));
    }

    @Nullable
    public static FluidStack pickupFluid(Level level, BlockPos pos, BlockState state, IFluidHandler.FluidAction action, Consumer<FluidStack> sound) {
        Block block = state.getBlock();
        if (block instanceof BucketPickupExtension) {
            BucketPickupExtension pickup = (BucketPickupExtension)block;
            FluidStack fluid = pickup.pickupBlock((LevelAccessor)level, pos, state, action);
            sound.accept(fluid);
            return fluid;
        }
        if (block instanceof BucketPickup) {
            BucketPickup pickup = (BucketPickup)block;
            if (action.execute()) {
                ItemStack stack = pickup.pickupBlock(null, (LevelAccessor)level, pos, state);
                @Nullable IFluidHandler fluidHandler = (IFluidHandler)stack.getCapability(Capabilities.FluidHandler.ITEM);
                FluidStack fluid = fluidHandler != null ? fluidHandler.drain(Integer.MAX_VALUE, IFluidHandler.FluidAction.EXECUTE) : FluidStack.EMPTY;
                sound.accept(fluid);
                return fluid;
            }
            return new FluidStack(state.getFluidState().getType(), 1000);
        }
        return null;
    }

    public static boolean emptyFluidFrom(IFluidHandler handler, Level level, BlockPos pos, BlockState state, @Nullable BlockHitResult hit, boolean allowPlacingSourceBlocks) {
        BlockState toPlace;
        LiquidBlockContainer container;
        boolean willReplace;
        Block block = state.getBlock();
        FluidStack simulatedDrained = handler.drain(Integer.MAX_VALUE, IFluidHandler.FluidAction.SIMULATE);
        Fluid fluid = simulatedDrained.getFluid();
        boolean bl = willReplace = state.isAir() || state.canBeReplaced(fluid) || block instanceof LiquidBlockContainer && (container = (LiquidBlockContainer)block).canPlaceLiquid(null, (BlockGetter)level, pos, state, fluid) && allowPlacingSourceBlocks;
        if (!willReplace) {
            if (hit == null) {
                return false;
            }
            BlockPos relativePos = hit.getBlockPos().relative(hit.getDirection());
            return FluidHelpers.emptyFluidFrom(handler, level, relativePos, level.getBlockState(relativePos), null, allowPlacingSourceBlocks);
        }
        if (fluid.getFluidType().isVaporizedOnPlacement(level, pos, simulatedDrained)) {
            handler.drain(Integer.MAX_VALUE, IFluidHandler.FluidAction.EXECUTE);
            level.playSound(null, pos, SoundEvents.FIRE_EXTINGUISH, SoundSource.BLOCKS, 0.5f, 2.6f + (level.random.nextFloat() - level.random.nextFloat()) * 0.8f);
            for (int i = 0; i < 8; ++i) {
                level.addParticle((ParticleOptions)ParticleTypes.LARGE_SMOKE, (double)pos.getX() + Math.random(), (double)pos.getY() + Math.random(), (double)pos.getZ() + Math.random(), 0.0, 0.0, 0.0);
            }
            return true;
        }
        if (block instanceof LiquidBlockContainer && (container = (LiquidBlockContainer)block).canPlaceLiquid(null, (BlockGetter)level, pos, state, fluid) && simulatedDrained.getAmount() >= 1000) {
            if (allowPlacingSourceBlocks) {
                container.placeLiquid((LevelAccessor)level, pos, state, fluid.defaultFluidState());
                handler.drain(Integer.MAX_VALUE, IFluidHandler.FluidAction.EXECUTE);
                FluidHelpers.playTransferSound(level, pos, simulatedDrained, Transfer.DRAIN);
                return true;
            }
            return false;
        }
        if (allowPlacingSourceBlocks && simulatedDrained.getAmount() >= 1000) {
            toPlace = fluid.defaultFluidState().createLegacyBlock();
        } else if (state.getFluidState().getType() == fluid) {
            toPlace = state;
        } else if (fluid instanceof FlowingFluid) {
            FlowingFluid flowing = (FlowingFluid)fluid;
            toPlace = flowing.getFlowing(1, false).createLegacyBlock();
        } else {
            return false;
        }
        if (state.getBlock() != toPlace.getBlock()) {
            if (!level.isClientSide && state.canBeReplaced(fluid) && !state.liquid()) {
                level.destroyBlock(pos, true);
            }
            level.setBlock(pos, toPlace, 3);
        }
        handler.drain(Integer.MAX_VALUE, IFluidHandler.FluidAction.EXECUTE);
        FluidHelpers.playTransferSound(level, pos, simulatedDrained, Transfer.DRAIN);
        return true;
    }

    public static void playTransferSound(Level level, BlockPos pos, FluidStack stack, Transfer type) {
        FluidType fluidType;
        SoundEvent sound;
        if (stack.getFluid() == NeoForgeMod.MILK.get()) {
            stack = new FluidStack((Fluid)Fluids.WATER, stack.getAmount());
        }
        if ((sound = (fluidType = stack.getFluid().getFluidType()).getSound(stack, type == Transfer.FILL ? SoundActions.BUCKET_FILL : SoundActions.BUCKET_EMPTY)) != null) {
            level.playSound(null, (double)pos.getX(), (double)pos.getY() + 0.5, (double)pos.getZ(), sound, SoundSource.BLOCKS, 1.0f, 1.0f);
        }
    }

    public static boolean isAirOrEmptyFluid(BlockState state) {
        return state.isAir() || state.getBlock() == state.getFluidState().getType().defaultFluidState().createLegacyBlock().getBlock();
    }

    public static boolean isEmptyFluid(BlockState state) {
        return !state.getFluidState().isEmpty() && state.getBlock() == state.getFluidState().getType().defaultFluidState().createLegacyBlock().getBlock();
    }

    @Nullable
    public static BlockState fillWithFluid(BlockState state, Fluid fluid) {
        FlowingFluid flowing;
        if (state.getFluidState().getType() == fluid) {
            return state;
        }
        if (state.isAir()) {
            return fluid.defaultFluidState().createLegacyBlock();
        }
        if (fluid instanceof FlowingFluid && (flowing = (FlowingFluid)fluid).isSame(state.getFluidState().getType())) {
            return fluid.defaultFluidState().createLegacyBlock();
        }
        Block block = state.getBlock();
        if (block instanceof IFluidLoggable) {
            IFluidLoggable fluidBlock = (IFluidLoggable)block;
            FluidProperty property = fluidBlock.getFluidProperty();
            if (property.canContain(fluid)) {
                return (BlockState)state.setValue((Property)property, (Comparable)property.keyFor(fluid));
            }
        } else if (state.hasProperty((Property)BlockStateProperties.WATERLOGGED)) {
            if (fluid == Fluids.WATER) {
                return (BlockState)state.setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(true));
            }
            if (fluid == Fluids.EMPTY) {
                return (BlockState)state.setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(false));
            }
        }
        return null;
    }

    public static BlockState emptyFluidFrom(BlockState state) {
        Block block;
        if (state.hasProperty((Property)BlockStateProperties.WATERLOGGED)) {
            state = (BlockState)state.setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(false));
        }
        if ((block = state.getBlock()) instanceof IFluidLoggable) {
            IFluidLoggable fluidBlock = (IFluidLoggable)block;
            FluidProperty property = fluidBlock.getFluidProperty();
            state = (BlockState)state.setValue((Property)property, (Comparable)property.keyFor(Fluids.EMPTY));
        }
        if (FluidHelpers.isAirOrEmptyFluid(state)) {
            state = Blocks.AIR.defaultBlockState();
        }
        if (FluidHelpers.isMeltableIce(state)) {
            state = Blocks.AIR.defaultBlockState();
        }
        return state;
    }

    public static FluidStack getContainedFluid(ItemStack stack) {
        @Nullable IFluidHandlerItem handler = (IFluidHandlerItem)stack.getCapability(Capabilities.FluidHandler.ITEM);
        return handler != null ? handler.drain(Integer.MAX_VALUE, IFluidHandler.FluidAction.SIMULATE) : FluidStack.EMPTY;
    }

    public static FluidStack getContainedFluidInTank(ItemStack stack) {
        @Nullable IFluidHandlerItem handler = (IFluidHandlerItem)stack.getCapability(Capabilities.FluidHandler.ITEM);
        return handler != null ? handler.getFluidInTank(0) : FluidStack.EMPTY;
    }

    public static boolean isMeltableIce(BlockState state) {
        return state.getBlock() == Blocks.ICE || state.getBlock() == TFCBlocks.SEA_ICE.get() || state.getBlock() == TFCBlocks.ICE_PILE.get();
    }

    public static boolean isSame(FluidState state, Fluid expected) {
        return state.getType().isSame(expected);
    }

    public static boolean canMixFluids(Fluid left, Fluid right) {
        return FluidHelpers.canMixFluids(left) && FluidHelpers.canMixFluids(right);
    }

    public static boolean canMixFluids(Fluid fluid) {
        return fluid instanceof FlowingFluid && Helpers.isFluid(fluid, TFCTags.Fluids.MIXABLE);
    }

    public static FluidState getNewFluidWithMixing(FlowingFluid self, Level level, BlockPos pos, BlockState blockStateIn, int dropOff) {
        BlockPos abovePos;
        BlockState aboveState;
        FluidState aboveFluid;
        BlockState offsetState;
        int maxAdjacentFluidAmount = 0;
        FlowingFluid maxAdjacentFluid = self;
        int adjacentSourceBlocks = 0;
        Object2IntArrayMap adjacentSourceBlocksByFluid = new Object2IntArrayMap(2);
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            BlockPos offsetPos = pos.relative(direction);
            offsetState = level.getBlockState(offsetPos);
            FluidState offsetFluid = offsetState.getFluidState();
            if (!(offsetFluid.getType() instanceof FlowingFluid) || !((FlowingFluidAccessor)self).invoke$canPassThroughWall(direction, (BlockGetter)level, pos, blockStateIn, offsetPos, offsetState)) continue;
            if (offsetFluid.isSource() && EventHooks.canCreateFluidSource((Level)level, (BlockPos)offsetPos, (BlockState)offsetState)) {
                ++adjacentSourceBlocks;
                adjacentSourceBlocksByFluid.mergeInt((Object)((FlowingFluid)offsetFluid.getType()), 1, Integer::sum);
            }
            if (offsetFluid.getAmount() <= maxAdjacentFluidAmount && (offsetFluid.getAmount() != maxAdjacentFluidAmount || !self.isSame(offsetFluid.getType()))) continue;
            maxAdjacentFluidAmount = offsetFluid.getAmount();
            maxAdjacentFluid = (FlowingFluid)offsetFluid.getType();
        }
        if (adjacentSourceBlocks >= 2) {
            BlockState belowState = level.getBlockState(pos.below());
            FluidState belowFluid = belowState.getFluidState();
            if (belowFluid.isSource() && (offsetState = belowFluid.getType()) instanceof FlowingFluid) {
                FlowingFluid belowFlowingFluid = (FlowingFluid)offsetState;
                if (adjacentSourceBlocksByFluid.getInt((Object)belowFluid.getType()) >= 2) {
                    return FlowingFluidExtension.getSourceOrDefault((LevelReader)level, pos, belowFlowingFluid, false);
                }
            }
            if (belowState.isSolid()) {
                FlowingFluid maximumAdjacentSourceFluid = self;
                int maximumAdjacentSourceBlocks = 0;
                for (Object2IntMap.Entry entry : adjacentSourceBlocksByFluid.object2IntEntrySet()) {
                    if (entry.getIntValue() <= maximumAdjacentSourceBlocks && entry.getKey() != self) continue;
                    maximumAdjacentSourceBlocks = entry.getIntValue();
                    maximumAdjacentSourceFluid = (FlowingFluid)entry.getKey();
                }
                if (maximumAdjacentSourceBlocks >= 3 || maximumAdjacentSourceBlocks >= 2 && self.isSame((Fluid)maximumAdjacentSourceFluid)) {
                    return FlowingFluidExtension.getSourceOrDefault((LevelReader)level, pos, maximumAdjacentSourceFluid, false);
                }
            }
        }
        if (!(aboveFluid = (aboveState = level.getBlockState(abovePos = pos.above())).getFluidState()).isEmpty() && aboveFluid.getType() instanceof FlowingFluid && ((FlowingFluidAccessor)self).invoke$canPassThroughWall(Direction.UP, (BlockGetter)level, pos, blockStateIn, abovePos, aboveState)) {
            return ((FlowingFluid)aboveFluid.getType()).getFlowing(8, true);
        }
        int selfFluidAmount = maxAdjacentFluidAmount - dropOff;
        if (selfFluidAmount <= 0) {
            return Fluids.EMPTY.defaultFluidState();
        }
        return maxAdjacentFluid.getFlowing(selfFluidAmount, false);
    }

    public static void setSourceBlock(Level level, BlockPos pos, Fluid fluid) {
        if (fluid instanceof FlowingFluid) {
            FlowingFluid flow = (FlowingFluid)fluid;
            level.setBlock(pos, flow.getSource().defaultFluidState().createLegacyBlock(), 3);
        } else {
            level.setBlock(pos, fluid.defaultFluidState().createLegacyBlock(), 3);
        }
    }

    public static void tickFluid(LevelAccessor level, BlockPos pos, BlockState state, boolean tickWhenEmpty) {
        if (!state.getFluidState().isEmpty()) {
            Fluid fluid = state.getFluidState().getType();
            level.scheduleTick(pos, fluid, fluid.getTickDelay((LevelReader)level));
        } else if (tickWhenEmpty) {
            level.scheduleTick(pos, state.getBlock(), 1);
        }
    }

    public static void tickFluid(LevelAccessor level, BlockPos pos, BlockState state) {
        FluidHelpers.tickFluid(level, pos, state, false);
    }

    public static AfterTransfer with(Player player, InteractionHand hand) {
        return (newOriginalStack, newContainerStack) -> {
            if (!player.isCreative()) {
                player.setItemInHand(hand, newOriginalStack);
            }
            if (!newContainerStack.isEmpty()) {
                ItemSizeManager.get(newContainerStack).modifyWeight(newContainerStack);
                ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)newContainerStack.copyWithCount(1));
            }
        };
    }

    @FunctionalInterface
    public static interface AfterTransfer {
        default public void updateContainerItem(ItemStack newOriginalStack) {
            this.updateContainerItem(newOriginalStack, ItemStack.EMPTY);
        }

        public void updateContainerItem(ItemStack var1, ItemStack var2);
    }

    public static enum Transfer {
        FILL,
        DRAIN;

    }
}

