/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.items;

import com.mojang.datafixers.util.Either;
import java.util.function.Function;
import net.dries007.tfc.common.TFCTags;
import net.dries007.tfc.common.items.ToolItem;
import net.dries007.tfc.common.player.IPlayerInfo;
import net.dries007.tfc.common.recipes.ChiselRecipe;
import net.dries007.tfc.common.recipes.CollapseRecipe;
import net.dries007.tfc.config.TFCConfig;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.advancements.TFCAdvancements;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.neoforged.neoforge.items.ItemHandlerHelper;

public class ChiselItem
extends ToolItem {
    public ChiselItem(Tier tier, Item.Properties properties) {
        super(tier, TFCTags.Blocks.MINEABLE_WITH_CHISEL, properties);
    }

    public InteractionResult useOn(UseOnContext context) {
        Player player = context.getPlayer();
        if (player != null) {
            Level level = context.getLevel();
            BlockPos pos = context.getClickedPos();
            BlockState state = level.getBlockState(pos);
            Either<BlockState, InteractionResult> result = ChiselRecipe.computeResult(player, state, new BlockHitResult(context.getClickLocation(), context.getClickedFace(), pos, context.isInside()), true);
            return (InteractionResult)result.map(resultState -> {
                player.playSound(resultState.getSoundType((LevelReader)level, pos, (Entity)player).getHitSound(), 1.0f, 1.0f);
                ItemStack held = player.getMainHandItem();
                if (!level.isClientSide) {
                    ItemStack extraDrop;
                    if (TFCConfig.SERVER.enableChiselsStartCollapses.get().booleanValue() && Helpers.isBlock(state, TFCTags.Blocks.CAN_TRIGGER_COLLAPSE) && CollapseRecipe.tryTriggerCollapse(level, pos)) {
                        return InteractionResult.CONSUME;
                    }
                    ChiselRecipe recipeUsed = ChiselRecipe.getRecipe(state, IPlayerInfo.get(player).chiselMode());
                    if (recipeUsed != null && !(extraDrop = recipeUsed.getItemOutput(held)).isEmpty()) {
                        ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)extraDrop);
                    }
                }
                level.setBlockAndUpdate(pos, resultState);
                if (player instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)player;
                    TFCAdvancements.CHISELED.trigger(serverPlayer, (BlockState)resultState);
                }
                Helpers.damageItem(held, (LivingEntity)player, InteractionHand.MAIN_HAND);
                player.getCooldowns().addCooldown((Item)this, 10);
                return InteractionResult.sidedSuccess((boolean)level.isClientSide);
            }, Function.identity());
        }
        return InteractionResult.PASS;
    }
}

