/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.items;

import net.dries007.tfc.config.TFCConfig;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.events.StartFireEvent;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;

public class FlintAndPyriteItem
extends Item {
    public FlintAndPyriteItem(Item.Properties properties) {
        super(properties);
    }

    public InteractionResult useOn(UseOnContext context) {
        Player player = context.getPlayer();
        Level level = context.getLevel();
        BlockHitResult result = FlintAndPyriteItem.getPlayerPOVHitResult((Level)level, (Player)player, (ClipContext.Fluid)ClipContext.Fluid.NONE);
        ItemStack stack = context.getItemInHand();
        BlockPos pos = result.getBlockPos();
        BlockPos abovePos = pos.above();
        if (player != null) {
            if (!player.isCreative()) {
                Helpers.damageItem(stack, (LivingEntity)player, InteractionHand.MAIN_HAND);
            }
            level.playSound(player, pos, SoundEvents.FLINTANDSTEEL_USE, SoundSource.BLOCKS, 1.0f, level.getRandom().nextFloat() * 0.4f + 0.8f);
            double chance = TFCConfig.SERVER.flintAndPyriteChance.get();
            if ((double)level.random.nextFloat() < chance && !level.isClientSide) {
                StartFireEvent.startFire(level, pos, level.getBlockState(pos), result.getDirection(), player, stack, StartFireEvent.FireStrength.STRONG, level.isRainingAt(abovePos) ? 0.3 : 1.0 * chance);
            } else {
                StartFireEvent.startFire(level, pos, level.getBlockState(pos), result.getDirection(), player, stack, StartFireEvent.FireStrength.WEAK, level.isRainingAt(abovePos) ? 0.3 : 1.0 * chance);
            }
        }
        return InteractionResult.CONSUME;
    }
}

